/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderProvider;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public final class CoderProviders {
    private CoderProviders() {
    }

    public static <T> CoderProvider fromStaticMethods(Class<T> clazz) {
        return new CoderProviderFromStaticMethods(clazz);
    }

    public static CoderProvider firstOf(CoderProvider ... coderProviders) {
        return new FirstOf(ImmutableList.copyOf(coderProviders));
    }

    private static class CoderProviderFromStaticMethods
    implements CoderProvider {
        private final boolean takesTypeDescriptor;
        private final Class<?> clazz;

        public CoderProviderFromStaticMethods(Class<?> clazz) {
            String string = String.valueOf(clazz.getCanonicalName());
            Preconditions.checkArgument(this.classTakesTypeDescriptor(clazz) || this.classTakesClass(clazz), new StringBuilder(60 + String.valueOf(string).length()).append("Class ").append(string).append(" is missing required static method of(TypeDescriptor).").toString());
            this.takesTypeDescriptor = this.classTakesTypeDescriptor(clazz);
            this.clazz = clazz;
        }

        @Override
        public <T> Coder<T> getCoder(TypeDescriptor<T> type) throws CannotProvideCoderException {
            try {
                if (this.takesTypeDescriptor) {
                    Coder result = InstanceBuilder.ofType(Coder.class).fromClass(this.clazz).fromFactoryMethod("of").withArg(TypeDescriptor.class, type).build();
                    return result;
                }
                Coder result = InstanceBuilder.ofType(Coder.class).fromClass(this.clazz).fromFactoryMethod("of").withArg(Class.class, type.getRawType()).build();
                return result;
            }
            catch (RuntimeException exc) {
                if (exc.getCause() instanceof InvocationTargetException) {
                    throw new CannotProvideCoderException(exc.getCause().getCause());
                }
                throw exc;
            }
        }

        private boolean classTakesTypeDescriptor(Class<?> clazz) {
            try {
                clazz.getDeclaredMethod("of", TypeDescriptor.class);
                return true;
            }
            catch (NoSuchMethodException | SecurityException exc) {
                return false;
            }
        }

        private boolean classTakesClass(Class<?> clazz) {
            try {
                clazz.getDeclaredMethod("of", Class.class);
                return true;
            }
            catch (NoSuchMethodException | SecurityException exc) {
                return false;
            }
        }
    }

    private static class FirstOf
    implements CoderProvider {
        private Iterable<CoderProvider> providers;

        public FirstOf(Iterable<CoderProvider> providers) {
            this.providers = providers;
        }

        @Override
        public <T> Coder<T> getCoder(TypeDescriptor<T> type) throws CannotProvideCoderException {
            ArrayList<String> messages = Lists.newArrayList();
            for (CoderProvider provider : this.providers) {
                try {
                    return provider.getCoder(type);
                }
                catch (CannotProvideCoderException exc) {
                    messages.add(String.format("%s could not provide a Coder for type %s: %s", provider, type, exc.getMessage()));
                }
            }
            throw new CannotProvideCoderException(String.format("Cannot provide coder for type %s: %s.", type, Joiner.on("; ").join(messages)));
        }
    }
}

