/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.dataflow.sdk.coders.ByteArrayCoder;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderFactories;
import com.google.cloud.dataflow.sdk.coders.CoderFactory;
import com.google.cloud.dataflow.sdk.coders.CoderProvider;
import com.google.cloud.dataflow.sdk.coders.CoderProviders;
import com.google.cloud.dataflow.sdk.coders.DefaultCoder;
import com.google.cloud.dataflow.sdk.coders.DoubleCoder;
import com.google.cloud.dataflow.sdk.coders.InstantCoder;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.ListCoder;
import com.google.cloud.dataflow.sdk.coders.MapCoder;
import com.google.cloud.dataflow.sdk.coders.SerializableCoder;
import com.google.cloud.dataflow.sdk.coders.SetCoder;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import com.google.cloud.dataflow.sdk.coders.TableRowJsonCoder;
import com.google.cloud.dataflow.sdk.coders.VarIntCoder;
import com.google.cloud.dataflow.sdk.coders.VarLongCoder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.TimestampedValue;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoderRegistry
implements CoderProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CoderRegistry.class);
    private Map<Class<?>, CoderFactory> coderFactoryMap = new HashMap();
    private CoderProvider fallbackCoderProvider;

    public CoderRegistry() {
        this.setFallbackCoderProvider(SerializableCoder.PROVIDER);
    }

    public void registerStandardCoders() {
        this.registerCoder(Double.class, DoubleCoder.class);
        this.registerCoder(Instant.class, InstantCoder.class);
        this.registerCoder(Integer.class, VarIntCoder.class);
        this.registerCoder(Iterable.class, IterableCoder.class);
        this.registerCoder(KV.class, KvCoder.class);
        this.registerCoder(List.class, ListCoder.class);
        this.registerCoder(Long.class, VarLongCoder.class);
        this.registerCoder(Map.class, MapCoder.class);
        this.registerCoder(Set.class, SetCoder.class);
        this.registerCoder(String.class, StringUtf8Coder.class);
        this.registerCoder(TableRow.class, TableRowJsonCoder.class);
        this.registerCoder(TimestampedValue.class, TimestampedValue.TimestampedValueCoder.class);
        this.registerCoder(Void.class, VoidCoder.class);
        this.registerCoder(byte[].class, ByteArrayCoder.class);
    }

    public void registerCoder(Class<?> clazz, Class<?> coderClazz) {
        this.registerCoder(clazz, CoderFactories.fromStaticMethods(coderClazz));
    }

    public void registerCoder(Class<?> clazz, CoderFactory coderFactory) {
        this.coderFactoryMap.put(clazz, coderFactory);
    }

    public <T> void registerCoder(Class<T> rawClazz, Coder<T> coder) {
        Preconditions.checkArgument(rawClazz.getTypeParameters().length == 0, "CoderRegistry.registerCoder(Class<T>, Coder<T>) may not be used with unspecialized generic classes");
        CoderFactory factory = CoderFactories.forCoder(coder);
        this.registerCoder(rawClazz, factory);
    }

    public <T> Coder<T> getDefaultCoder(TypeDescriptor<T> typeDescriptor) throws CannotProvideCoderException {
        return this.getDefaultCoder(typeDescriptor, Collections.emptyMap());
    }

    @Override
    public <T> Coder<T> getCoder(TypeDescriptor<T> typeDescriptor) throws CannotProvideCoderException {
        return this.getDefaultCoder((T)typeDescriptor);
    }

    public <InputT, OutputT> Coder<OutputT> getDefaultCoder(TypeDescriptor<OutputT> typeDescriptor, TypeDescriptor<InputT> inputTypeDescriptor, Coder<InputT> inputCoder) throws CannotProvideCoderException {
        return this.getDefaultCoder(typeDescriptor, this.getTypeToCoderBindings(inputTypeDescriptor.getType(), inputCoder));
    }

    public <InputT, OutputT> Coder<OutputT> getDefaultOutputCoder(SerializableFunction<InputT, OutputT> fn, Coder<InputT> inputCoder) throws CannotProvideCoderException {
        ParameterizedType fnType = (ParameterizedType)TypeDescriptor.of(fn.getClass()).getSupertype(SerializableFunction.class).getType();
        return this.getDefaultCoder(fn.getClass(), SerializableFunction.class, ImmutableMap.of(fnType.getActualTypeArguments()[0], inputCoder), SerializableFunction.class.getTypeParameters()[1]);
    }

    public <T, OutputT> Coder<OutputT> getDefaultCoder(Class<? extends T> subClass, Class<T> baseClass, Map<Type, ? extends Coder<?>> knownCoders, TypeVariable<?> param) throws CannotProvideCoderException {
        Map<Type, Coder<?>> inferredCoders = this.getDefaultCoders(subClass, baseClass, knownCoders);
        Coder<?> paramCoderOrNull = inferredCoders.get(param);
        if (paramCoderOrNull != null) {
            return paramCoderOrNull;
        }
        String string = String.valueOf(param.getName());
        throw new CannotProvideCoderException(string.length() != 0 ? "Cannot infer coder for type parameter ".concat(string) : new String("Cannot infer coder for type parameter "));
    }

    public <T> Coder<T> getDefaultCoder(T exampleValue) throws CannotProvideCoderException {
        Class clazz;
        Class clazz2 = clazz = exampleValue == null ? Void.class : exampleValue.getClass();
        if (clazz.getTypeParameters().length == 0) {
            Coder<T> coder = this.getDefaultCoder(clazz);
            return coder;
        }
        CoderFactory factory = this.getDefaultCoderFactory(clazz);
        List<Object> components = factory.getInstanceComponents(exampleValue);
        if (components == null) {
            String string = String.valueOf(clazz);
            String string2 = String.valueOf(factory.getClass());
            throw new CannotProvideCoderException(new StringBuilder(184 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Cannot provide coder based on value with class ").append(string).append(": The registered CoderFactory with class ").append(string2).append(" failed to decompose the value, ").append("which is required in order to provide Coders for the components.").toString());
        }
        ArrayList<Coder<Object>> componentCoders = new ArrayList<Coder<Object>>();
        for (Object component : components) {
            try {
                Coder<Object> componentCoder = this.getDefaultCoder(component);
                componentCoders.add(componentCoder);
            }
            catch (CannotProvideCoderException exc) {
                String string = String.valueOf(clazz);
                throw new CannotProvideCoderException(new StringBuilder(47 + String.valueOf(string).length()).append("Cannot provide coder based on value with class ").append(string).toString(), exc);
            }
        }
        Coder<?> coder = factory.create(componentCoders);
        return coder;
    }

    public <T> Coder<T> getDefaultCoder(Class<T> clazz) throws CannotProvideCoderException {
        try {
            CoderFactory coderFactory = this.getDefaultCoderFactory(clazz);
            LOG.debug("Default coder for {} found by factory", clazz);
            Coder<?> coder = coderFactory.create(Collections.emptyList());
            return coder;
        }
        catch (CannotProvideCoderException exc) {
            CannotProvideCoderException factoryException = exc;
            try {
                return this.getDefaultCoderFromAnnotation(clazz);
            }
            catch (CannotProvideCoderException exc2) {
                CannotProvideCoderException fallbackException;
                CannotProvideCoderException annotationException = exc2;
                if (this.getFallbackCoderProvider() != null) {
                    try {
                        return this.getFallbackCoderProvider().getCoder(TypeDescriptor.of(clazz));
                    }
                    catch (CannotProvideCoderException exc3) {
                        fallbackException = exc3;
                    }
                } else {
                    fallbackException = new CannotProvideCoderException("no fallback CoderProvider configured");
                }
                StringBuilder messageBuilder = new StringBuilder().append("Unable to provide a default Coder for ").append(clazz.getCanonicalName()).append(". Correct one of the following root causes:");
                messageBuilder.append("\n  Building a Coder using a registered CoderFactory failed: ").append(factoryException.getMessage());
                messageBuilder.append("\n  Building a Coder from the @DefaultCoder annotation failed: ").append(annotationException.getMessage());
                messageBuilder.append("\n  Building a Coder from the fallback CoderProvider failed: ").append(fallbackException.getMessage());
                throw new CannotProvideCoderException(messageBuilder.toString());
            }
        }
    }

    public void setFallbackCoderProvider(CoderProvider coderProvider) {
        this.fallbackCoderProvider = coderProvider;
    }

    public CoderProvider getFallbackCoderProvider() {
        return this.fallbackCoderProvider;
    }

    @Deprecated
    public <T> Map<Type, Coder<?>> getDefaultCoders(Class<? extends T> subClass, Class<T> baseClass, Map<Type, ? extends Coder<?>> knownCoders) {
        TypeVariable<Class<T>>[] typeParams = baseClass.getTypeParameters();
        Coder[] knownCodersArray = new Coder[typeParams.length];
        for (int i = 0; i < typeParams.length; ++i) {
            knownCodersArray[i] = knownCoders.get(typeParams[i]);
        }
        Coder<?>[] resultArray = this.getDefaultCoders(subClass, baseClass, knownCodersArray);
        HashMap result = new HashMap();
        for (int i = 0; i < typeParams.length; ++i) {
            if (resultArray[i] == null) continue;
            result.put(typeParams[i], resultArray[i]);
        }
        return result;
    }

    private <T> Coder<?>[] getDefaultCoders(Class<? extends T> subClass, Class<T> baseClass, @Nullable Coder<?>[] knownCoders) {
        Type type = TypeDescriptor.of(subClass).getSupertype(baseClass).getType();
        if (!(type instanceof ParameterizedType)) {
            String string = String.valueOf(type);
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append(string).append(" is not a ParameterizedType").toString());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        if (knownCoders == null) {
            knownCoders = new Coder[typeArgs.length];
        } else if (typeArgs.length != knownCoders.length) {
            String string = String.valueOf(baseClass);
            int n = typeArgs.length;
            int n2 = knownCoders.length;
            throw new IllegalArgumentException(new StringBuilder(72 + String.valueOf(string).length()).append("Class ").append(string).append(" has ").append(n).append(" parameters, ").append("but ").append(n2).append(" coders are requested.").toString());
        }
        HashMap context = new HashMap();
        for (int i = 0; i < knownCoders.length; ++i) {
            if (knownCoders[i] == null) continue;
            try {
                CoderRegistry.verifyCompatible(knownCoders[i], typeArgs[i]);
            }
            catch (IncompatibleCoderException exn) {
                throw new IllegalArgumentException(String.format("Provided coders for type arguments of %s contain incompatibilities: Cannot encode elements of type %s with coder %s", baseClass, typeArgs[i], knownCoders[i]), exn);
            }
            context.putAll(this.getTypeToCoderBindings(typeArgs[i], knownCoders[i]));
        }
        Coder[] result = new Coder[typeArgs.length];
        for (int i = 0; i < knownCoders.length; ++i) {
            if (knownCoders[i] != null) {
                result[i] = knownCoders[i];
                continue;
            }
            try {
                result[i] = this.getDefaultCoder(typeArgs[i], context);
                continue;
            }
            catch (CannotProvideCoderException exc) {
                result[i] = null;
            }
        }
        return result;
    }

    @VisibleForTesting
    static <T, CoderT extends Coder<T>, CandidateT> void verifyCompatible(CoderT coder, Type candidateType) throws IncompatibleCoderException {
        Class<?> coderClass = coder.getClass();
        TypeDescriptor<?> coderDescriptor = TypeDescriptor.of(coderClass);
        TypeDescriptor codedDescriptor = CoderUtils.getCodedType(coderDescriptor);
        Class codedClass = codedDescriptor.getRawType();
        Type codedType = codedDescriptor.getType();
        TypeDescriptor<?> candidateDescriptor = TypeDescriptor.of(candidateType);
        Class<?> candidateClass = candidateDescriptor.getRawType();
        if (candidateType instanceof TypeVariable) {
            return;
        }
        if (!codedClass.isAssignableFrom(candidateClass)) {
            throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s because the coded type %s is not assignable from %s", candidateType, coder, codedClass, candidateType), coder, candidateType);
        }
        TypeDescriptor<?> candidateOkDescriptor = candidateDescriptor;
        if (codedType instanceof ParameterizedType && !CoderRegistry.isNullOrEmpty(coder.getCoderArguments())) {
            List<Coder<?>> typeArgumentCoders;
            ParameterizedType parameterizedSupertype = (ParameterizedType)candidateOkDescriptor.getSupertype(codedClass).getType();
            Type[] typeArguments = parameterizedSupertype.getActualTypeArguments();
            if (typeArguments.length < (typeArgumentCoders = coder.getCoderArguments()).size()) {
                throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s: the generic supertype %s has %s type parameters, which is less than the number of coder arguments %s has (%s).", candidateOkDescriptor, coder, parameterizedSupertype, typeArguments.length, coder, typeArgumentCoders.size()), coder, candidateOkDescriptor.getType());
            }
            for (int i = 0; i < typeArgumentCoders.size(); ++i) {
                try {
                    CoderRegistry.verifyCompatible(typeArgumentCoders.get(i), candidateDescriptor.resolveType(typeArguments[i]).getType());
                    continue;
                }
                catch (IncompatibleCoderException exn) {
                    throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s because some component coder is incompatible", candidateType, coder), coder, candidateType, exn);
                }
            }
        }
    }

    private static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    private CoderFactory getDefaultCoderFactory(Class<?> clazz) throws CannotProvideCoderException {
        CoderFactory coderFactoryOrNull = this.coderFactoryMap.get(clazz);
        if (coderFactoryOrNull != null) {
            return coderFactoryOrNull;
        }
        String string = String.valueOf(clazz);
        throw new CannotProvideCoderException(new StringBuilder(99 + String.valueOf(string).length()).append("Cannot provide coder based on value with class ").append(string).append(": No CoderFactory has been registered for the class.").toString());
    }

    private <T> Coder<T> getDefaultCoderFromAnnotation(Class<T> clazz) throws CannotProvideCoderException {
        DefaultCoder defaultAnnotation = clazz.getAnnotation(DefaultCoder.class);
        if (defaultAnnotation == null) {
            throw new CannotProvideCoderException(String.format("Class %s does not have a @DefaultCoder annotation.", clazz.getCanonicalName()));
        }
        LOG.debug("DefaultCoder annotation found for {} with value {}", clazz, defaultAnnotation.value());
        CoderProvider coderProvider = CoderProviders.fromStaticMethods(defaultAnnotation.value());
        return coderProvider.getCoder(TypeDescriptor.of(clazz));
    }

    private <T> Coder<T> getDefaultCoder(TypeDescriptor<T> typeDescriptor, Map<Type, Coder<?>> typeCoderBindings) throws CannotProvideCoderException {
        Coder<?> defaultCoder = this.getDefaultCoder(typeDescriptor.getType(), typeCoderBindings);
        LOG.debug("Default coder for {}: {}", typeDescriptor, defaultCoder);
        Coder<?> result = defaultCoder;
        return result;
    }

    private Coder<?> getDefaultCoder(Type type, Map<Type, Coder<?>> typeCoderBindings) throws CannotProvideCoderException {
        Coder<?> coder = typeCoderBindings.get(type);
        if (coder != null) {
            return coder;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return this.getDefaultCoder(clazz);
        }
        if (type instanceof ParameterizedType) {
            return this.getDefaultCoder((ParameterizedType)type, typeCoderBindings);
        }
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            String string = String.valueOf(type);
            throw new CannotProvideCoderException(new StringBuilder(92 + String.valueOf(string).length()).append("Cannot provide a coder for type variable ").append(string).append(" because the actual type is unknown due to erasure.").toString(), CannotProvideCoderException.ReasonCode.TYPE_ERASURE);
        }
        String string = String.valueOf(type);
        throw new RuntimeException(new StringBuilder(41 + String.valueOf(string).length()).append("Internal error: unexpected kind of Type: ").append(string).toString());
    }

    private Coder<?> getDefaultCoder(ParameterizedType type, Map<Type, Coder<?>> typeCoderBindings) throws CannotProvideCoderException {
        try {
            return this.getDefaultCoderFromFactory(type, typeCoderBindings);
        }
        catch (CannotProvideCoderException exc) {
            CannotProvideCoderException factoryException = exc;
            try {
                Class rawClazz = (Class)type.getRawType();
                return this.getDefaultCoderFromAnnotation(rawClazz);
            }
            catch (CannotProvideCoderException exc2) {
                CannotProvideCoderException annotationException = exc2;
                StringBuilder messageBuilder = new StringBuilder().append("Unable to provide a default Coder for ").append(type).append(". Correct one of the following root causes:");
                messageBuilder.append("\n  Building a Coder using a registered CoderFactory failed: ").append(factoryException.getMessage());
                messageBuilder.append("\n  Building a Coder from the @DefaultCoder annotation failed: ").append(annotationException.getMessage());
                throw new CannotProvideCoderException(messageBuilder.toString());
            }
        }
    }

    private Coder<?> getDefaultCoderFromFactory(ParameterizedType type, Map<Type, Coder<?>> typeCoderBindings) throws CannotProvideCoderException {
        Class rawClazz = (Class)type.getRawType();
        CoderFactory coderFactory = this.getDefaultCoderFactory(rawClazz);
        ArrayList typeArgumentCoders = new ArrayList();
        for (Type typeArgument : type.getActualTypeArguments()) {
            try {
                Coder<?> typeArgumentCoder = this.getDefaultCoder(typeArgument, typeCoderBindings);
                typeArgumentCoders.add(typeArgumentCoder);
            }
            catch (CannotProvideCoderException exc) {
                String string = String.valueOf(type);
                throw new CannotProvideCoderException(new StringBuilder(44 + String.valueOf(string).length()).append("Cannot provide coder for parameterized type ").append(string).toString(), exc);
            }
        }
        return coderFactory.create(typeArgumentCoders);
    }

    private Map<Type, Coder<?>> getTypeToCoderBindings(Type type, Coder<?> coder) {
        if (type instanceof TypeVariable || type instanceof Class) {
            return ImmutableMap.of(type, coder);
        }
        if (type instanceof ParameterizedType) {
            return this.getTypeToCoderBindings((ParameterizedType)type, coder);
        }
        return ImmutableMap.of();
    }

    private Map<Type, Coder<?>> getTypeToCoderBindings(ParameterizedType type, Coder<?> coder) {
        List<Type> typeArguments = Arrays.asList(type.getActualTypeArguments());
        List<Coder<?>> coderArguments = coder.getCoderArguments();
        if (coderArguments == null || typeArguments.size() != coderArguments.size()) {
            return ImmutableMap.of();
        }
        HashMap<Type, Coder<?>> typeToCoder = Maps.newHashMap();
        typeToCoder.put(type, coder);
        for (int i = 0; i < typeArguments.size(); ++i) {
            Type typeArgument = typeArguments.get(i);
            Coder<?> coderArgument = coderArguments.get(i);
            typeToCoder.putAll(this.getTypeToCoderBindings(typeArgument, coderArgument));
        }
        return ImmutableMap.builder().putAll(typeToCoder).build();
    }

    @VisibleForTesting
    static class IncompatibleCoderException
    extends RuntimeException {
        private Coder<?> coder;
        private Type type;

        public IncompatibleCoderException(String message, Coder<?> coder, Type type) {
            super(message);
            this.coder = coder;
            this.type = type;
        }

        public IncompatibleCoderException(String message, Coder<?> coder, Type type, Throwable cause) {
            super(message, cause);
            this.coder = coder;
            this.type = type;
        }

        public Coder<?> getCoder() {
            return this.coder;
        }

        public Type getType() {
            return this.type;
        }
    }
}

