/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.IterableLikeCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import java.util.List;
import java.util.Map;

public class IterableCoder<T>
extends IterableLikeCoder<T, Iterable<T>> {
    public static <T> IterableCoder<T> of(Coder<T> elemCoder) {
        return new IterableCoder<T>(elemCoder);
    }

    @Override
    protected final Iterable<T> decodeToIterable(List<T> decodedElements) {
        return decodedElements;
    }

    @JsonCreator
    public static IterableCoder<?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
        int n = components.size();
        Preconditions.checkArgument(components.size() == 1, new StringBuilder(38).append("Expecting 1 component, got ").append(n).toString());
        return IterableCoder.of(components.get(0));
    }

    public static <T> List<Object> getInstanceComponents(Iterable<T> exampleValue) {
        return IterableCoder.getInstanceComponentsHelper(exampleValue);
    }

    protected IterableCoder(Coder<T> elemCoder) {
        super(elemCoder, "Iterable");
    }

    @Override
    public CloudObject asCloudObject() {
        CloudObject result = super.asCloudObject();
        Structs.addBoolean((Map<String, Object>)((Object)result), "is_stream_like", true);
        return result;
    }
}

