/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObservableIterable;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public abstract class IterableLikeCoder<T, IterableT extends Iterable<T>>
extends StandardCoder<IterableT> {
    private final Coder<T> elementCoder;
    private final String iterableName;

    public Coder<T> getElemCoder() {
        return this.elementCoder;
    }

    protected abstract IterableT decodeToIterable(List<T> var1);

    protected static <T, IterableT extends Iterable<T>> List<Object> getInstanceComponentsHelper(IterableT exampleValue) {
        Iterator<T> iterator = exampleValue.iterator();
        if (iterator.hasNext()) {
            T value = iterator.next();
            return Arrays.asList(value);
        }
        return null;
    }

    protected IterableLikeCoder(Coder<T> elementCoder, String iterableName) {
        Preconditions.checkArgument(elementCoder != null, "element Coder for IterableLikeCoder must not be null");
        Preconditions.checkArgument(iterableName != null, "iterable name for IterableLikeCoder must not be null");
        this.elementCoder = elementCoder;
        this.iterableName = iterableName;
    }

    @Override
    public void encode(IterableT iterable, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (iterable == null) {
            String string = String.valueOf(this.iterableName);
            throw new CoderException(string.length() != 0 ? "cannot encode a null ".concat(string) : new String("cannot encode a null "));
        }
        Coder.Context nestedContext = context.nested();
        DataOutputStream dataOutStream = new DataOutputStream(outStream);
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            dataOutStream.writeInt(collection.size());
            for (Object elem : collection) {
                this.elementCoder.encode(elem, dataOutStream, nestedContext);
            }
        } else {
            dataOutStream.writeInt(-1);
            for (Object elem : iterable) {
                dataOutStream.writeBoolean(true);
                this.elementCoder.encode(elem, dataOutStream, nestedContext);
            }
            dataOutStream.writeBoolean(false);
        }
        dataOutStream.flush();
    }

    @Override
    public IterableT decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        Coder.Context nestedContext = context.nested();
        DataInputStream dataInStream = new DataInputStream(inStream);
        int size = dataInStream.readInt();
        if (size >= 0) {
            ArrayList<T> elements = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                elements.add(this.elementCoder.decode(dataInStream, nestedContext));
            }
            return this.decodeToIterable(elements);
        }
        ArrayList<T> elements = new ArrayList<T>();
        while (dataInStream.readBoolean()) {
            elements.add(this.elementCoder.decode(dataInStream, nestedContext));
        }
        return this.decodeToIterable(elements);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.elementCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "IterableLikeCoder can not guarantee deterministic ordering.");
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(IterableT iterable, Coder.Context context) {
        return iterable instanceof ElementByteSizeObservableIterable;
    }

    @Override
    public void registerByteSizeObserver(IterableT iterable, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        if (iterable == null) {
            throw new CoderException("cannot encode a null Iterable");
        }
        Coder.Context nestedContext = context.nested();
        if (iterable instanceof ElementByteSizeObservableIterable) {
            observer.setLazy();
            ElementByteSizeObservableIterable observableIterable = (ElementByteSizeObservableIterable)iterable;
            observableIterable.addObserver(new IteratorObserver(observer, iterable instanceof Collection));
        } else if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            observer.update(4L);
            for (Object elem : collection) {
                this.elementCoder.registerByteSizeObserver(elem, observer, nestedContext);
            }
        } else {
            observer.update(4L);
            for (Object elem : iterable) {
                observer.update(1L);
                this.elementCoder.registerByteSizeObserver(elem, observer, nestedContext);
            }
            observer.update(1L);
        }
    }

    private class IteratorObserver
    implements Observer {
        private final ElementByteSizeObserver outerObserver;
        private final boolean countable;

        public IteratorObserver(ElementByteSizeObserver outerObserver, boolean countable) {
            this.outerObserver = outerObserver;
            this.countable = countable;
            if (countable) {
                outerObserver.update(4L);
            } else {
                outerObserver.update(5L);
            }
        }

        @Override
        public void update(Observable obs, Object obj) {
            if (!(obj instanceof Long)) {
                throw new AssertionError((Object)"unexpected parameter object");
            }
            if (this.countable) {
                this.outerObserver.update(obs, obj);
            } else {
                this.outerObserver.update(obs, 1L + (Long)obj);
            }
        }
    }
}

