/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JAXBCoder<T>
extends AtomicCoder<T> {
    private final Class<T> jaxbClass;
    private transient Marshaller jaxbMarshaller = null;
    private transient Unmarshaller jaxbUnmarshaller = null;
    private static final String JAXB_CLASS = "jaxb_class";

    public Class<T> getJAXBClass() {
        return this.jaxbClass;
    }

    private JAXBCoder(Class<T> jaxbClass) {
        this.jaxbClass = jaxbClass;
    }

    public static <T> JAXBCoder<T> of(Class<T> jaxbClass) {
        return new JAXBCoder<T>(jaxbClass);
    }

    @Override
    public void encode(T value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        try {
            if (this.jaxbMarshaller == null) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.jaxbClass});
                this.jaxbMarshaller = jaxbContext.createMarshaller();
            }
            this.jaxbMarshaller.marshal(value, outStream);
        }
        catch (JAXBException e) {
            throw new CoderException(e);
        }
    }

    @Override
    public T decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        try {
            if (this.jaxbUnmarshaller == null) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.jaxbClass});
                this.jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            }
            Object obj = this.jaxbUnmarshaller.unmarshal(inStream);
            return (T)obj;
        }
        catch (JAXBException e) {
            throw new CoderException(e);
        }
    }

    @Override
    public String getEncodingId() {
        return this.getJAXBClass().getName();
    }

    @JsonCreator
    public static <T> JAXBCoder<T> of(@JsonProperty(value="jaxb_class") String jaxbClassName) {
        try {
            Class<?> jaxbClass = Class.forName(jaxbClassName);
            return JAXBCoder.of(jaxbClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public CloudObject asCloudObject() {
        CloudObject result = super.asCloudObject();
        Structs.addString((Map<String, Object>)((Object)result), JAXB_CLASS, this.jaxbClass.getName());
        return result;
    }
}

