/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CoderProvider;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializableCoder<T extends Serializable>
extends AtomicCoder<T> {
    public static final CoderProvider PROVIDER = new CoderProvider(){

        @Override
        public <T> Coder<T> getCoder(TypeDescriptor<T> typeDescriptor) throws CannotProvideCoderException {
            Class<T> clazz = typeDescriptor.getRawType();
            if (Serializable.class.isAssignableFrom(clazz)) {
                Class<T> serializableClazz = clazz;
                SerializableCoder<T> coder = SerializableCoder.of(serializableClazz);
                return coder;
            }
            String string = String.valueOf(typeDescriptor);
            throw new CannotProvideCoderException(new StringBuilder(73 + String.valueOf(string).length()).append("Cannot provide SerializableCoder because ").append(string).append(" does not implement Serializable").toString());
        }
    };
    private final Class<T> type;

    public static <T extends Serializable> SerializableCoder<T> of(TypeDescriptor<T> type) {
        Class<T> clazz = type.getRawType();
        return SerializableCoder.of(clazz);
    }

    public static <T extends Serializable> SerializableCoder<T> of(Class<T> clazz) {
        return new SerializableCoder<T>(clazz);
    }

    @JsonCreator
    public static SerializableCoder<?> of(@JsonProperty(value="type") String classType) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(classType);
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new ClassNotFoundException(new StringBuilder(38 + String.valueOf(classType).length()).append("Class ").append(classType).append(" does not implement Serializable").toString());
        }
        return SerializableCoder.of(clazz);
    }

    protected SerializableCoder(Class<T> type) {
        this.type = type;
    }

    public Class<T> getRecordType() {
        return this.type;
    }

    @Override
    public void encode(T value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        try (ObjectOutputStream oos = new ObjectOutputStream(outStream);){
            oos.writeObject(value);
        }
        catch (IOException exn) {
            String string = String.valueOf(value);
            throw new CoderException(new StringBuilder(27 + String.valueOf(string).length()).append("unable to serialize record ").append(string).toString(), exn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        try (ObjectInputStream ois = new ObjectInputStream(inStream);){
            Serializable serializable = (Serializable)this.type.cast(ois.readObject());
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new CoderException("unable to deserialize record", e);
        }
    }

    @Override
    public String getEncodingId() {
        return String.format("%s:%s", this.type.getName(), ObjectStreamClass.lookup(this.type).getSerialVersionUID());
    }

    @Override
    public CloudObject asCloudObject() {
        CloudObject result = super.asCloudObject();
        result.put("type", this.type.getName());
        return result;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Java Serialization may be non-deterministic.");
    }

    @Override
    public boolean equals(Object other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.type == ((SerializableCoder)other).type;
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }
}

