/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.IterableLikeCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SetCoder<T>
extends IterableLikeCoder<T, Set<T>> {
    public static <T> SetCoder<T> of(Coder<T> elementCoder) {
        return new SetCoder<T>(elementCoder);
    }

    @JsonCreator
    public static SetCoder<?> of(@JsonProperty(value="component_encodings") List<Object> components) {
        int n = components.size();
        Preconditions.checkArgument(components.size() == 1, new StringBuilder(38).append("Expecting 1 component, got ").append(n).toString());
        return SetCoder.of((Coder)components.get(0));
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Ordering of elements in a set may be non-deterministic.");
    }

    public static <T> List<Object> getInstanceComponents(Set<T> exampleValue) {
        return SetCoder.getInstanceComponentsHelper(exampleValue);
    }

    @Override
    protected final Set<T> decodeToIterable(List<T> decodedElements) {
        return new HashSet<T>(decodedElements);
    }

    protected SetCoder(Coder<T> elemCoder) {
        super(elemCoder, "Set");
    }
}

