/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.util.ExposedByteArrayOutputStream;
import com.google.cloud.dataflow.sdk.util.StreamUtils;
import com.google.cloud.dataflow.sdk.util.VarInt;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.charset.StandardCharsets;

public class StringUtf8Coder
extends AtomicCoder<String> {
    private static final StringUtf8Coder INSTANCE = new StringUtf8Coder();

    @JsonCreator
    public static StringUtf8Coder of() {
        return INSTANCE;
    }

    private static void writeString(String value, DataOutputStream dos) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        VarInt.encode(bytes.length, (OutputStream)dos);
        dos.write(bytes);
    }

    private static String readString(DataInputStream dis) throws IOException {
        int len = VarInt.decodeInt(dis);
        if (len < 0) {
            throw new CoderException(new StringBuilder(42).append("Invalid encoded string length: ").append(len).toString());
        }
        byte[] bytes = new byte[len];
        dis.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private StringUtf8Coder() {
    }

    @Override
    public void encode(String value, OutputStream outStream, Coder.Context context) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null String");
        }
        if (context.isWholeStream) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            if (outStream instanceof ExposedByteArrayOutputStream) {
                ((ExposedByteArrayOutputStream)outStream).writeAndOwn(bytes);
            } else {
                outStream.write(bytes);
            }
        } else {
            StringUtf8Coder.writeString(value, new DataOutputStream(outStream));
        }
    }

    @Override
    public String decode(InputStream inStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            byte[] bytes = StreamUtils.getBytes(inStream);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        try {
            return StringUtf8Coder.readString(new DataInputStream(inStream));
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(String value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null String");
        }
        if (context.isWholeStream) {
            return value.getBytes(StandardCharsets.UTF_8).length;
        }
        DataOutputStream stream = new DataOutputStream(new ByteArrayOutputStream());
        StringUtf8Coder.writeString(value, stream);
        return stream.size();
    }
}

