/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import com.google.cloud.dataflow.sdk.coders.TableRowJsonCoder;
import com.google.cloud.dataflow.sdk.coders.VarIntCoder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import com.google.cloud.dataflow.sdk.options.DirectPipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.worker.BigQueryReader;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.BigQueryTableInserter;
import com.google.cloud.dataflow.sdk.util.BigQueryTableRowIterator;
import com.google.cloud.dataflow.sdk.util.ReaderUtils;
import com.google.cloud.dataflow.sdk.util.Reshuffle;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PDone;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIO {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryIO.class);
    private static final JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
    private static final String DATASET_REGEXP = "[-\\w.]{1,1024}";
    private static final String TABLE_REGEXP = "[-\\w$@]{1,1024}";
    private static final String DATASET_TABLE_REGEXP = String.format("((?<PROJECT>%s):)?(?<DATASET>%s)\\.(?<TABLE>%s)", "[a-z][-a-z0-9:.]{4,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@]{1,1024}");
    private static final Pattern TABLE_SPEC = Pattern.compile(DATASET_TABLE_REGEXP);
    public static final String SET_PROJECT_FROM_OPTIONS_WARNING = "No project specified for BigQuery table \"%1$s.%2$s\". Assuming it is in \"%3$s\". If the table is in a different project please specify it as a part of the BigQuery table definition.";
    private static final String RESOURCE_NOT_FOUND_ERROR = "BigQuery %1$s not found for table \"%2$s\" . Please create the %1$s before pipeline execution. If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";
    private static final String UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR = "Unable to confirm BigQuery %1$s presence for table \"%2$s\". If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";

    public static TableReference parseTableSpec(String tableSpec) {
        Matcher match = TABLE_SPEC.matcher(tableSpec);
        if (!match.matches()) {
            String string = String.valueOf("Table reference is not in [project_id]:[dataset_id].[table_id] format: ");
            String string2 = String.valueOf(tableSpec);
            throw new IllegalArgumentException(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        TableReference ref = new TableReference();
        ref.setProjectId(match.group("PROJECT"));
        return ref.setDatasetId(match.group("DATASET")).setTableId(match.group("TABLE"));
    }

    public static String toTableSpec(TableReference ref) {
        StringBuilder sb = new StringBuilder();
        if (ref.getProjectId() != null) {
            sb.append(ref.getProjectId());
            sb.append(":");
        }
        sb.append(ref.getDatasetId()).append('.').append(ref.getTableId());
        return sb.toString();
    }

    public static void verifyDatasetPresence(BigQueryOptions options, TableReference table) {
        try {
            Bigquery client = Transport.newBigQueryClient(options).build();
            BigQueryTableRowIterator.executeWithBackOff(client.datasets().get(table.getProjectId(), table.getDatasetId()), RESOURCE_NOT_FOUND_ERROR, new Object[]{"dataset", BigQueryIO.toTableSpec(table)});
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "dataset", BigQueryIO.toTableSpec(table)), e);
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "dataset", BigQueryIO.toTableSpec(table)), e);
        }
    }

    public static void verifyTablePresence(BigQueryOptions options, TableReference table) {
        try {
            Bigquery client = Transport.newBigQueryClient(options).build();
            BigQueryTableRowIterator.executeWithBackOff(client.tables().get(table.getProjectId(), table.getDatasetId(), table.getTableId()), RESOURCE_NOT_FOUND_ERROR, new Object[]{"table", BigQueryIO.toTableSpec(table)});
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "table", BigQueryIO.toTableSpec(table)), e);
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "table", BigQueryIO.toTableSpec(table)), e);
        }
    }

    private static void evaluateReadHelper(Read.Bound transform, DirectPipelineRunner.EvaluationContext context) {
        DirectPipelineOptions options = context.getPipelineOptions();
        Bigquery client = Transport.newBigQueryClient(options).build();
        if (transform.table != null && transform.table.getProjectId() == null) {
            transform.table.setProjectId(options.getProject());
        }
        BigQueryReader reader = null;
        if (transform.query != null) {
            LOG.info("Reading from BigQuery query {}", (Object)transform.query);
            reader = new BigQueryReader(client, transform.query, options.getProject());
        } else {
            reader = new BigQueryReader(client, transform.table);
            LOG.info("Reading from BigQuery table {}", (Object)BigQueryIO.toTableSpec(transform.table));
        }
        List elems = ReaderUtils.readElemsFromReader(reader);
        LOG.info("Number of records read from BigQuery: {}", (Object)elems.size());
        context.setPCollectionWindowedValue(context.getOutput(transform), elems);
    }

    private static <K, V> List<V> getOrCreateMapListValue(Map<K, List<V>> map, K key) {
        List<V> value = map.get(key);
        if (value == null) {
            value = new ArrayList<V>();
            map.put(key, value);
        }
        return value;
    }

    private static void evaluateWriteHelper(Write.Bound transform, DirectPipelineRunner.EvaluationContext context) {
        DirectPipelineOptions options = context.getPipelineOptions();
        Bigquery client = Transport.newBigQueryClient(options).build();
        BigQueryTableInserter inserter = new BigQueryTableInserter(client);
        try {
            HashMap tableRows = new HashMap();
            for (WindowedValue<TableRow> windowedValue : context.getPCollectionWindowedValues(context.getInput(transform))) {
                for (BoundedWindow window : windowedValue.getWindows()) {
                    TableReference ref = transform.tableRefFunction != null ? transform.tableRefFunction.apply(window) : transform.table;
                    if (ref.getProjectId() == null) {
                        ref.setProjectId(options.getProject());
                    }
                    LOG.info("Writing to BigQuery table {}", (Object)BigQueryIO.toTableSpec(ref));
                    inserter.getOrCreateTable(ref, transform.writeDisposition, transform.createDisposition, transform.schema);
                    List rows = BigQueryIO.getOrCreateMapListValue(tableRows, ref);
                    rows.add(windowedValue.getValue());
                }
            }
            for (TableReference ref : tableRows.keySet()) {
                inserter.insertAll(ref, (List)tableRows.get(ref));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamWithDeDup
    extends PTransform<PCollection<TableRow>, PDone> {
        private final transient TableReference tableReference;
        private final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
        private final transient TableSchema tableSchema;

        StreamWithDeDup(TableReference tableReference, SerializableFunction<BoundedWindow, TableReference> tableRefFunction, TableSchema tableSchema) {
            this.tableReference = tableReference;
            this.tableRefFunction = tableRefFunction;
            this.tableSchema = tableSchema;
        }

        @Override
        protected Coder<Void> getDefaultOutputCoder() {
            return VoidCoder.of();
        }

        @Override
        public PDone apply(PCollection<TableRow> input) {
            PCollection tagged = (PCollection)((Object)input.apply(ParDo.of(new TagWithUniqueIdsAndTable(input.getPipeline().getOptions().as(BigQueryOptions.class), this.tableReference, this.tableRefFunction))));
            ((PCollection)((PCollection)tagged.setCoder(KvCoder.of(ShardedKeyCoder.of(StringUtf8Coder.of()), TableRowInfoCoder.of()))).apply(Reshuffle.of())).apply(ParDo.of(new StreamingWriteFn(this.tableSchema)));
            return PDone.in(input.getPipeline());
        }
    }

    private static class TagWithUniqueIdsAndTable
    extends DoFn<TableRow, KV<ShardedKey<String>, TableRowInfo>>
    implements DoFn.RequiresWindowAccess {
        private final String tableSpec;
        private final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
        private transient String randomUUID;
        private transient long sequenceNo = 0L;

        TagWithUniqueIdsAndTable(BigQueryOptions options, TableReference table, SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
            Preconditions.checkArgument(table == null ^ tableRefFunction == null, "Exactly one of table or tableRefFunction should be set");
            if (table != null) {
                if (table.getProjectId() == null) {
                    table.setProjectId(options.as(BigQueryOptions.class).getProject());
                }
                this.tableSpec = BigQueryIO.toTableSpec(table);
            } else {
                this.tableSpec = null;
            }
            this.tableRefFunction = tableRefFunction;
        }

        @Override
        public void startBundle(DoFn.Context context) {
            this.randomUUID = UUID.randomUUID().toString();
        }

        @Override
        public void processElement(DoFn.ProcessContext context) throws IOException {
            String string = this.randomUUID;
            long l = this.sequenceNo++;
            String uniqueId = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            ThreadLocalRandom randomGenerator = ThreadLocalRandom.current();
            String tableSpec = this.tableSpecFromWindow(context.getPipelineOptions().as(BigQueryOptions.class), context.window());
            context.output(KV.of(ShardedKey.of(tableSpec, randomGenerator.nextInt(0, 50)), new TableRowInfo((TableRow)context.element(), uniqueId)));
        }

        private String tableSpecFromWindow(BigQueryOptions options, BoundedWindow window) {
            if (this.tableSpec != null) {
                return this.tableSpec;
            }
            TableReference table = this.tableRefFunction.apply(window);
            if (table.getProjectId() == null) {
                table.setProjectId(options.getProject());
            }
            return BigQueryIO.toTableSpec(table);
        }
    }

    private static class TableRowInfo {
        final TableRow tableRow;
        final String uniqueId;

        TableRowInfo(TableRow tableRow, String uniqueId) {
            this.tableRow = tableRow;
            this.uniqueId = uniqueId;
        }
    }

    private static class TableRowInfoCoder
    extends AtomicCoder<TableRowInfo> {
        private static final TableRowInfoCoder INSTANCE = new TableRowInfoCoder();
        TableRowJsonCoder tableRowCoder = TableRowJsonCoder.of();
        StringUtf8Coder idCoder = StringUtf8Coder.of();

        private TableRowInfoCoder() {
        }

        @JsonCreator
        public static TableRowInfoCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(TableRowInfo value, OutputStream outStream, Coder.Context context) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null value");
            }
            this.tableRowCoder.encode(value.tableRow, outStream, context.nested());
            this.idCoder.encode(value.uniqueId, outStream, context.nested());
        }

        @Override
        public TableRowInfo decode(InputStream inStream, Coder.Context context) throws IOException {
            return new TableRowInfo(this.tableRowCoder.decode(inStream, context.nested()), this.idCoder.decode(inStream, context.nested()));
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            throw new Coder.NonDeterministicException(this, "TableRows are not deterministic.");
        }
    }

    public static class ShardedKeyCoder<KeyT>
    extends StandardCoder<ShardedKey<KeyT>> {
        Coder<KeyT> keyCoder;
        VarIntCoder shardNumberCoder;

        public static <KeyT> ShardedKeyCoder<KeyT> of(Coder<KeyT> keyCoder) {
            return new ShardedKeyCoder<KeyT>(keyCoder);
        }

        @JsonCreator
        public static <KeyT> ShardedKeyCoder<KeyT> of(@JsonProperty(value="component_encodings") List<Coder<KeyT>> components) {
            int n = components.size();
            Preconditions.checkArgument(components.size() == 1, new StringBuilder(38).append("Expecting 1 component, got ").append(n).toString());
            return ShardedKeyCoder.of(components.get(0));
        }

        protected ShardedKeyCoder(Coder<KeyT> keyCoder) {
            this.keyCoder = keyCoder;
            this.shardNumberCoder = VarIntCoder.of();
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.keyCoder);
        }

        @Override
        public void encode(ShardedKey<KeyT> key, OutputStream outStream, Coder.Context context) throws IOException {
            this.keyCoder.encode(key.getKey(), outStream, context.nested());
            this.shardNumberCoder.encode(key.getShardNumber(), outStream, context);
        }

        @Override
        public ShardedKey<KeyT> decode(InputStream inStream, Coder.Context context) throws IOException {
            return new ShardedKey(this.keyCoder.decode(inStream, context.nested()), this.shardNumberCoder.decode(inStream, context));
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.keyCoder.verifyDeterministic();
        }
    }

    private static class ShardedKey<K> {
        private final K key;
        private final int shardNumber;

        public static <K> ShardedKey<K> of(K key, int shardNumber) {
            return new ShardedKey<K>(key, shardNumber);
        }

        private ShardedKey(K key, int shardNumber) {
            this.key = key;
            this.shardNumber = shardNumber;
        }

        public K getKey() {
            return this.key;
        }

        public int getShardNumber() {
            return this.shardNumber;
        }
    }

    private static class StreamingWriteFn
    extends DoFn<KV<ShardedKey<String>, TableRowInfo>, Void> {
        private final String jsonTableSchema;
        private transient Map<String, List<TableRow>> tableRows;
        private transient Map<String, List<String>> uniqueIdsForTableRows;
        private static Set<String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());

        StreamingWriteFn(TableSchema schema) {
            try {
                this.jsonTableSchema = JSON_FACTORY.toString((Object)schema);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot initialize BigQuery streaming writer.", e);
            }
        }

        @Override
        public void startBundle(DoFn.Context context) {
            this.tableRows = new HashMap<String, List<TableRow>>();
            this.uniqueIdsForTableRows = new HashMap<String, List<String>>();
        }

        @Override
        public void processElement(DoFn.ProcessContext context) {
            String tableSpec = (String)((ShardedKey)((KV)context.element()).getKey()).getKey();
            List rows = BigQueryIO.getOrCreateMapListValue(this.tableRows, tableSpec);
            List uniqueIds = BigQueryIO.getOrCreateMapListValue(this.uniqueIdsForTableRows, tableSpec);
            rows.add(((TableRowInfo)((KV)context.element()).getValue()).tableRow);
            uniqueIds.add(((TableRowInfo)((KV)context.element()).getValue()).uniqueId);
        }

        @Override
        public void finishBundle(DoFn.Context context) throws Exception {
            BigQueryOptions options = context.getPipelineOptions().as(BigQueryOptions.class);
            Bigquery client = Transport.newBigQueryClient(options).build();
            for (String tableSpec : this.tableRows.keySet()) {
                TableReference tableReference = this.getOrCreateTable(options, tableSpec);
                this.flushRows(client, tableReference, this.tableRows.get(tableSpec), this.uniqueIdsForTableRows.get(tableSpec));
            }
            this.tableRows.clear();
            this.uniqueIdsForTableRows.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TableReference getOrCreateTable(BigQueryOptions options, String tableSpec) throws IOException {
            TableReference tableReference = BigQueryIO.parseTableSpec(tableSpec);
            if (!createdTables.contains(tableSpec)) {
                Set<String> set = createdTables;
                synchronized (set) {
                    if (!createdTables.contains(tableSpec)) {
                        TableSchema tableSchema = (TableSchema)JSON_FACTORY.fromString(this.jsonTableSchema, TableSchema.class);
                        Bigquery client = Transport.newBigQueryClient(options).build();
                        BigQueryTableInserter inserter = new BigQueryTableInserter(client);
                        inserter.tryCreateTable(tableReference, tableSchema);
                        createdTables.add(tableSpec);
                    }
                }
            }
            return tableReference;
        }

        private void flushRows(Bigquery client, TableReference tableReference, List<TableRow> tableRows, List<String> uniqueIds) {
            if (!tableRows.isEmpty()) {
                try {
                    BigQueryTableInserter inserter = new BigQueryTableInserter(client);
                    inserter.insertAll(tableReference, tableRows, uniqueIds);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class Write {
        public static Bound named(String name) {
            return new Bound().named(name);
        }

        public static Bound to(String tableSpec) {
            return new Bound().to(tableSpec);
        }

        public static Bound to(TableReference table) {
            return new Bound().to(table);
        }

        public static Bound to(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
            return new Bound().to(tableSpecFunction);
        }

        public static Bound toTableReference(SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
            return new Bound().toTableReference(tableRefFunction);
        }

        public static Bound withSchema(TableSchema schema) {
            return new Bound().withSchema(schema);
        }

        public static Bound withCreateDisposition(CreateDisposition disposition) {
            return new Bound().withCreateDisposition(disposition);
        }

        public static Bound withWriteDisposition(WriteDisposition disposition) {
            return new Bound().withWriteDisposition(disposition);
        }

        public static Bound withoutValidation() {
            return new Bound().withoutValidation();
        }

        public static class Bound
        extends PTransform<PCollection<TableRow>, PDone> {
            final TableReference table;
            final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
            final TableSchema schema;
            final CreateDisposition createDisposition;
            final WriteDisposition writeDisposition;
            final boolean validate;

            public Bound() {
                this.table = null;
                this.tableRefFunction = null;
                this.schema = null;
                this.createDisposition = CreateDisposition.CREATE_IF_NEEDED;
                this.writeDisposition = WriteDisposition.WRITE_EMPTY;
                this.validate = true;
            }

            Bound(String name, TableReference ref, SerializableFunction<BoundedWindow, TableReference> tableRefFunction, TableSchema schema, CreateDisposition createDisposition, WriteDisposition writeDisposition, boolean validate) {
                super(name);
                this.table = ref;
                this.tableRefFunction = tableRefFunction;
                this.schema = schema;
                this.createDisposition = createDisposition;
                this.writeDisposition = writeDisposition;
                this.validate = validate;
            }

            public Bound named(String name) {
                return new Bound(name, this.table, this.tableRefFunction, this.schema, this.createDisposition, this.writeDisposition, this.validate);
            }

            public Bound to(String tableSpec) {
                return this.to(BigQueryIO.parseTableSpec(tableSpec));
            }

            public Bound to(TableReference table) {
                return new Bound(this.name, table, this.tableRefFunction, this.schema, this.createDisposition, this.writeDisposition, this.validate);
            }

            public Bound to(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
                return this.toTableReference(new TranslateTableSpecFunction(tableSpecFunction));
            }

            public Bound toTableReference(SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
                return new Bound(this.name, this.table, tableRefFunction, this.schema, this.createDisposition, this.writeDisposition, this.validate);
            }

            public Bound withSchema(TableSchema schema) {
                return new Bound(this.name, this.table, this.tableRefFunction, schema, this.createDisposition, this.writeDisposition, this.validate);
            }

            public Bound withCreateDisposition(CreateDisposition createDisposition) {
                return new Bound(this.name, this.table, this.tableRefFunction, this.schema, createDisposition, this.writeDisposition, this.validate);
            }

            public Bound withWriteDisposition(WriteDisposition writeDisposition) {
                return new Bound(this.name, this.table, this.tableRefFunction, this.schema, this.createDisposition, writeDisposition, this.validate);
            }

            public Bound withoutValidation() {
                return new Bound(this.name, this.table, this.tableRefFunction, this.schema, this.createDisposition, this.writeDisposition, false);
            }

            private static void verifyTableEmpty(BigQueryOptions options, TableReference table) {
                block3: {
                    try {
                        Bigquery client = Transport.newBigQueryClient(options).build();
                        BigQueryTableInserter inserter = new BigQueryTableInserter(client);
                        if (!inserter.isEmpty(table)) {
                            String string = String.valueOf(BigQueryIO.toTableSpec(table));
                            throw new IllegalArgumentException(string.length() != 0 ? "BigQuery table is not empty: ".concat(string) : new String("BigQuery table is not empty: "));
                        }
                    }
                    catch (IOException e) {
                        ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
                        if (errorExtractor.itemNotFound(e)) break block3;
                        String string = String.valueOf(BigQueryIO.toTableSpec(table));
                        throw new RuntimeException(string.length() != 0 ? "unable to confirm BigQuery table emptiness for table ".concat(string) : new String("unable to confirm BigQuery table emptiness for table "), e);
                    }
                }
            }

            @Override
            public PDone apply(PCollection<TableRow> input) {
                BigQueryOptions options = input.getPipeline().getOptions().as(BigQueryOptions.class);
                if (this.table == null && this.tableRefFunction == null) {
                    throw new IllegalStateException("must set the table reference of a BigQueryIO.Write transform");
                }
                if (this.table != null && this.tableRefFunction != null) {
                    throw new IllegalStateException("Cannot set both a table reference and a table function for a BigQueryIO.Write transform");
                }
                if (this.createDisposition == CreateDisposition.CREATE_IF_NEEDED && this.schema == null) {
                    throw new IllegalArgumentException("CreateDisposition is CREATE_IF_NEEDED, however no schema was provided.");
                }
                if (this.table != null && this.table.getProjectId() == null) {
                    String projectIdFromOptions = options.getProject();
                    LOG.warn(String.format(BigQueryIO.SET_PROJECT_FROM_OPTIONS_WARNING, this.table.getDatasetId(), this.table.getTableId(), projectIdFromOptions));
                    this.table.setProjectId(projectIdFromOptions);
                }
                if (this.table != null && this.validate) {
                    BigQueryIO.verifyDatasetPresence(options, this.table);
                    if (this.getCreateDisposition() == CreateDisposition.CREATE_NEVER) {
                        BigQueryIO.verifyTablePresence(options, this.table);
                    }
                    if (this.getWriteDisposition() == WriteDisposition.WRITE_EMPTY) {
                        Bound.verifyTableEmpty(options, this.table);
                    }
                }
                if (options.isStreaming() || this.tableRefFunction != null) {
                    if (this.createDisposition == CreateDisposition.CREATE_NEVER) {
                        throw new IllegalArgumentException("CreateDispostion.CREATE_NEVER is not supported for unbounded PCollections or when using tablespec functions.");
                    }
                    if (this.writeDisposition == WriteDisposition.WRITE_TRUNCATE) {
                        throw new IllegalArgumentException("WriteDisposition.WRITE_TRUNCATE is not supported for unbounded PCollections or when using tablespec functions.");
                    }
                    return input.apply(new StreamWithDeDup(this.table, this.tableRefFunction, this.schema));
                }
                return PDone.in(input.getPipeline());
            }

            @Override
            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public CreateDisposition getCreateDisposition() {
                return this.createDisposition;
            }

            public WriteDisposition getWriteDisposition() {
                return this.writeDisposition;
            }

            public TableSchema getSchema() {
                return this.schema;
            }

            public TableReference getTable() {
                return this.table;
            }

            public boolean getValidate() {
                return this.validate;
            }

            static {
                DirectPipelineRunner.registerDefaultTransformEvaluator(Bound.class, new DirectPipelineRunner.TransformEvaluator<Bound>(){

                    @Override
                    public void evaluate(Bound transform, DirectPipelineRunner.EvaluationContext context) {
                        BigQueryIO.evaluateWriteHelper(transform, context);
                    }
                });
            }

            private static class TranslateTableSpecFunction
            implements SerializableFunction<BoundedWindow, TableReference> {
                private SerializableFunction<BoundedWindow, String> tableSpecFunction;

                TranslateTableSpecFunction(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
                    this.tableSpecFunction = tableSpecFunction;
                }

                @Override
                public TableReference apply(BoundedWindow value) {
                    return BigQueryIO.parseTableSpec(this.tableSpecFunction.apply(value));
                }
            }
        }

        public static enum WriteDisposition {
            WRITE_TRUNCATE,
            WRITE_APPEND,
            WRITE_EMPTY;

        }

        public static enum CreateDisposition {
            CREATE_NEVER,
            CREATE_IF_NEEDED;

        }
    }

    public static class Read {
        public static Bound named(String name) {
            return new Bound().named(name);
        }

        public static Bound from(String tableSpec) {
            return new Bound().from(tableSpec);
        }

        public static Bound fromQuery(String query) {
            return new Bound().fromQuery(query);
        }

        public static Bound from(TableReference table) {
            return new Bound().from(table);
        }

        public static Bound withoutValidation() {
            return new Bound().withoutValidation();
        }

        public static class Bound
        extends PTransform<PInput, PCollection<TableRow>> {
            TableReference table;
            final String query;
            final boolean validate;
            private static final String QUERY_VALIDATION_FAILURE_ERROR = "Validation of query \"%1$s\" failed. If the query depends on an earlier stage of the pipeline, This validation can be disabled using #withoutValidation.";

            Bound() {
                this.query = null;
                this.table = null;
                this.validate = true;
            }

            Bound(String name, String query, TableReference reference, boolean validate) {
                super(name);
                this.table = reference;
                this.query = query;
                this.validate = validate;
            }

            public Bound named(String name) {
                return new Bound(name, this.query, this.table, this.validate);
            }

            public Bound from(String tableSpec) {
                return this.from(BigQueryIO.parseTableSpec(tableSpec));
            }

            public Bound fromQuery(String query) {
                return new Bound(this.name, query, this.table, this.validate);
            }

            public Bound from(TableReference table) {
                return new Bound(this.name, this.query, table, this.validate);
            }

            public Bound withoutValidation() {
                return new Bound(this.name, this.query, this.table, false);
            }

            @Override
            public void validate(PInput input) {
                if (this.table == null && this.query == null) {
                    throw new IllegalStateException("Invalid BigQuery read operation, either table reference or query has to be set");
                }
                if (this.table != null && this.query != null) {
                    throw new IllegalStateException("Invalid BigQuery read operation. Specifies both a query and a table, only one of these should be provided");
                }
                BigQueryOptions bqOptions = input.getPipeline().getOptions().as(BigQueryOptions.class);
                if (this.table != null && this.table.getProjectId() == null) {
                    LOG.warn(String.format(BigQueryIO.SET_PROJECT_FROM_OPTIONS_WARNING, this.table.getDatasetId(), this.table.getTableId(), bqOptions.getProject()));
                    this.table.setProjectId(bqOptions.getProject());
                }
                if (this.validate) {
                    if (this.table != null) {
                        BigQueryIO.verifyDatasetPresence(bqOptions, this.table);
                        BigQueryIO.verifyTablePresence(bqOptions, this.table);
                    }
                    if (this.query != null) {
                        Bound.dryRunQuery(bqOptions, this.query);
                    }
                }
            }

            private static void dryRunQuery(BigQueryOptions options, String query) {
                Bigquery client = Transport.newBigQueryClient(options).build();
                QueryRequest request = new QueryRequest();
                request.setQuery(query);
                request.setDryRun(Boolean.valueOf(true));
                try {
                    BigQueryTableRowIterator.executeWithBackOff(client.jobs().query(options.getProject(), request), QUERY_VALIDATION_FAILURE_ERROR, new Object[]{query});
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format(QUERY_VALIDATION_FAILURE_ERROR, query), e);
                }
            }

            @Override
            public PCollection<TableRow> apply(PInput input) {
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED).setCoder((Coder)TableRowJsonCoder.of());
            }

            @Override
            protected Coder<TableRow> getDefaultOutputCoder() {
                return TableRowJsonCoder.of();
            }

            public TableReference getTable() {
                return this.table;
            }

            public String getQuery() {
                return this.query;
            }

            public boolean getValidate() {
                return this.validate;
            }

            static {
                DirectPipelineRunner.registerDefaultTransformEvaluator(Bound.class, new DirectPipelineRunner.TransformEvaluator<Bound>(){

                    @Override
                    public void evaluate(Bound transform, DirectPipelineRunner.EvaluationContext context) {
                        BigQueryIO.evaluateReadHelper(transform, context);
                    }
                });
            }
        }
    }
}

