/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.BoundedReadFromUnboundedSource;
import com.google.cloud.dataflow.sdk.io.BoundedSource;
import com.google.cloud.dataflow.sdk.io.UnboundedSource;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.dataflow.BasicSerializableSourceFormat;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PInput;
import javax.annotation.Nullable;
import org.joda.time.Duration;

public class Read {
    public static Builder named(String name) {
        return new Builder(name);
    }

    public static <T> Bounded<T> from(BoundedSource<T> source) {
        return new Bounded(null, source);
    }

    public static <T> Unbounded<T> from(UnboundedSource<T, ?> source) {
        return new Unbounded(null, source);
    }

    public static class Unbounded<T>
    extends PTransform<PInput, PCollection<T>> {
        private final UnboundedSource<T, ?> source;

        private Unbounded(@Nullable String name, UnboundedSource<T, ?> source) {
            super(name);
            this.source = source;
        }

        public Unbounded<T> named(String name) {
            return new Unbounded<T>(name, this.source);
        }

        public BoundedReadFromUnboundedSource<T> withMaxNumRecords(long maxNumRecords) {
            return new BoundedReadFromUnboundedSource<T>(this.source, maxNumRecords, null);
        }

        public BoundedReadFromUnboundedSource<T> withMaxReadTime(Duration maxReadTime) {
            return new BoundedReadFromUnboundedSource<T>(this.source, Long.MAX_VALUE, maxReadTime);
        }

        @Override
        protected Coder<T> getDefaultOutputCoder() {
            return this.source.getDefaultOutputCoder();
        }

        @Override
        public final PCollection<T> apply(PInput input) {
            this.source.validate();
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED);
        }

        public UnboundedSource<T, ?> getSource() {
            return this.source;
        }

        @Override
        public String getKindString() {
            String string = StringUtils.approximateSimpleName(this.source.getClass());
            return new StringBuilder(6 + String.valueOf(string).length()).append("Read(").append(string).append(")").toString();
        }
    }

    public static class Bounded<T>
    extends PTransform<PInput, PCollection<T>> {
        private final BoundedSource<T> source;

        private Bounded(@Nullable String name, BoundedSource<T> source) {
            super(name);
            this.source = source;
        }

        public Bounded<T> named(String name) {
            return new Bounded<T>(name, this.source);
        }

        @Override
        protected Coder<T> getDefaultOutputCoder() {
            return this.source.getDefaultOutputCoder();
        }

        @Override
        public final PCollection<T> apply(PInput input) {
            this.source.validate();
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED).setCoder((Coder)this.getDefaultOutputCoder());
        }

        public BoundedSource<T> getSource() {
            return this.source;
        }

        @Override
        public String getKindString() {
            String string = StringUtils.approximateSimpleName(this.source.getClass());
            return new StringBuilder(6 + String.valueOf(string).length()).append("Read(").append(string).append(")").toString();
        }

        private static void registerDefaultTransformEvaluator() {
            DirectPipelineRunner.registerDefaultTransformEvaluator(Bounded.class, new DirectPipelineRunner.TransformEvaluator<Bounded>(){

                @Override
                public void evaluate(Bounded transform, DirectPipelineRunner.EvaluationContext context) {
                    BasicSerializableSourceFormat.evaluateReadHelper(transform, context);
                }
            });
        }

        static {
            Bounded.registerDefaultTransformEvaluator();
        }
    }

    public static class Builder {
        private final String name;

        private Builder(String name) {
            this.name = name;
        }

        public <T> Bounded<T> from(BoundedSource<T> source) {
            return new Bounded(this.name, source);
        }

        public <T> Unbounded<T> from(UnboundedSource<T, ?> source) {
            return new Unbounded(this.name, source);
        }
    }
}

