/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io.range;

import com.google.cloud.dataflow.sdk.io.range.RangeTracker;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetRangeTracker
implements RangeTracker<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetRangeTracker.class);
    private final long startOffset;
    private long stopOffset;
    private long lastRecordStart = -1L;
    private long offsetOfLastSplitPoint = -1L;
    public static final long OFFSET_INFINITY = Long.MAX_VALUE;

    public OffsetRangeTracker(long startOffset, long stopOffset) {
        this.startOffset = startOffset;
        this.stopOffset = stopOffset;
    }

    @Override
    public synchronized Long getStartPosition() {
        return this.startOffset;
    }

    @Override
    public synchronized Long getStopPosition() {
        return this.stopOffset;
    }

    @Override
    public boolean tryReturnRecordAt(boolean isAtSplitPoint, Long recordStart) {
        return this.tryReturnRecordAt(isAtSplitPoint, (long)recordStart);
    }

    @Override
    public synchronized boolean tryReturnRecordAt(boolean isAtSplitPoint, long recordStart) {
        if (this.lastRecordStart == -1L && !isAtSplitPoint) {
            throw new IllegalStateException(String.format("The first record [starting at %d] must be at a split point", recordStart));
        }
        if (recordStart < this.lastRecordStart) {
            throw new IllegalStateException(String.format("Trying to return record [starting at %d] which is before the last-returned record [starting at %d]", recordStart, this.lastRecordStart));
        }
        if (isAtSplitPoint) {
            if (this.offsetOfLastSplitPoint != -1L && recordStart == this.offsetOfLastSplitPoint) {
                throw new IllegalStateException(String.format("Record at a split point has same offset as the previous split point: previous split point at %d, current record starts at %d", this.offsetOfLastSplitPoint, recordStart));
            }
            if (recordStart >= this.stopOffset) {
                return false;
            }
            this.offsetOfLastSplitPoint = recordStart;
        }
        this.lastRecordStart = recordStart;
        return true;
    }

    @Override
    public boolean trySplitAtPosition(Long splitOffset) {
        return this.trySplitAtPosition((long)splitOffset);
    }

    @Override
    public synchronized boolean trySplitAtPosition(long splitOffset) {
        if (this.stopOffset == Long.MAX_VALUE) {
            LOG.debug("Refusing to split {} at {}: stop position unspecified", (Object)this, (Object)splitOffset);
            return false;
        }
        if (this.lastRecordStart == -1L) {
            LOG.debug("Refusing to split {} at {}: unstarted", (Object)this, (Object)splitOffset);
            return false;
        }
        if (splitOffset <= this.lastRecordStart) {
            LOG.debug("Refusing to split {} at {}: already past proposed split position", (Object)this, (Object)splitOffset);
            return false;
        }
        if (splitOffset < this.startOffset || splitOffset >= this.stopOffset) {
            LOG.debug("Refusing to split {} at {}: proposed split position out of range", (Object)this, (Object)splitOffset);
            return false;
        }
        LOG.debug("Agreeing to split {} at {}", (Object)this, (Object)splitOffset);
        this.stopOffset = splitOffset;
        return true;
    }

    public synchronized long getPositionForFractionConsumed(double fraction) {
        if (this.stopOffset == Long.MAX_VALUE) {
            String string = String.valueOf(this);
            throw new IllegalArgumentException(new StringBuilder(72 + String.valueOf(string).length()).append("getPositionForFractionConsumed is not applicable to an unbounded range: ").append(string).toString());
        }
        return (long)Math.ceil((double)this.startOffset + fraction * (double)(this.stopOffset - this.startOffset));
    }

    @Override
    public synchronized double getFractionConsumed() {
        if (this.stopOffset == Long.MAX_VALUE) {
            return 0.0;
        }
        if (this.lastRecordStart == -1L) {
            return 0.0;
        }
        return Math.min(1.0, 1.0 * (double)(this.lastRecordStart - this.startOffset + 1L) / (double)(this.stopOffset - this.startOffset));
    }

    public synchronized String toString() {
        String stopString;
        String string = stopString = this.stopOffset == Long.MAX_VALUE ? "infinity" : String.valueOf(this.stopOffset);
        if (this.lastRecordStart >= 0L) {
            return String.format("<at [starting at %d] of offset range [%d, %s)>", this.lastRecordStart, this.startOffset, stopString);
        }
        return String.format("<unstarted in offset range [%d, %s)>", this.startOffset, stopString);
    }

    @VisibleForTesting
    OffsetRangeTracker copy() {
        OffsetRangeTracker res = new OffsetRangeTracker(this.startOffset, this.stopOffset);
        res.lastRecordStart = this.lastRecordStart;
        return res;
    }
}

