/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.services.dataflow.Dataflow;
import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.DefaultValueFactory;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.Hidden;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.util.DataflowPathValidator;
import com.google.cloud.dataflow.sdk.util.GcsStager;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import com.google.cloud.dataflow.sdk.util.PathValidator;
import com.google.cloud.dataflow.sdk.util.Stager;
import com.google.cloud.dataflow.sdk.util.Transport;
import java.util.List;
import java.util.Map;

@Description(value="[Internal] Options used to control execution of the Dataflow SDK for debugging and testing purposes.")
@Hidden
public interface DataflowPipelineDebugOptions
extends PipelineOptions {
    @Description(value="[Experimental] Dataflow provides a number of experimental features that can be enabled with this flag. Please sync with the Dataflow team before enabling any experiments.")
    @Experimental
    public List<String> getExperiments();

    public void setExperiments(List<String> var1);

    @Description(value="The root URL for the Dataflow API. dataflowEndpoint can override this value if it contains an absolute URL, otherwise apiRootUrl will be combined with dataflowEndpoint to generate the full URL to communicate with the Dataflow API.")
    @Default.String(value="https://dataflow.googleapis.com/")
    public String getApiRootUrl();

    public void setApiRootUrl(String var1);

    @Description(value="The URL for the Dataflow API. If the string contains \"://\" will be treated as the entire URL, otherwise will be treated relative to apiRootUrl.")
    @Default.String(value="")
    public String getDataflowEndpoint();

    public void setDataflowEndpoint(String var1);

    @Description(value="The path to write the translated Dataflow job specification out to at job submission time. The Dataflow job specification will be represented in JSON format.")
    public String getDataflowJobFile();

    public void setDataflowJobFile(String var1);

    @Description(value="The class of the validator that should be created and used to validate paths. If pathValidator has not been set explicitly, an instance of this class will be constructed and used as the path validator.")
    @Default.Class(value=DataflowPathValidator.class)
    public Class<? extends PathValidator> getPathValidatorClass();

    public void setPathValidatorClass(Class<? extends PathValidator> var1);

    @JsonIgnore
    @Description(value="The path validator instance that should be created and used to validate paths. If no path validator has been set explicitly, the default is to use the instance factory that constructs a path validator based upon the currently set pathValidatorClass.")
    @Default.InstanceFactory(value=PathValidatorFactory.class)
    public PathValidator getPathValidator();

    public void setPathValidator(PathValidator var1);

    @Description(value="The class of the stager that should be created and used to stage resources. If stager has not been set explicitly, an instance of this class will be constructed and used as the resource stager.")
    @Default.Class(value=GcsStager.class)
    public Class<? extends Stager> getStagerClass();

    public void setStagerClass(Class<? extends Stager> var1);

    @JsonIgnore
    @Description(value="The resource stager instance that should be created and used to stage resources. If no stager has been set explicitly, the default is to use the instance factory that constructs a resource stager based upon the currently set stagerClass.")
    @Default.InstanceFactory(value=StagerFactory.class)
    public Stager getStager();

    public void setStager(Stager var1);

    @JsonIgnore
    @Description(value="An instance of the Dataflow client. Defaults to creating a Dataflow client using the current set of options.")
    @Default.InstanceFactory(value=DataflowClientFactory.class)
    public Dataflow getDataflowClient();

    public void setDataflowClient(Dataflow var1);

    @Description(value="Root URL for use with the Pubsub API")
    @Default.String(value="https://pubsub.googleapis.com")
    public String getPubsubRootUrl();

    public void setPubsubRootUrl(String var1);

    @JsonIgnore
    @Description(value="If set, replace the existing pipeline with the name specified by --jobName with this pipeline, preserving state.")
    public boolean getUpdate();

    public void setUpdate(boolean var1);

    @JsonIgnore
    @Description(value="Mapping of old PTranform names to new ones, specified as JSON {\"oldName\":\"newName\",...}. To mark a transform as deleted, make newName the empty string.")
    public Map<String, String> getTransformNameMapping();

    public void setTransformNameMapping(Map<String, String> var1);

    @Description(value="Custom windmill_main binary to use with the streaming runner")
    public String getOverrideWindmillBinary();

    public void setOverrideWindmillBinary(String var1);

    @Description(value="Number of threads to use on the Dataflow worker harness. If left unspecified, the Dataflow service will compute an appropriate number of threads to use.")
    public int getNumberOfWorkerHarnessThreads();

    public void setNumberOfWorkerHarnessThreads(int var1);

    public static class StagerFactory
    implements DefaultValueFactory<Stager> {
        @Override
        public Stager create(PipelineOptions options) {
            DataflowPipelineDebugOptions debugOptions = options.as(DataflowPipelineDebugOptions.class);
            return InstanceBuilder.ofType(Stager.class).fromClass(debugOptions.getStagerClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
        }
    }

    public static class PathValidatorFactory
    implements DefaultValueFactory<PathValidator> {
        @Override
        public PathValidator create(PipelineOptions options) {
            DataflowPipelineDebugOptions debugOptions = options.as(DataflowPipelineDebugOptions.class);
            return InstanceBuilder.ofType(PathValidator.class).fromClass(debugOptions.getPathValidatorClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
        }
    }

    public static class DataflowClientFactory
    implements DefaultValueFactory<Dataflow> {
        @Override
        public Dataflow create(PipelineOptions options) {
            return Transport.newDataflowClient(options.as(DataflowPipelineOptions.class)).build();
        }
    }
}

