/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.DefaultValueFactory;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.GoogleApiDebugOptions;
import com.google.cloud.dataflow.sdk.options.Hidden;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.Files;
import com.google.cloud.dataflow.sdk.util.CredentialFactory;
import com.google.cloud.dataflow.sdk.util.GcpCredentialFactory;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Options used to configure Google Cloud Platform project and credentials.")
public interface GcpOptions
extends GoogleApiDebugOptions,
PipelineOptions {
    @Description(value="Project id. Required when running a Dataflow in the cloud. See https://cloud.google.com/storage/docs/projects for further details.")
    @Default.InstanceFactory(value=DefaultProjectFactory.class)
    public String getProject();

    public void setProject(String var1);

    @JsonIgnore
    @Description(value="Controls which file to use when attempting to create the credentials using the service account method. This option if specified, needs to be combined with the serviceAccountName option.")
    public String getServiceAccountKeyfile();

    public void setServiceAccountKeyfile(String var1);

    @JsonIgnore
    @Description(value="Controls which service account to use when attempting to create the credentials using the service account method. This option if specified, needs to be combined with the serviceAccountKeyfile option.")
    public String getServiceAccountName();

    public void setServiceAccountName(String var1);

    @JsonIgnore
    @Description(value="This option controls which file to use when attempting to create the credentials using the OAuth 2 webflow. After the OAuth2 webflow, the credentials will be stored within credentialDir.")
    public String getSecretsFile();

    public void setSecretsFile(String var1);

    @Description(value="This option controls which credential store to use when creating the credentials using the OAuth 2 webflow.")
    @Default.String(value="cloud_dataflow")
    public String getCredentialId();

    public void setCredentialId(String var1);

    @Description(value="Directory for storing dataflow credentials after execution of the OAuth 2 webflow. Defaults to using the $HOME/.store/data-flow directory.")
    @Default.InstanceFactory(value=CredentialDirFactory.class)
    public String getCredentialDir();

    public void setCredentialDir(String var1);

    @Description(value="The class of the credential factory that should be created and used to create credentials. If gcpCredential has not been set explicitly, an instance of this class will be constructed and used as a credential factory. The default credential factory will")
    @Default.Class(value=GcpCredentialFactory.class)
    public Class<? extends CredentialFactory> getCredentialFactoryClass();

    public void setCredentialFactoryClass(Class<? extends CredentialFactory> var1);

    @JsonIgnore
    @Description(value="The credential instance that should be used to authenticate against GCP services. If no credential has been set explicitly, the default is to use the instance factory that constructs a credential based upon the currently set credentialFactoryClass.")
    @Default.InstanceFactory(value=GcpUserCredentialsFactory.class)
    @Hidden
    public Credential getGcpCredential();

    public void setGcpCredential(Credential var1);

    public static class GcpUserCredentialsFactory
    implements DefaultValueFactory<Credential> {
        @Override
        public Credential create(PipelineOptions options) {
            GcpOptions gcpOptions = options.as(GcpOptions.class);
            try {
                CredentialFactory factory = InstanceBuilder.ofType(CredentialFactory.class).fromClass(gcpOptions.getCredentialFactoryClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
                return factory.getCredential();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Unable to obtain credential", e);
            }
        }
    }

    public static class DefaultProjectFactory
    implements DefaultValueFactory<String> {
        private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectFactory.class);

        @Override
        public String create(PipelineOptions options) {
            try {
                File configDir = this.getEnvironment().containsKey("CLOUDSDK_CONFIG") ? new File(this.getEnvironment().get("CLOUDSDK_CONFIG")) : (DefaultProjectFactory.isWindows() && this.getEnvironment().containsKey("APPDATA") ? new File(this.getEnvironment().get("APPDATA"), "gcloud") : new File(System.getProperty("user.home"), ".config/gcloud"));
                String section = null;
                Pattern projectPattern = Pattern.compile("^project\\s*=\\s*(.*)$");
                Pattern sectionPattern = Pattern.compile("^\\[(.*)\\]$");
                for (String line : Files.readLines(new File(configDir, "properties"), StandardCharsets.UTF_8)) {
                    if ((line = line.trim()).isEmpty() || line.startsWith(";")) continue;
                    Matcher matcher = sectionPattern.matcher(line);
                    if (matcher.matches()) {
                        section = matcher.group(1);
                        continue;
                    }
                    if (section != null && !section.equals("core") || !(matcher = projectPattern.matcher(line)).matches()) continue;
                    String project = matcher.group(1).trim();
                    LOG.info("Inferred default GCP project '{}' from gCloud. If this is the incorrect project, please cancel this Pipeline and specify the command-line argument --project.", (Object)project);
                    return project;
                }
            }
            catch (IOException expected) {
                LOG.debug("Failed to find default project.", (Throwable)expected);
            }
            return null;
        }

        private static boolean isWindows() {
            return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        }

        @VisibleForTesting
        Map<String, String> getEnvironment() {
            return System.getenv();
        }
    }

    public static class CredentialDirFactory
    implements DefaultValueFactory<String> {
        @Override
        public String create(PipelineOptions options) {
            File home = new File(System.getProperty("user.home"));
            File store = new File(home, ".store");
            File dataflow = new File(store, "data-flow");
            return dataflow.getPath();
        }
    }
}

