/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public interface GoogleApiDebugOptions
extends PipelineOptions {
    @Description(value="This option enables tracing of API calls to Google services used within the Dataflow SDK. Values are expected in JSON format {\"ApiName\":\"TraceDestination\",...} where the ApiName represents the request classes canonical name. The TraceDestination is a logical trace consumer to whom the trace will be reported. Typically, \"producer\" is the right destination to use: this makes API traces available to the team offering the API. Note that by enabling this option, the contents of the requests to and from Google Cloud services will be made available to Google. For example, by specifying {\"Dataflow\":\"producer\"}, all calls to the Dataflow service will be made available to Google, specifically to the Google Cloud Dataflow team.")
    public GoogleApiTracer getGoogleApiTrace();

    public void setGoogleApiTrace(GoogleApiTracer var1);

    public static class GoogleApiTracer
    extends HashMap<String, String>
    implements GoogleClientRequestInitializer {
        public GoogleApiTracer addTraceFor(AbstractGoogleClient client, String traceDestination) {
            this.put(client.getClass().getCanonicalName(), traceDestination);
            return this;
        }

        public GoogleApiTracer addTraceFor(AbstractGoogleClientRequest<?> request, String traceDestination) {
            this.put(request.getClass().getCanonicalName(), traceDestination);
            return this;
        }

        public void initialize(AbstractGoogleClientRequest<?> request) throws IOException {
            for (Map.Entry entry : this.entrySet()) {
                if (!request.getClass().getCanonicalName().contains((CharSequence)entry.getKey())) continue;
                request.set("$trace", entry.getValue());
            }
        }
    }
}

