/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.DataflowWorkerHarnessOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.Hidden;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsRegistrar;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsValidator;
import com.google.cloud.dataflow.sdk.options.ProxyInvocationHandler;
import com.google.cloud.dataflow.sdk.options.Validation;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Collections2;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableListMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterators;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ListMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.SortedSetMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.TreeMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.runners.PipelineRunnerRegistrar;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.util.common.ReflectHelpers;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineOptionsFactory {
    private static final Set<Class<?>> SIMPLE_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Boolean.TYPE)).add(Boolean.class)).add(Character.TYPE)).add(Character.class)).add(Short.TYPE)).add(Short.class)).add(Integer.TYPE)).add(Integer.class)).add(Long.TYPE)).add(Long.class)).add(Float.TYPE)).add(Float.class)).add(Double.TYPE)).add(Double.class)).add(String.class)).add(Class.class)).build();
    private static final Logger LOG = LoggerFactory.getLogger(PipelineOptionsFactory.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Map<String, Class<? extends PipelineRunner<?>>> SUPPORTED_PIPELINE_RUNNERS;
    private static final Set<String> PIPELINE_OPTIONS_FACTORY_CLASSES;
    private static final Set<Method> IGNORED_METHODS;
    private static final Set<Class<? extends PipelineOptions>> REGISTERED_OPTIONS;
    private static final Map<Class<? extends PipelineOptions>, Registration<?>> INTERFACE_CACHE;
    private static final Map<Set<Class<? extends PipelineOptions>>, Registration<?>> COMBINED_CACHE;
    private static final int TERMINAL_WIDTH = 80;

    public static PipelineOptions create() {
        return new Builder().as(PipelineOptions.class);
    }

    public static <T extends PipelineOptions> T as(Class<T> klass) {
        return new Builder().as(klass);
    }

    public static Builder fromArgs(String[] args) {
        return new Builder().fromArgs(args);
    }

    public Builder withValidation() {
        return new Builder().withValidation();
    }

    static boolean printHelpUsageAndExitIfNeeded(ListMultimap<String, String> options, PrintStream printStream, boolean exit) {
        if (options.containsKey("help")) {
            final String helpOption = Iterables.getOnlyElement(options.get("help"));
            if (Boolean.TRUE.toString().equals(helpOption)) {
                PipelineOptionsFactory.printHelp(printStream);
                if (exit) {
                    System.exit(0);
                } else {
                    return true;
                }
            }
            try {
                Class<?> klass = Class.forName(helpOption);
                if (!PipelineOptions.class.isAssignableFrom(klass)) {
                    String string = String.valueOf(klass);
                    throw new ClassNotFoundException(new StringBuilder(35 + String.valueOf(string).length()).append("PipelineOptions of type ").append(string).append(" not found.").toString());
                }
                PipelineOptionsFactory.printHelp(printStream, klass);
            }
            catch (ClassNotFoundException e) {
                Iterable<Class<? extends PipelineOptions>> matches = Iterables.filter(PipelineOptionsFactory.getRegisteredOptions(), new Predicate<Class<? extends PipelineOptions>>(){

                    @Override
                    public boolean apply(Class<? extends PipelineOptions> input) {
                        if (helpOption.contains(".")) {
                            return input.getName().endsWith(helpOption);
                        }
                        return input.getSimpleName().equals(helpOption);
                    }
                });
                try {
                    PipelineOptionsFactory.printHelp(printStream, Iterables.getOnlyElement(matches));
                }
                catch (NoSuchElementException exception) {
                    printStream.format("Unable to find option %s.%n", helpOption);
                    PipelineOptionsFactory.printHelp(printStream);
                }
                catch (IllegalArgumentException exception) {
                    printStream.format("Multiple matches found for %s: %s.%n", helpOption, Iterables.transform(matches, ReflectHelpers.CLASS_NAME));
                    PipelineOptionsFactory.printHelp(printStream);
                }
            }
            if (exit) {
                System.exit(0);
            } else {
                return true;
            }
        }
        return false;
    }

    private static String findCallersClassName() {
        StackTraceElement next;
        UnmodifiableIterator<StackTraceElement> elements = Iterators.forArray(Thread.currentThread().getStackTrace());
        while (elements.hasNext() && !PIPELINE_OPTIONS_FACTORY_CLASSES.contains((next = (StackTraceElement)elements.next()).getClassName())) {
        }
        while (elements.hasNext()) {
            next = (StackTraceElement)elements.next();
            if (PIPELINE_OPTIONS_FACTORY_CLASSES.contains(next.getClassName())) continue;
            try {
                return Class.forName(next.getClassName()).getSimpleName();
            }
            catch (ClassNotFoundException e) {
                break;
            }
        }
        return "unknown";
    }

    static ClassLoader findClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = PipelineOptionsFactory.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static synchronized void register(Class<? extends PipelineOptions> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument(iface.isInterface(), "Only interface types are supported.");
        if (REGISTERED_OPTIONS.contains(iface)) {
            return;
        }
        PipelineOptionsFactory.validateWellFormed(iface, REGISTERED_OPTIONS);
        REGISTERED_OPTIONS.add(iface);
    }

    static synchronized <T extends PipelineOptions> Registration<T> validateWellFormed(Class<T> iface, Set<Class<? extends PipelineOptions>> validatedPipelineOptionsInterfaces) {
        List<PropertyDescriptor> propertyDescriptors;
        Preconditions.checkArgument(iface.isInterface(), "Only interface types are supported.");
        ImmutableSet<Class> combinedPipelineOptionsInterfaces = FluentIterable.from(validatedPipelineOptionsInterfaces).append(iface).toSet();
        if (!COMBINED_CACHE.containsKey(combinedPipelineOptionsInterfaces)) {
            Class<?> allProxyClass = Proxy.getProxyClass(PipelineOptionsFactory.class.getClassLoader(), combinedPipelineOptionsInterfaces.toArray(EMPTY_CLASS_ARRAY));
            try {
                propertyDescriptors = PipelineOptionsFactory.validateClass(iface, validatedPipelineOptionsInterfaces, allProxyClass);
                COMBINED_CACHE.put(combinedPipelineOptionsInterfaces, new Registration(allProxyClass, propertyDescriptors));
            }
            catch (IntrospectionException e) {
                throw Throwables.propagate(e);
            }
        }
        if (!INTERFACE_CACHE.containsKey(iface)) {
            Class<?> proxyClass = Proxy.getProxyClass(PipelineOptionsFactory.class.getClassLoader(), iface);
            try {
                propertyDescriptors = PipelineOptionsFactory.validateClass(iface, validatedPipelineOptionsInterfaces, proxyClass);
                INTERFACE_CACHE.put(iface, new Registration(proxyClass, propertyDescriptors));
            }
            catch (IntrospectionException e) {
                throw Throwables.propagate(e);
            }
        }
        Registration<?> result = INTERFACE_CACHE.get(iface);
        return result;
    }

    public static Set<Class<? extends PipelineOptions>> getRegisteredOptions() {
        return Collections.unmodifiableSet(REGISTERED_OPTIONS);
    }

    public static void printHelp(PrintStream out) {
        Preconditions.checkNotNull(out);
        out.println("The set of registered options are:");
        TreeSet<Class<? extends PipelineOptions>> sortedOptions = new TreeSet<Class<? extends PipelineOptions>>(ClassNameComparator.INSTANCE);
        sortedOptions.addAll(REGISTERED_OPTIONS);
        for (Class clazz : sortedOptions) {
            out.format("  %s%n", clazz.getName());
        }
        out.format("%nUse --help=<OptionsName> for detailed help. For example:%n  --help=DataflowPipelineOptions <short names valid for registered options>%n  --help=com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions%n", new Object[0]);
    }

    public static void printHelp(PrintStream out, Class<? extends PipelineOptions> iface) {
        Preconditions.checkNotNull(out);
        Preconditions.checkNotNull(iface);
        PipelineOptionsFactory.validateWellFormed(iface, REGISTERED_OPTIONS);
        Iterable<Method> methods = ReflectHelpers.getClosureOfMethodsOnInterface(iface);
        ArrayListMultimap<Class, Method> ifaceToMethods = ArrayListMultimap.create();
        for (Method method : methods) {
            if (method.getAnnotation(Hidden.class) != null) continue;
            ifaceToMethods.put(method.getDeclaringClass(), method);
        }
        TreeSet ifaces = new TreeSet(ClassNameComparator.INSTANCE);
        ifaces.addAll(Collections2.filter(ifaceToMethods.keySet(), new Predicate<Class<?>>(){

            @Override
            public boolean apply(Class<?> input) {
                return input.getAnnotation(Hidden.class) == null;
            }
        }));
        for (Class currentIface : ifaces) {
            SortedMap<String, Method> propertyNamesToGetters = PipelineOptionsFactory.getPropertyNamesToGetters(ifaceToMethods.get(currentIface));
            if (propertyNamesToGetters.isEmpty()) continue;
            SortedSetMultimap<String, String> requiredGroupNameToProperties = PipelineOptionsFactory.getRequiredGroupNamesToProperties(propertyNamesToGetters);
            out.format("%s:%n", currentIface.getName());
            PipelineOptionsFactory.prettyPrintDescription(out, currentIface.getAnnotation(Description.class));
            out.println();
            ArrayList<String> lists = Lists.newArrayList(propertyNamesToGetters.keySet());
            Collections.sort(lists, String.CASE_INSENSITIVE_ORDER);
            for (String propertyName : lists) {
                Method method = (Method)propertyNamesToGetters.get(propertyName);
                String printableType = method.getReturnType().getSimpleName();
                if (method.getReturnType().isEnum()) {
                    printableType = Joiner.on(" | ").join(method.getReturnType().getEnumConstants());
                }
                out.format("  --%s=<%s>%n", propertyName, printableType);
                Optional<String> defaultValue = PipelineOptionsFactory.getDefaultValueFromAnnotation(method);
                if (defaultValue.isPresent()) {
                    out.format("    Default: %s%n", defaultValue.get());
                }
                PipelineOptionsFactory.prettyPrintDescription(out, method.getAnnotation(Description.class));
                PipelineOptionsFactory.prettyPrintRequiredGroups(out, method.getAnnotation(Validation.Required.class), requiredGroupNameToProperties);
            }
            out.println();
        }
    }

    private static void prettyPrintRequiredGroups(PrintStream out, Validation.Required annotation, SortedSetMultimap<String, String> requiredGroupNameToProperties) {
        if (annotation == null || annotation.groups() == null) {
            return;
        }
        for (String group : annotation.groups()) {
            String requirement;
            SortedSet<String> groupMembers = requiredGroupNameToProperties.get(group);
            if (groupMembers.size() == 1) {
                requirement = String.valueOf(Iterables.getOnlyElement(groupMembers)).concat(" is required.");
            } else {
                String string = String.valueOf(groupMembers);
                requirement = new StringBuilder(28 + String.valueOf(string).length()).append("At least one of ").append(string).append(" is required").toString();
            }
            PipelineOptionsFactory.terminalPrettyPrint(out, requirement.split("\\s+"));
        }
    }

    private static void prettyPrintDescription(PrintStream out, Description description) {
        if (description == null || description.value() == null) {
            return;
        }
        String[] words = description.value().split("\\s+");
        PipelineOptionsFactory.terminalPrettyPrint(out, words);
    }

    private static void terminalPrettyPrint(PrintStream out, String[] words) {
        String spacing = "   ";
        if (words.length == 0) {
            return;
        }
        out.print("   ");
        int lineLength = "   ".length();
        for (int i = 0; i < words.length; ++i) {
            out.print(" ");
            out.print(words[i]);
            if (i + 1 == words.length || words[i + 1].length() + (lineLength += 1 + words[i].length()) + 1 <= 80) continue;
            out.println();
            out.print("   ");
            lineLength = "   ".length();
        }
        out.println();
    }

    private static Optional<String> getDefaultValueFromAnnotation(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Default.Class) {
                return Optional.of(((Default.Class)annotation).value().getSimpleName());
            }
            if (annotation instanceof Default.String) {
                return Optional.of(((Default.String)annotation).value());
            }
            if (annotation instanceof Default.Boolean) {
                return Optional.of(Boolean.toString(((Default.Boolean)annotation).value()));
            }
            if (annotation instanceof Default.Character) {
                return Optional.of(Character.toString(((Default.Character)annotation).value()));
            }
            if (annotation instanceof Default.Byte) {
                return Optional.of(Byte.toString(((Default.Byte)annotation).value()));
            }
            if (annotation instanceof Default.Short) {
                return Optional.of(Short.toString(((Default.Short)annotation).value()));
            }
            if (annotation instanceof Default.Integer) {
                return Optional.of(Integer.toString(((Default.Integer)annotation).value()));
            }
            if (annotation instanceof Default.Long) {
                return Optional.of(Long.toString(((Default.Long)annotation).value()));
            }
            if (annotation instanceof Default.Float) {
                return Optional.of(Float.toString(((Default.Float)annotation).value()));
            }
            if (annotation instanceof Default.Double) {
                return Optional.of(Double.toString(((Default.Double)annotation).value()));
            }
            if (annotation instanceof Default.Enum) {
                return Optional.of(((Default.Enum)annotation).value());
            }
            if (!(annotation instanceof Default.InstanceFactory)) continue;
            return Optional.of(((Default.InstanceFactory)annotation).value().getSimpleName());
        }
        return Optional.absent();
    }

    static Map<String, Class<? extends PipelineRunner<?>>> getRegisteredRunners() {
        return SUPPORTED_PIPELINE_RUNNERS;
    }

    static List<PropertyDescriptor> getPropertyDescriptors(Set<Class<? extends PipelineOptions>> interfaces) {
        return COMBINED_CACHE.get(interfaces).getPropertyDescriptors();
    }

    public static DataflowWorkerHarnessOptions createFromSystemPropertiesInternal() throws IOException {
        return PipelineOptionsFactory.createFromSystemProperties();
    }

    @Deprecated
    public static DataflowWorkerHarnessOptions createFromSystemProperties() throws IOException {
        DataflowWorkerHarnessOptions options;
        ObjectMapper objectMapper = new ObjectMapper();
        if (System.getProperties().containsKey("sdk_pipeline_options")) {
            String serializedOptions = System.getProperty("sdk_pipeline_options");
            String string = String.valueOf(serializedOptions);
            LOG.info(string.length() != 0 ? "Worker harness starting with: ".concat(string) : new String("Worker harness starting with: "));
            options = ((PipelineOptions)objectMapper.readValue(serializedOptions, PipelineOptions.class)).as(DataflowWorkerHarnessOptions.class);
        } else {
            options = PipelineOptionsFactory.as(DataflowWorkerHarnessOptions.class);
        }
        if (System.getProperties().containsKey("worker_id")) {
            options.setWorkerId(System.getProperty("worker_id"));
        }
        if (System.getProperties().containsKey("job_id")) {
            options.setJobId(System.getProperty("job_id"));
        }
        return options;
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(Class<?> beanClass) throws IntrospectionException {
        TreeSet<Method> methods = Sets.newTreeSet(MethodComparator.INSTANCE);
        methods.addAll(Arrays.asList(beanClass.getMethods()));
        SortedMap<String, Method> propertyNamesToGetters = PipelineOptionsFactory.getPropertyNamesToGetters(methods);
        ArrayList<PropertyDescriptor> descriptors = Lists.newArrayList();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) continue;
            String propertyName = Introspector.decapitalize(methodName.substring(3));
            Method getterMethod = (Method)propertyNamesToGetters.remove(propertyName);
            if (getterMethod != null) {
                Class<?> setterPropertyType;
                Class<?> getterPropertyType = getterMethod.getReturnType();
                Preconditions.checkArgument(getterPropertyType == (setterPropertyType = method.getParameterTypes()[0]), "Type mismatch between getter and setter methods for property [%s]. Getter is of type [%s] whereas setter is of type [%s].", propertyName, getterPropertyType.getName(), setterPropertyType.getName());
            }
            descriptors.add(new PropertyDescriptor(propertyName, getterMethod, method));
        }
        for (Map.Entry entry : propertyNamesToGetters.entrySet()) {
            descriptors.add(new PropertyDescriptor((String)entry.getKey(), (Method)entry.getValue(), null));
        }
        return descriptors;
    }

    private static SortedMap<String, Method> getPropertyNamesToGetters(Iterable<Method> methods) {
        TreeMap<String, Method> propertyNamesToGetters = Maps.newTreeMap();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("is") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            String propertyName = Introspector.decapitalize(methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3));
            propertyNamesToGetters.put(propertyName, method);
        }
        return propertyNamesToGetters;
    }

    private static SortedSetMultimap<String, String> getRequiredGroupNamesToProperties(Map<String, Method> propertyNamesToGetters) {
        TreeMultimap<String, String> result = TreeMultimap.create();
        for (Map.Entry<String, Method> propertyEntry : propertyNamesToGetters.entrySet()) {
            Validation.Required requiredAnnotation = propertyEntry.getValue().getAnnotation(Validation.Required.class);
            if (requiredAnnotation == null) continue;
            for (String groupName : requiredAnnotation.groups()) {
                result.put(groupName, propertyEntry.getKey());
            }
        }
        return result;
    }

    private static List<PropertyDescriptor> validateClass(Class<? extends PipelineOptions> iface, Set<Class<? extends PipelineOptions>> validatedPipelineOptionsInterfaces, Class<?> klass) throws IntrospectionException {
        HashSet<Method> methods = Sets.newHashSet(IGNORED_METHODS);
        for (Method method : klass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            methods.add(method);
        }
        try {
            methods.add(klass.getMethod("equals", Object.class));
            methods.add(klass.getMethod("hashCode", new Class[0]));
            methods.add(klass.getMethod("toString", new Class[0]));
            methods.add(klass.getMethod("as", Class.class));
            methods.add(klass.getMethod("cloneAs", Class.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw Throwables.propagate(e);
        }
        ImmutableSortedSet<Method> interfaceMethods = FluentIterable.from(ReflectHelpers.getClosureOfMethodsOnInterface(iface)).toSortedSet(MethodComparator.INSTANCE);
        TreeMultimap<Method, Method> methodNameToMethodMap = TreeMultimap.create(MethodNameComparator.INSTANCE, MethodComparator.INSTANCE);
        for (Method method : interfaceMethods) {
            methodNameToMethodMap.put(method, method);
        }
        for (Map.Entry entry : methodNameToMethodMap.asMap().entrySet()) {
            ImmutableSet returnTypes = FluentIterable.from((Iterable)entry.getValue()).transform(ReturnTypeFetchingFunction.INSTANCE).toSet();
            ImmutableSortedSet<Method> immutableSortedSet = FluentIterable.from((Iterable)entry.getValue()).toSortedSet(MethodComparator.INSTANCE);
            Preconditions.checkArgument(returnTypes.size() == 1, "Method [%s] has multiple definitions %s with different return types for [%s].", ((Method)entry.getKey()).getName(), immutableSortedSet, iface.getName());
        }
        ImmutableSortedSet<Method> allInterfaceMethods = FluentIterable.from(ReflectHelpers.getClosureOfMethodsOnInterfaces(validatedPipelineOptionsInterfaces)).append(ReflectHelpers.getClosureOfMethodsOnInterface(iface)).toSortedSet(MethodComparator.INSTANCE);
        TreeMultimap<Method, Method> treeMultimap = TreeMultimap.create(MethodNameComparator.INSTANCE, MethodComparator.INSTANCE);
        for (Method method : allInterfaceMethods) {
            treeMultimap.put(method, method);
        }
        List<PropertyDescriptor> descriptors = PipelineOptionsFactory.getPropertyDescriptors(klass);
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || IGNORED_METHODS.contains(descriptor.getReadMethod()) || IGNORED_METHODS.contains(descriptor.getWriteMethod())) continue;
            SortedSet getters = treeMultimap.get(descriptor.getReadMethod());
            SortedSet<Method> gettersWithJsonIgnore = Sets.filter(getters, JsonIgnorePredicate.INSTANCE);
            FluentIterable<String> getterClassNames = FluentIterable.from(getters).transform(MethodToDeclaringClassFunction.INSTANCE).transform(ReflectHelpers.CLASS_NAME);
            FluentIterable<String> gettersWithJsonIgnoreClassNames = FluentIterable.from(gettersWithJsonIgnore).transform(MethodToDeclaringClassFunction.INSTANCE).transform(ReflectHelpers.CLASS_NAME);
            Preconditions.checkArgument(gettersWithJsonIgnore.isEmpty() || getters.size() == gettersWithJsonIgnore.size(), "Expected getter for property [%s] to be marked with @JsonIgnore on all %s, found only on %s", descriptor.getName(), getterClassNames, gettersWithJsonIgnoreClassNames);
            SortedSet<Method> settersWithJsonIgnore = Sets.filter(treeMultimap.get(descriptor.getWriteMethod()), JsonIgnorePredicate.INSTANCE);
            FluentIterable<String> settersWithJsonIgnoreClassNames = FluentIterable.from(settersWithJsonIgnore).transform(MethodToDeclaringClassFunction.INSTANCE).transform(ReflectHelpers.CLASS_NAME);
            Preconditions.checkArgument(settersWithJsonIgnore.isEmpty(), "Expected setter for property [%s] to not be marked with @JsonIgnore on %s", descriptor.getName(), settersWithJsonIgnoreClassNames);
        }
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            Preconditions.checkArgument(IGNORED_METHODS.contains(propertyDescriptor.getWriteMethod()) || propertyDescriptor.getReadMethod() != null, "Expected getter for property [%s] of type [%s] on [%s].", propertyDescriptor.getName(), propertyDescriptor.getPropertyType().getName(), iface.getName());
            Preconditions.checkArgument(IGNORED_METHODS.contains(propertyDescriptor.getReadMethod()) || propertyDescriptor.getWriteMethod() != null, "Expected setter for property [%s] of type [%s] on [%s].", propertyDescriptor.getName(), propertyDescriptor.getPropertyType().getName(), iface.getName());
            methods.add(propertyDescriptor.getReadMethod());
            methods.add(propertyDescriptor.getWriteMethod());
        }
        TreeSet<Method> treeSet = new TreeSet<Method>(MethodComparator.INSTANCE);
        treeSet.addAll(Sets.difference(Sets.newHashSet(klass.getMethods()), methods));
        Preconditions.checkArgument(treeSet.isEmpty(), "Methods %s on [%s] do not conform to being bean properties.", FluentIterable.from(treeSet).transform(ReflectHelpers.METHOD_FORMATTER), iface.getName());
        return descriptors;
    }

    private static ListMultimap<String, String> parseCommandLine(String[] args, boolean strictParsing) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String arg : args) {
            if (Strings.isNullOrEmpty(arg)) continue;
            try {
                Preconditions.checkArgument(arg.startsWith("--"), "Argument '%s' does not begin with '--'", arg);
                int index = arg.indexOf("=");
                Preconditions.checkArgument(index != 2, "Argument '%s' starts with '--=', empty argument name not allowed", arg);
                if (index > 0) {
                    builder.put(arg.substring(2, index), arg.substring(index + 1, arg.length()));
                    continue;
                }
                builder.put(arg.substring(2), "true");
            }
            catch (IllegalArgumentException e) {
                if (strictParsing) {
                    throw e;
                }
                LOG.warn("Strict parsing is disabled, ignoring option '{}' because {}", (Object)arg, (Object)e.getMessage());
            }
        }
        return builder.build();
    }

    private static <T extends PipelineOptions> Map<String, Object> parseObjects(Class<T> klass, ListMultimap<String, String> options, boolean strictParsing) {
        HashMap<String, Method> propertyNamesToGetters = Maps.newHashMap();
        PipelineOptionsFactory.validateWellFormed(klass, REGISTERED_OPTIONS);
        List<PropertyDescriptor> propertyDescriptors = PipelineOptionsFactory.getPropertyDescriptors(FluentIterable.from(PipelineOptionsFactory.getRegisteredOptions()).append(klass).toSet());
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            propertyNamesToGetters.put(descriptor.getName(), descriptor.getReadMethod());
        }
        HashMap<String, Object> convertedOptions = Maps.newHashMap();
        for (final Map.Entry<String, Collection<String>> entry : options.asMap().entrySet()) {
            try {
                String string;
                String value;
                Object object;
                if (!propertyNamesToGetters.containsKey(entry.getKey())) {
                    TreeSet<String> closestMatches = new TreeSet<String>(Sets.filter(propertyNamesToGetters.keySet(), new Predicate<String>(){

                        @Override
                        public boolean apply(@Nullable String input) {
                            return StringUtils.getLevenshteinDistance((String)entry.getKey(), input) <= 2;
                        }
                    }));
                    switch (closestMatches.size()) {
                        case 0: {
                            throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'.", klass, entry.getKey()));
                        }
                        case 1: {
                            throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'. Did you mean '%s'?", klass, entry.getKey(), Iterables.getOnlyElement(closestMatches)));
                        }
                    }
                    throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'. Did you mean one of %s?", klass, entry.getKey(), closestMatches));
                }
                Method method = (Method)propertyNamesToGetters.get(entry.getKey());
                Class<?> returnType = method.getReturnType();
                JavaType type = MAPPER.getTypeFactory().constructType(method.getGenericReturnType());
                if ("runner".equals(entry.getKey())) {
                    String runner = (String)Iterables.getOnlyElement((Iterable)entry.getValue());
                    Preconditions.checkArgument(SUPPORTED_PIPELINE_RUNNERS.containsKey(runner), "Unknown 'runner' specified '%s', supported pipeline runners %s", runner, Sets.newTreeSet(SUPPORTED_PIPELINE_RUNNERS.keySet()));
                    convertedOptions.put("runner", SUPPORTED_PIPELINE_RUNNERS.get(runner));
                    continue;
                }
                if (returnType.isArray() && (SIMPLE_TYPES.contains(returnType.getComponentType()) || returnType.getComponentType().isEnum()) || Collection.class.isAssignableFrom(returnType)) {
                    ImmutableList<String> values = FluentIterable.from(entry.getValue()).transformAndConcat(new Function<String, Iterable<String>>(){

                        @Override
                        public Iterable<String> apply(String input) {
                            return Arrays.asList(input.split(","));
                        }
                    }).toList();
                    if (returnType.isArray() && !returnType.getComponentType().equals(String.class)) {
                        object = values.iterator();
                        while (object.hasNext()) {
                            String string2 = String.valueOf("Empty argument value is only allowed for String, String Array, and Collection, but received: ");
                            String string3 = String.valueOf(returnType);
                            String value2 = (String)object.next();
                            Preconditions.checkArgument(!value2.isEmpty(), new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).toString());
                        }
                    }
                    convertedOptions.put(entry.getKey(), MAPPER.convertValue(values, type));
                    continue;
                }
                if (SIMPLE_TYPES.contains(returnType) || returnType.isEnum()) {
                    value = (String)Iterables.getOnlyElement((Iterable)entry.getValue());
                    object = String.valueOf("Empty argument value is only allowed for String, String Array, and Collection, but received: ");
                    string = String.valueOf(returnType);
                    Preconditions.checkArgument(returnType.equals(String.class) || !value.isEmpty(), new StringBuilder(0 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(string).toString());
                    convertedOptions.put(entry.getKey(), MAPPER.convertValue((Object)value, type));
                    continue;
                }
                value = (String)Iterables.getOnlyElement((Iterable)entry.getValue());
                object = String.valueOf("Empty argument value is only allowed for String, String Array, and Collection, but received: ");
                string = String.valueOf(returnType);
                Preconditions.checkArgument(returnType.equals(String.class) || !value.isEmpty(), new StringBuilder(0 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(string).toString());
                try {
                    convertedOptions.put(entry.getKey(), MAPPER.readValue(value, type));
                }
                catch (IOException e) {
                    String string4 = String.valueOf(value);
                    throw new IllegalArgumentException(string4.length() != 0 ? "Unable to parse JSON value ".concat(string4) : new String("Unable to parse JSON value "), e);
                }
            }
            catch (IllegalArgumentException e) {
                if (strictParsing) {
                    throw e;
                }
                LOG.warn("Strict parsing is disabled, ignoring option '{}' with value '{}' because {}", new Object[]{entry.getKey(), entry.getValue(), e.getMessage()});
            }
        }
        return convertedOptions;
    }

    static /* synthetic */ String access$100() {
        return PipelineOptionsFactory.findCallersClassName();
    }

    static {
        PIPELINE_OPTIONS_FACTORY_CLASSES = ImmutableSet.of(PipelineOptionsFactory.class.getName(), Builder.class.getName());
        REGISTERED_OPTIONS = Sets.newConcurrentHashSet();
        INTERFACE_CACHE = Maps.newConcurrentMap();
        COMBINED_CACHE = Maps.newConcurrentMap();
        try {
            IGNORED_METHODS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Object.class.getMethod("getClass", new Class[0]))).add(Object.class.getMethod("wait", new Class[0]))).add(Object.class.getMethod("wait", Long.TYPE))).add(Object.class.getMethod("wait", Long.TYPE, Integer.TYPE))).add(Object.class.getMethod("notify", new Class[0]))).add(Object.class.getMethod("notifyAll", new Class[0]))).add(Proxy.class.getMethod("getInvocationHandler", Object.class))).build();
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.error("Unable to find expected method", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        ClassLoader classLoader = PipelineOptionsFactory.findClassLoader();
        ImmutableMap.Builder<String, Class<? extends PipelineRunner<?>>> builder = ImmutableMap.builder();
        TreeSet<Object> pipelineRunnerRegistrars = Sets.newTreeSet(ObjectsClassComparator.INSTANCE);
        pipelineRunnerRegistrars.addAll(Lists.newArrayList(ServiceLoader.load(PipelineRunnerRegistrar.class, classLoader)));
        for (PipelineRunnerRegistrar pipelineRunnerRegistrar : pipelineRunnerRegistrars) {
            for (Class<PipelineRunner<?>> klass : pipelineRunnerRegistrar.getPipelineRunners()) {
                builder.put(klass.getSimpleName(), klass);
            }
        }
        SUPPORTED_PIPELINE_RUNNERS = builder.build();
        PipelineOptionsFactory.register(PipelineOptions.class);
        TreeSet<Object> pipelineOptionsRegistrars = Sets.newTreeSet(ObjectsClassComparator.INSTANCE);
        pipelineOptionsRegistrars.addAll(Lists.newArrayList(ServiceLoader.load(PipelineOptionsRegistrar.class, classLoader)));
        for (PipelineOptionsRegistrar pipelineOptionsRegistrar : pipelineOptionsRegistrars) {
            for (Class<? extends PipelineOptions> klass : pipelineOptionsRegistrar.getPipelineOptions()) {
                PipelineOptionsFactory.register(klass);
            }
        }
    }

    static class JsonIgnorePredicate
    implements Predicate<Method> {
        static final JsonIgnorePredicate INSTANCE = new JsonIgnorePredicate();

        JsonIgnorePredicate() {
        }

        @Override
        public boolean apply(Method input) {
            return input.isAnnotationPresent(JsonIgnore.class);
        }
    }

    private static class MethodToDeclaringClassFunction
    implements Function<Method, Class<?>> {
        static final MethodToDeclaringClassFunction INSTANCE = new MethodToDeclaringClassFunction();

        private MethodToDeclaringClassFunction() {
        }

        @Override
        public Class<?> apply(Method input) {
            return input.getDeclaringClass();
        }
    }

    private static class ReturnTypeFetchingFunction
    implements Function<Method, Class<?>> {
        static final ReturnTypeFetchingFunction INSTANCE = new ReturnTypeFetchingFunction();

        private ReturnTypeFetchingFunction() {
        }

        @Override
        public Class<?> apply(Method input) {
            return input.getReturnType();
        }
    }

    static class MethodNameComparator
    implements Comparator<Method> {
        static final MethodNameComparator INSTANCE = new MethodNameComparator();

        MethodNameComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class MethodComparator
    implements Comparator<Method> {
        static final MethodComparator INSTANCE = new MethodComparator();

        private MethodComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return o1.toGenericString().compareTo(o2.toGenericString());
        }
    }

    private static class ObjectsClassComparator
    implements Comparator<Object> {
        static final ObjectsClassComparator INSTANCE = new ObjectsClassComparator();

        private ObjectsClassComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.getClass().getCanonicalName().compareTo(o2.getClass().getCanonicalName());
        }
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        static final ClassNameComparator INSTANCE = new ClassNameComparator();

        private ClassNameComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    static class Registration<T extends PipelineOptions> {
        private final Class<T> proxyClass;
        private final List<PropertyDescriptor> propertyDescriptors;

        public Registration(Class<T> proxyClass, List<PropertyDescriptor> beanInfo) {
            this.proxyClass = proxyClass;
            this.propertyDescriptors = beanInfo;
        }

        List<PropertyDescriptor> getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        Class<T> getProxyClass() {
            return this.proxyClass;
        }
    }

    public static class Builder {
        private final String defaultAppName = PipelineOptionsFactory.access$100();
        private final String[] args;
        private final boolean validation;
        private final boolean strictParsing;

        private Builder() {
            this(null, false, true);
        }

        private Builder(String[] args, boolean validation, boolean strictParsing) {
            this.args = args;
            this.validation = validation;
            this.strictParsing = strictParsing;
        }

        public Builder fromArgs(String[] args) {
            Preconditions.checkNotNull(args, "Arguments should not be null.");
            return new Builder(args, this.validation, this.strictParsing);
        }

        public Builder withValidation() {
            return new Builder(this.args, true, this.strictParsing);
        }

        public Builder withoutStrictParsing() {
            return new Builder(this.args, this.validation, false);
        }

        public PipelineOptions create() {
            return this.as(PipelineOptions.class);
        }

        public <T extends PipelineOptions> T as(Class<T> klass) {
            ProxyInvocationHandler handler;
            ApplicationNameOptions t;
            ApplicationNameOptions appNameOptions;
            Map<String, Object> initialOptions = Maps.newHashMap();
            if (this.args != null) {
                ListMultimap options = PipelineOptionsFactory.parseCommandLine(this.args, this.strictParsing);
                LOG.debug("Provided Arguments: {}", (Object)options);
                PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(options, System.out, true);
                initialOptions = PipelineOptionsFactory.parseObjects(klass, options, this.strictParsing);
            }
            if ((appNameOptions = (t = (handler = new ProxyInvocationHandler(initialOptions)).as(klass)).as(ApplicationNameOptions.class)).getAppName() == null) {
                appNameOptions.setAppName(this.defaultAppName);
            }
            if (this.validation) {
                PipelineOptionsValidator.validate(klass, t);
            }
            return (T)t;
        }
    }
}

