/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.options.BlockingDataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsValidator;
import com.google.cloud.dataflow.sdk.runners.DataflowJobCancelledException;
import com.google.cloud.dataflow.sdk.runners.DataflowJobExecutionException;
import com.google.cloud.dataflow.sdk.runners.DataflowJobUpdatedException;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineJob;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunnerHooks;
import com.google.cloud.dataflow.sdk.runners.DataflowServiceException;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.MonitoringUtil;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingDataflowPipelineRunner
extends PipelineRunner<DataflowPipelineJob> {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingDataflowPipelineRunner.class);
    private static final long BUILTIN_JOB_TIMEOUT_SEC = -1L;
    private final DataflowPipelineRunner dataflowPipelineRunner;
    private final BlockingDataflowPipelineOptions options;

    protected BlockingDataflowPipelineRunner(DataflowPipelineRunner internalRunner, BlockingDataflowPipelineOptions options) {
        this.dataflowPipelineRunner = internalRunner;
        this.options = options;
    }

    public static BlockingDataflowPipelineRunner fromOptions(PipelineOptions options) {
        BlockingDataflowPipelineOptions dataflowOptions = PipelineOptionsValidator.validate(BlockingDataflowPipelineOptions.class, options);
        DataflowPipelineRunner dataflowPipelineRunner = DataflowPipelineRunner.fromOptions(dataflowOptions);
        return new BlockingDataflowPipelineRunner(dataflowPipelineRunner, dataflowOptions);
    }

    @Override
    public DataflowPipelineJob run(Pipeline p) {
        final DataflowPipelineJob job = this.dataflowPipelineRunner.run(p);
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                LOG.warn("Job is already running in Google Cloud Platform, Ctrl-C will not cancel it.\nTo cancel the job in the cloud, run:\n> {}", (Object)MonitoringUtil.getGcloudCancelCommand(BlockingDataflowPipelineRunner.this.options, job.getJobId()));
            }
        };
        try {
            PipelineResult.State result;
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            try {
                result = job.waitToFinish(-1L, TimeUnit.SECONDS, new MonitoringUtil.PrintHandler(this.options.getJobMessageOutput()));
            }
            catch (IOException | InterruptedException ex) {
                LOG.debug("Exception caught while retrieving status for job {}", (Object)job.getJobId(), (Object)ex);
                String string = String.valueOf(job.getJobId());
                throw new DataflowServiceException(job, string.length() != 0 ? "Exception caught while retrieving status for job ".concat(string) : new String("Exception caught while retrieving status for job "), ex);
            }
            if (result == null) {
                String string = String.valueOf(job.getJobId());
                throw new DataflowServiceException(job, string.length() != 0 ? "Timed out while retrieving status for job ".concat(string) : new String("Timed out while retrieving status for job "));
            }
            LOG.info("Job finished with status {}", (Object)result);
            if (!result.isTerminal()) {
                String ex = job.getJobId();
                String string = String.valueOf((Object)result);
                throw new IllegalStateException(new StringBuilder(38 + String.valueOf(ex).length() + String.valueOf(string).length()).append("Expected terminal state for job ").append(ex).append(", got ").append(string).toString());
            }
            if (result == PipelineResult.State.DONE) {
                DataflowPipelineJob ex = job;
                return ex;
            }
            if (result == PipelineResult.State.UPDATED) {
                DataflowPipelineJob newJob = job.getReplacedByJob();
                LOG.info("Job {} has been updated and is running as the new job with id {}.To access the updated job on the Dataflow monitoring console, please navigate to {}", new Object[]{job.getJobId(), newJob.getJobId(), MonitoringUtil.getJobMonitoringPageURL(newJob.getProjectId(), newJob.getJobId())});
                throw new DataflowJobUpdatedException(job, String.format("Job %s updated; new job is %s.", job.getJobId(), newJob.getJobId()), newJob);
            }
            if (result == PipelineResult.State.CANCELLED) {
                String message = String.format("Job %s cancelled by user", job.getJobId());
                LOG.info(message);
                throw new DataflowJobCancelledException(job, message);
            }
            String string = job.getJobId();
            String string2 = String.valueOf((Object)result);
            throw new DataflowJobExecutionException(job, new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Job ").append(string).append(" failed with status ").append(string2).toString());
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
    }

    @Override
    public <OutputT extends POutput, InputT extends PInput> OutputT apply(PTransform<InputT, OutputT> transform, InputT input) {
        return this.dataflowPipelineRunner.apply(transform, input);
    }

    @Experimental
    public void setHooks(DataflowPipelineRunnerHooks hooks) {
        this.dataflowPipelineRunner.setHooks(hooks);
    }

    public String toString() {
        String string = String.valueOf(this.options.getJobName());
        return string.length() != 0 ? "BlockingDataflowPipelineRunner#".concat(string) : new String("BlockingDataflowPipelineRunner#");
    }
}

