/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.io.AvroIO;
import com.google.cloud.dataflow.sdk.io.BigQueryIO;
import com.google.cloud.dataflow.sdk.io.PubsubIO;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.io.TextIO;
import com.google.cloud.dataflow.sdk.io.UnboundedSource;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineDebugOptions;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsValidator;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.runners.AggregatorPipelineExtractor;
import com.google.cloud.dataflow.sdk.runners.DataflowJobAlreadyExistsException;
import com.google.cloud.dataflow.sdk.runners.DataflowJobAlreadyUpdatedException;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineJob;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunnerHooks;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineTranslator;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.runners.dataflow.BasicSerializableSourceFormat;
import com.google.cloud.dataflow.sdk.runners.dataflow.DataflowAggregatorTransforms;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.transforms.WithKeys;
import com.google.cloud.dataflow.sdk.transforms.Write;
import com.google.cloud.dataflow.sdk.transforms.windowing.AfterPane;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.DataflowReleaseInfo;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import com.google.cloud.dataflow.sdk.util.MonitoringUtil;
import com.google.cloud.dataflow.sdk.util.PCollectionViews;
import com.google.cloud.dataflow.sdk.util.PathValidator;
import com.google.cloud.dataflow.sdk.util.Reshuffle;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.dataflow.sdk.util.ValueWithRecordId;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PDone;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowPipelineRunner
extends PipelineRunner<DataflowPipelineJob> {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowPipelineRunner.class);
    private final DataflowPipelineOptions options;
    private final Dataflow dataflowClient;
    private final DataflowPipelineTranslator translator;
    private final Map<Class<?>, Class<?>> streamingOverrides;
    private DataflowPipelineRunnerHooks hooks;
    private static final String ENVIRONMENT_MAJOR_VERSION = "3";
    private static final int CREATE_JOB_REQUEST_LIMIT_BYTES = 0xA00000;
    public static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]+[a-z0-9]";

    public static DataflowPipelineRunner fromOptions(PipelineOptions options) {
        IOChannelUtils.registerStandardIOFactories(options);
        DataflowPipelineOptions dataflowOptions = PipelineOptionsValidator.validate(DataflowPipelineOptions.class, options);
        ArrayList<String> missing = new ArrayList<String>();
        if (dataflowOptions.getAppName() == null) {
            missing.add("appName");
        }
        if (missing.size() > 0) {
            String string = String.valueOf(Joiner.on(',').join(missing));
            throw new IllegalArgumentException(string.length() != 0 ? "Missing required values: ".concat(string) : new String("Missing required values: "));
        }
        PathValidator validator = dataflowOptions.getPathValidator();
        if (dataflowOptions.getStagingLocation() != null) {
            validator.validateOutputFilePrefixSupported(dataflowOptions.getStagingLocation());
        }
        if (dataflowOptions.getTempLocation() != null) {
            validator.validateOutputFilePrefixSupported(dataflowOptions.getTempLocation());
        }
        if (Strings.isNullOrEmpty(dataflowOptions.getTempLocation())) {
            dataflowOptions.setTempLocation(dataflowOptions.getStagingLocation());
        } else if (Strings.isNullOrEmpty(dataflowOptions.getStagingLocation())) {
            try {
                dataflowOptions.setStagingLocation(IOChannelUtils.resolve(dataflowOptions.getTempLocation(), "staging"));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to resolve PipelineOptions.stagingLocation from PipelineOptions.tempLocation. Please set the staging location explicitly.", e);
            }
        }
        if (dataflowOptions.getFilesToStage() == null) {
            dataflowOptions.setFilesToStage(DataflowPipelineRunner.detectClassPathResourcesToStage(DataflowPipelineRunner.class.getClassLoader()));
            LOG.info("PipelineOptions.filesToStage was not specified. Defaulting to files from the classpath: will stage {} files. Enable logging at DEBUG level to see which files will be staged.", (Object)dataflowOptions.getFilesToStage().size());
            LOG.debug("Classpath elements: {}", dataflowOptions.getFilesToStage());
        }
        String jobName = dataflowOptions.getJobName().toLowerCase();
        Preconditions.checkArgument(jobName.matches("[a-z]([-a-z0-9]*[a-z0-9])?"), "JobName invalid; the name must consist of only the characters [-a-z0-9], starting with a letter and ending with a letter or number");
        String project = dataflowOptions.getProject();
        if (project.matches("[0-9]*")) {
            throw new IllegalArgumentException(new StringBuilder(89 + String.valueOf(project).length()).append("Project ID '").append(project).append("' invalid. Please make sure you specified the Project ID, not project number.").toString());
        }
        if (!project.matches(PROJECT_ID_REGEXP)) {
            throw new IllegalArgumentException(new StringBuilder(94 + String.valueOf(project).length()).append("Project ID '").append(project).append("' invalid. Please make sure you specified the Project ID, not project description.").toString());
        }
        DataflowPipelineDebugOptions debugOptions = dataflowOptions.as(DataflowPipelineDebugOptions.class);
        if (debugOptions.getNumberOfWorkerHarnessThreads() < 0) {
            int n = debugOptions.getNumberOfWorkerHarnessThreads();
            throw new IllegalArgumentException(new StringBuilder(99).append("Number of worker harness threads '").append(n).append("' invalid. Please make sure the value is non-negative.").toString());
        }
        return new DataflowPipelineRunner(dataflowOptions);
    }

    @VisibleForTesting
    protected DataflowPipelineRunner(DataflowPipelineOptions options) {
        this.options = options;
        this.dataflowClient = options.getDataflowClient();
        this.translator = DataflowPipelineTranslator.fromOptions(options);
        this.streamingOverrides = ImmutableMap.builder().put(Combine.GloballyAsSingletonView.class, StreamingCombineGloballyAsSingletonView.class).put(Create.Values.class, StreamingCreate.class).put(View.AsMap.class, StreamingViewAsMap.class).put(View.AsMultimap.class, StreamingViewAsMultimap.class).put(View.AsSingleton.class, StreamingViewAsSingleton.class).put(View.AsIterable.class, StreamingViewAsIterable.class).put(Write.Bound.class, StreamingWrite.class).put(PubsubIO.Write.Bound.class, StreamingPubsubIOWrite.class).put(Read.Unbounded.class, StreamingUnboundedRead.class).put(Read.Bounded.class, StreamingUnsupportedIO.class).put(AvroIO.Read.Bound.class, StreamingUnsupportedIO.class).put(AvroIO.Write.Bound.class, StreamingUnsupportedIO.class).put(BigQueryIO.Read.Bound.class, StreamingUnsupportedIO.class).put(TextIO.Read.Bound.class, StreamingUnsupportedIO.class).put(TextIO.Write.Bound.class, StreamingUnsupportedIO.class).build();
    }

    @Override
    public <OutputT extends POutput, InputT extends PInput> OutputT apply(PTransform<InputT, OutputT> transform, InputT input) {
        if (Combine.GroupedValues.class.equals(transform.getClass()) || GroupByKey.class.equals(transform.getClass())) {
            PCollection pc = (PCollection)input;
            PCollection outputT = PCollection.createPrimitiveOutputInternal(pc.getPipeline(), transform instanceof GroupByKey ? ((GroupByKey)transform).updateWindowingStrategy(pc.getWindowingStrategy()) : pc.getWindowingStrategy(), pc.isBounded());
            return (OutputT)outputT;
        }
        if (this.options.isStreaming() && this.streamingOverrides.containsKey(transform.getClass())) {
            Class<?> transformClass = transform.getClass();
            Class<?> customTransformClass = this.streamingOverrides.get(transform.getClass());
            PTransform customTransform = (PTransform)InstanceBuilder.ofType(customTransformClass).withArg(transformClass, transform).build();
            return Pipeline.applyTransform(input, customTransform);
        }
        return super.apply(transform, input);
    }

    @Override
    public DataflowPipelineJob run(Pipeline pipeline) {
        Job jobResult;
        LOG.info("Executing pipeline on the Dataflow Service, which will have billing implications related to Google Compute Engine usage and other Google Cloud Services.");
        List<DataflowPackage> packages = this.options.getStager().stageFiles();
        DataflowPipelineTranslator.JobSpecification jobSpecification = this.translator.translate(pipeline, packages);
        Job newJob = jobSpecification.getJob();
        int randomNum = new Random().nextInt(9000) + 1000;
        String string = String.valueOf(DateTimeFormat.forPattern((String)"YYYYMMddHHmmssmmm").withZone(DateTimeZone.UTC).print(DateTimeUtils.currentTimeMillis()));
        String requestId = new StringBuilder(12 + String.valueOf(string).length()).append(string).append("_").append(randomNum).toString();
        newJob.setClientRequestId(requestId);
        String version = DataflowReleaseInfo.getReleaseInfo().getVersion();
        String string2 = String.valueOf(version);
        System.out.println(string2.length() != 0 ? "Dataflow SDK version: ".concat(string2) : new String("Dataflow SDK version: "));
        newJob.getEnvironment().setUserAgent((Map)((Object)DataflowReleaseInfo.getReleaseInfo()));
        DataflowPipelineOptions dataflowOptions = this.options.as(DataflowPipelineOptions.class);
        if (!Strings.isNullOrEmpty(this.options.getTempLocation())) {
            newJob.getEnvironment().setTempStoragePrefix(dataflowOptions.getPathValidator().verifyPath(this.options.getTempLocation()));
        }
        newJob.getEnvironment().setDataset(this.options.getTempDatasetId());
        newJob.getEnvironment().setExperiments(this.options.getExperiments());
        HashMap<String, String> environmentVersion = new HashMap<String, String>();
        environmentVersion.put("major", ENVIRONMENT_MAJOR_VERSION);
        newJob.getEnvironment().setVersion(environmentVersion);
        String jobType = "DATA_PARALLEL";
        if (this.options.isStreaming()) {
            jobType = "STREAMING";
        }
        environmentVersion.put("job_type", jobType);
        if (this.hooks != null) {
            this.hooks.modifyEnvironmentBeforeSubmission(newJob.getEnvironment());
        }
        if (!Strings.isNullOrEmpty(this.options.getDataflowJobFile())) {
            try (PrintWriter printWriter = new PrintWriter(new File(this.options.getDataflowJobFile()));){
                String workSpecJson = DataflowPipelineTranslator.jobToString(newJob);
                printWriter.print(workSpecJson);
                LOG.info("Printed workflow specification to {}", (Object)this.options.getDataflowJobFile());
            }
            catch (IllegalStateException ex) {
                LOG.warn("Cannot translate workflow spec to json for debug.");
            }
            catch (FileNotFoundException ex) {
                LOG.warn("Cannot create workflow spec output file.");
            }
        }
        String jobIdToUpdate = null;
        if (this.options.getUpdate()) {
            jobIdToUpdate = this.getJobIdFromName(this.options.getJobName());
            newJob.setTransformNameMapping(this.options.getTransformNameMapping());
            newJob.setReplaceJobId(jobIdToUpdate);
        }
        try {
            jobResult = (Job)this.dataflowClient.projects().jobs().create(this.options.getProject(), newJob).execute();
        }
        catch (GoogleJsonResponseException e) {
            String errorMessages = "Unexpected errors";
            if (e.getDetails() != null) {
                errorMessages = newJob.toString().getBytes(StandardCharsets.UTF_8).length >= 0xA00000 ? "The size of the serialized JSON representation of the pipeline exceeds the allowable limit. For more information, please check the FAQ link below:\nhttps://cloud.google.com/dataflow/faq" : e.getDetails().getMessage();
            }
            String string3 = String.valueOf(errorMessages);
            throw new RuntimeException(string3.length() != 0 ? "Failed to create a workflow job: ".concat(string3) : new String("Failed to create a workflow job: "), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a workflow job", e);
        }
        AggregatorPipelineExtractor aggregatorExtractor = new AggregatorPipelineExtractor(pipeline);
        Map<Aggregator<?, ?>, Collection<PTransform<?, ?>>> aggregatorSteps = aggregatorExtractor.getAggregatorSteps();
        DataflowAggregatorTransforms aggregatorTransforms = new DataflowAggregatorTransforms(aggregatorSteps, jobSpecification.getStepNames());
        DataflowPipelineJob dataflowPipelineJob = new DataflowPipelineJob(this.options.getProject(), jobResult.getId(), Transport.newRawDataflowClient(this.options).build(), aggregatorTransforms);
        if (jobResult.getClientRequestId() != null && !jobResult.getClientRequestId().isEmpty() && !jobResult.getClientRequestId().equals(requestId)) {
            if (this.options.getUpdate()) {
                throw new DataflowJobAlreadyUpdatedException(dataflowPipelineJob, String.format("The job named %s with id: %s has already been updated into job id: %s and cannot be updated again.", newJob.getName(), jobIdToUpdate, jobResult.getId()));
            }
            throw new DataflowJobAlreadyExistsException(dataflowPipelineJob, String.format("There is already an active job named %s with id: %s. If you want to submit a second job, try again by setting a different name using --jobName.", newJob.getName(), jobResult.getId()));
        }
        LOG.info("To access the Dataflow monitoring console, please navigate to {}", (Object)MonitoringUtil.getJobMonitoringPageURL(this.options.getProject(), jobResult.getId()));
        String string4 = String.valueOf(jobResult.getId());
        System.out.println(string4.length() != 0 ? "Submitted job: ".concat(string4) : new String("Submitted job: "));
        LOG.info("To cancel the job using the 'gcloud' tool, run:\n> {}", (Object)MonitoringUtil.getGcloudCancelCommand(this.options, jobResult.getId()));
        return dataflowPipelineJob;
    }

    public DataflowPipelineTranslator getTranslator() {
        return this.translator;
    }

    @Experimental
    public void setHooks(DataflowPipelineRunnerHooks hooks) {
        this.hooks = hooks;
    }

    public String toString() {
        String string = String.valueOf(this.options.getJobName());
        return string.length() != 0 ? "DataflowPipelineRunner#".concat(string) : new String("DataflowPipelineRunner#");
    }

    protected static List<String> detectClassPathResourcesToStage(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            String message = String.format("Unable to use ClassLoader to detect classpath elements. Current ClassLoader is %s, only URLClassLoaders are supported.", classLoader);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (URL url : ((URLClassLoader)classLoader).getURLs()) {
            try {
                files.add(new File(url.toURI()).getAbsolutePath());
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                String message = String.format("Unable to convert url (%s) to file.", url);
                LOG.error(message);
                throw new IllegalArgumentException(message, e);
            }
        }
        return files;
    }

    private String getJobIdFromName(String jobName) {
        try {
            String token = null;
            do {
                ListJobsResponse listResult = (ListJobsResponse)this.dataflowClient.projects().jobs().list(this.options.getProject()).setPageToken(token).execute();
                token = listResult.getNextPageToken();
                for (Job job : listResult.getJobs()) {
                    if (!job.getName().equals(jobName) || !MonitoringUtil.toState(job.getCurrentState()).equals((Object)PipelineResult.State.RUNNING)) continue;
                    return job.getId();
                }
            } while (token != null);
        }
        catch (GoogleJsonResponseException e) {
            String string = String.valueOf(e.getDetails() != null ? e.getDetails().getMessage() : e);
            throw new RuntimeException(new StringBuilder(33 + String.valueOf(string).length()).append("Got error while looking up jobs: ").append(string).toString(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Got error while looking up jobs: ", e);
        }
        String string = String.valueOf(jobName);
        throw new IllegalArgumentException(string.length() != 0 ? "Could not find running job named ".concat(string) : new String("Could not find running job named "));
    }

    private static class StreamingUnsupportedIO<InputT extends PInput, OutputT extends POutput>
    extends PTransform<InputT, OutputT> {
        private PTransform<?, ?> transform;

        public StreamingUnsupportedIO(AvroIO.Read.Bound<?> transform) {
            this.transform = transform;
        }

        public StreamingUnsupportedIO(BigQueryIO.Read.Bound transform) {
            this.transform = transform;
        }

        public StreamingUnsupportedIO(TextIO.Read.Bound<?> transform) {
            this.transform = transform;
        }

        public StreamingUnsupportedIO(Read.Bounded<?> transform) {
            this.transform = transform;
        }

        public StreamingUnsupportedIO(AvroIO.Write.Bound<?> transform) {
            this.transform = transform;
        }

        public StreamingUnsupportedIO(TextIO.Write.Bound<?> transform) {
            this.transform = transform;
        }

        @Override
        public OutputT apply(InputT input) {
            String string = String.valueOf(StringUtils.approximatePTransformName(this.transform.getClass()));
            throw new UnsupportedOperationException(string.length() != 0 ? "The DataflowPipelineRunner in streaming mode does not support ".concat(string) : new String("The DataflowPipelineRunner in streaming mode does not support "));
        }
    }

    private static class StreamingCombineGloballyAsSingletonView<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollectionView<OutputT>> {
        Combine.GloballyAsSingletonView<InputT, OutputT> transform;

        public StreamingCombineGloballyAsSingletonView(Combine.GloballyAsSingletonView<InputT, OutputT> transform) {
            this.transform = transform;
        }

        @Override
        public PCollectionView<OutputT> apply(PCollection<InputT> input) {
            PCollection combined = (PCollection)input.apply(Combine.globally(this.transform.getCombineFn()).withoutDefaults().withFanout(this.transform.getFanout()));
            PCollectionView<Object> view = PCollectionViews.singletonView(combined.getPipeline(), combined.getWindowingStrategy(), this.transform.getInsertDefault(), this.transform.getInsertDefault() ? (Object)this.transform.getCombineFn().apply(Collections.emptyList()) : null, combined.getCoder());
            return ((PCollection)((PCollection)combined.apply(ParDo.of(new WrapAsList()))).apply(ParDo.of(StreamingPCollectionViewWriterFn.create(view, combined.getCoder())))).apply(View.CreatePCollectionView.of(view));
        }

        @Override
        protected String getKindString() {
            return "StreamingCombineGloballyAsSingletonView";
        }
    }

    private static class StreamingViewAsSingleton<T>
    extends PTransform<PCollection<T>, PCollectionView<T>> {
        private View.AsSingleton<T> transform;

        public StreamingViewAsSingleton(View.AsSingleton<T> transform) {
            this.transform = transform;
        }

        @Override
        public PCollectionView<T> apply(PCollection<T> input) {
            Combine.Globally combine = Combine.globally(new SingletonCombine<T>(this.transform.hasDefaultValue(), this.transform.defaultValue()));
            if (!this.transform.hasDefaultValue()) {
                combine = combine.withoutDefaults();
            }
            return (PCollectionView)input.apply(combine.asSingletonView());
        }

        @Override
        protected String getKindString() {
            return "StreamingViewAsSingleton";
        }

        private static class SingletonCombine<T>
        extends Combine.BinaryCombineFn<T> {
            private boolean hasDefaultValue;
            private T defaultValue;

            SingletonCombine(boolean hasDefaultValue, T defaultValue) {
                this.hasDefaultValue = hasDefaultValue;
                this.defaultValue = defaultValue;
            }

            @Override
            public T apply(T left, T right) {
                throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view. Consider using Combine.globally().asSingleton() to combine the PCollection into a single value");
            }

            @Override
            public T identity() {
                if (this.hasDefaultValue) {
                    return this.defaultValue;
                }
                throw new IllegalArgumentException("Empty PCollection accessed as a singleton view. Consider setting withDefault to provide a default value");
            }
        }
    }

    private static class WrapAsList<T>
    extends DoFn<T, List<T>> {
        private WrapAsList() {
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
            c.output(Arrays.asList(c.element()));
        }
    }

    private static class StreamingViewAsIterable<T>
    extends PTransform<PCollection<T>, PCollectionView<Iterable<T>>> {
        public StreamingViewAsIterable(View.AsIterable<T> transform) {
        }

        @Override
        public PCollectionView<Iterable<T>> apply(PCollection<T> input) {
            Combine.GloballyAsSingletonView concatAndView = Combine.globally(new View.Concatenate()).asSingletonView();
            return (PCollectionView)input.apply(concatAndView);
        }

        @Override
        protected String getKindString() {
            return "StreamingViewAsIterable";
        }
    }

    private static class StreamingViewAsMultimap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, Iterable<V>>>> {
        public StreamingViewAsMultimap(View.AsMultimap<K, V> transform) {
        }

        @Override
        public PCollectionView<Map<K, Iterable<V>>> apply(PCollection<KV<K, V>> input) {
            PCollectionView<Map<K, Iterable<V>>> view = PCollectionViews.multimapView(input.getPipeline(), input.getWindowingStrategy(), input.getCoder());
            return (PCollectionView)((Object)((PCollection)((PCollection)input.apply(Combine.globally(new View.Concatenate()).withoutDefaults())).apply(ParDo.of(StreamingPCollectionViewWriterFn.create(view, input.getCoder())))).apply(View.CreatePCollectionView.of(view)));
        }

        @Override
        protected String getKindString() {
            return "StreamingViewAsMultimap";
        }
    }

    private static class StreamingViewAsMap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, V>>> {
        public StreamingViewAsMap(View.AsMap<K, V> transform) {
        }

        @Override
        public PCollectionView<Map<K, V>> apply(PCollection<KV<K, V>> input) {
            PCollectionView<Map<K, V>> view = PCollectionViews.mapView(input.getPipeline(), input.getWindowingStrategy(), input.getCoder());
            return (PCollectionView)((Object)((PCollection)((PCollection)input.apply(Combine.globally(new View.Concatenate()).withoutDefaults())).apply(ParDo.of(StreamingPCollectionViewWriterFn.create(view, input.getCoder())))).apply(View.CreatePCollectionView.of(view)));
        }

        @Override
        protected String getKindString() {
            return "StreamingViewAsMap";
        }
    }

    private static class StreamingPCollectionViewWriterFn<T>
    extends DoFn<Iterable<T>, T>
    implements DoFn.RequiresWindowAccess {
        private final PCollectionView<?> view;
        private final Coder<T> dataCoder;

        public static <T> StreamingPCollectionViewWriterFn<T> create(PCollectionView<?> view, Coder<T> dataCoder) {
            return new StreamingPCollectionViewWriterFn<T>(view, dataCoder);
        }

        private StreamingPCollectionViewWriterFn(PCollectionView<?> view, Coder<T> dataCoder) {
            this.view = view;
            this.dataCoder = dataCoder;
        }

        @Override
        public void processElement(DoFn.ProcessContext c) throws Exception {
            ArrayList output = new ArrayList();
            for (Object elem : (Iterable)c.element()) {
                output.add(WindowedValue.of(elem, c.timestamp(), c.window(), c.pane()));
            }
            c.windowingInternals().writePCollectionViewData(this.view.getTagInternal(), output, this.dataCoder);
        }
    }

    private static class StreamingCreate<T>
    extends PTransform<PInput, PCollection<T>> {
        private final Create.Values<T> transform;

        public StreamingCreate(Create.Values<T> transform) {
            this.transform = transform;
        }

        @Override
        public PCollection<T> apply(PInput input) {
            try {
                Coder<T> coder = this.transform.getDefaultOutputCoder(input);
                return ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((Object)((PCollection)Pipeline.applyTransform(input, PubsubIO.Read.named("StartingSignal").subscription("_starting_signal/"))).apply(ParDo.of(new OutputNullKv())))).apply("GlobalSingleton", Window.into(new GlobalWindows()).triggering(AfterPane.elementCountAtLeast(1)).withAllowedLateness(Duration.ZERO).discardingFiredPanes())).apply(GroupByKey.create())).setWindowingStrategyInternal(WindowingStrategy.globalDefault()).apply(Window.into(new GlobalWindows()))).apply(ParDo.of(new OutputElements<T>(this.transform.getElements(), coder)))).setCoder((Coder)coder)).setIsBoundedInternal(PCollection.IsBounded.BOUNDED);
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking Create.withCoder() explicitly.", e);
            }
        }

        @Override
        protected String getKindString() {
            return "StreamingCreate";
        }

        private static class OutputElements<T>
        extends DoFn<Object, T> {
            private final Coder<T> coder;
            private final List<byte[]> encodedElements;

            public OutputElements(Iterable<T> elems, Coder<T> coder) {
                this.coder = coder;
                this.encodedElements = new ArrayList<byte[]>();
                for (T t : elems) {
                    try {
                        this.encodedElements.add(CoderUtils.encodeToByteArray(coder, t));
                    }
                    catch (CoderException e) {
                        String string = String.valueOf(t);
                        String string2 = String.valueOf(coder);
                        throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to encode value ").append(string).append(" with coder ").append(string2).toString(), e);
                    }
                }
            }

            @Override
            public void processElement(DoFn.ProcessContext c) throws IOException {
                for (byte[] encodedElement : this.encodedElements) {
                    c.output(CoderUtils.decodeFromByteArray(this.coder, encodedElement));
                }
            }
        }

        private static class OutputNullKv
        extends DoFn<String, KV<Void, Void>> {
            private OutputNullKv() {
            }

            @Override
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output(KV.of(null, null));
            }
        }
    }

    private static class Deduplicate<T>
    extends PTransform<PCollection<ValueWithRecordId<T>>, PCollection<T>> {
        private static final int NUM_RESHARD_KEYS = 10000;

        private Deduplicate() {
        }

        @Override
        public PCollection<T> apply(PCollection<ValueWithRecordId<T>> input) {
            return (PCollection)((PCollection)((PCollection)input.apply(WithKeys.of(new SerializableFunction<ValueWithRecordId<T>, Integer>(){

                @Override
                public Integer apply(ValueWithRecordId<T> value) {
                    return Arrays.hashCode(value.getId()) % 10000;
                }
            }))).apply(Reshuffle.of())).apply(ParDo.named("StripIds").of(new DoFn<KV<Integer, ValueWithRecordId<T>>, T>(){

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    c.output(((ValueWithRecordId)((KV)c.element()).getValue()).getValue());
                }
            }));
        }
    }

    private static class StreamingUnboundedRead<T>
    extends PTransform<PInput, PCollection<T>> {
        private final UnboundedSource<T, ?> source;

        public StreamingUnboundedRead(Read.Unbounded<T> transform) {
            this.source = transform.getSource();
        }

        @Override
        protected Coder<T> getDefaultOutputCoder() {
            return this.source.getDefaultOutputCoder();
        }

        @Override
        public final PCollection<T> apply(PInput input) {
            this.source.validate();
            if (this.source.requiresDeduping()) {
                return (PCollection)((PCollection)Pipeline.applyTransform(input, new ReadWithIds(this.source))).apply(new Deduplicate());
            }
            return ((PCollection)Pipeline.applyTransform(input, new ReadWithIds(this.source))).apply(ValueWithRecordId.stripIds());
        }

        @Override
        public String getKindString() {
            String string = StringUtils.approximateSimpleName(this.source.getClass());
            return new StringBuilder(6 + String.valueOf(string).length()).append("Read(").append(string).append(")").toString();
        }

        static {
            DataflowPipelineTranslator.registerTransformTranslator(ReadWithIds.class, new ReadWithIdsTranslator());
        }

        private static class ReadWithIdsTranslator
        implements DataflowPipelineTranslator.TransformTranslator<ReadWithIds<?>> {
            private ReadWithIdsTranslator() {
            }

            @Override
            public void translate(ReadWithIds<?> transform, DataflowPipelineTranslator.TranslationContext context) {
                BasicSerializableSourceFormat.translateReadHelper(transform.getSource(), transform, context);
            }
        }

        private static class ReadWithIds<T>
        extends PTransform<PInput, PCollection<ValueWithRecordId<T>>> {
            private final UnboundedSource<T, ?> source;

            private ReadWithIds(UnboundedSource<T, ?> source) {
                this.source = source;
            }

            @Override
            public final PCollection<ValueWithRecordId<T>> apply(PInput input) {
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED);
            }

            @Override
            protected Coder<ValueWithRecordId<T>> getDefaultOutputCoder() {
                return ValueWithRecordId.ValueWithRecordIdCoder.of(this.source.getDefaultOutputCoder());
            }

            public UnboundedSource<T, ?> getSource() {
                return this.source;
            }
        }
    }

    public static class StreamingPubsubIOWrite<T>
    extends PTransform<PCollection<T>, PDone> {
        private final PubsubIO.Write.Bound<T> transform;

        public StreamingPubsubIOWrite(PubsubIO.Write.Bound<T> transform) {
            this.transform = transform;
        }

        public PubsubIO.Write.Bound<T> getOverriddenTransform() {
            return this.transform;
        }

        @Override
        public PDone apply(PCollection<T> input) {
            return PDone.in(input.getPipeline());
        }

        @Override
        protected String getKindString() {
            return "StreamingPubsubIOWrite";
        }
    }

    private static class StreamingWrite<T>
    extends PTransform<PCollection<T>, PDone> {
        public StreamingWrite(Write.Bound<T> transform) {
        }

        @Override
        public PDone apply(PCollection<T> input) {
            throw new UnsupportedOperationException("The Write transform is not supported by the Dataflow streaming runner.");
        }

        @Override
        protected String getKindString() {
            return "StreamingWrite";
        }
    }
}

