/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.cloud.dataflow.sdk.io.PubsubIO;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineTranslator;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.PValue;

public class PubsubIOTranslator {

    public static class WriteTranslator<T>
    implements DataflowPipelineTranslator.TransformTranslator<DataflowPipelineRunner.StreamingPubsubIOWrite<T>> {
        @Override
        public void translate(DataflowPipelineRunner.StreamingPubsubIOWrite transform, DataflowPipelineTranslator.TranslationContext context) {
            this.translateWriteHelper(transform, context);
        }

        private <T> void translateWriteHelper(DataflowPipelineRunner.StreamingPubsubIOWrite<T> customTransform, DataflowPipelineTranslator.TranslationContext context) {
            if (!context.getPipelineOptions().isStreaming()) {
                throw new IllegalArgumentException("PubsubIO.Write is non-primitive for the Dataflow batch runner.");
            }
            PubsubIO.Write.Bound<T> transform = customTransform.getOverriddenTransform();
            context.addStep(customTransform, "ParallelWrite");
            context.addInput("format", "pubsub");
            context.addInput("pubsub_topic", transform.getTopic().asV1Beta1Path());
            if (transform.getTimestampLabel() != null) {
                context.addInput("pubsub_timestamp_label", transform.getTimestampLabel());
            }
            if (transform.getIdLabel() != null) {
                context.addInput("pubsub_id_label", transform.getIdLabel());
            }
            context.addEncodingInput(WindowedValue.getValueOnlyCoder(transform.getCoder()));
            context.addInput("parallel_input", (PInput)context.getInput(customTransform));
        }
    }

    public static class ReadTranslator<T>
    implements DataflowPipelineTranslator.TransformTranslator<PubsubIO.Read.Bound<T>> {
        @Override
        public void translate(PubsubIO.Read.Bound transform, DataflowPipelineTranslator.TranslationContext context) {
            this.translateReadHelper(transform, context);
        }

        private <T> void translateReadHelper(PubsubIO.Read.Bound<T> transform, DataflowPipelineTranslator.TranslationContext context) {
            if (!context.getPipelineOptions().isStreaming()) {
                throw new IllegalArgumentException("PubsubIO.Read can only be used with the Dataflow streaming runner.");
            }
            context.addStep(transform, "ParallelRead");
            context.addInput("format", "pubsub");
            if (transform.getTopic() != null) {
                context.addInput("pubsub_topic", transform.getTopic().asV1Beta1Path());
            }
            if (transform.getSubscription() != null) {
                context.addInput("pubsub_subscription", transform.getSubscription().asV1Beta1Path());
            }
            if (transform.getTimestampLabel() != null) {
                context.addInput("pubsub_timestamp_label", transform.getTimestampLabel());
            }
            if (transform.getIdLabel() != null) {
                context.addInput("pubsub_id_label", transform.getIdLabel());
            }
            context.addValueOnlyOutput("output", (PValue)context.getOutput(transform));
        }
    }
}

