/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.cloud.dataflow.sdk.io.TextIO;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineTranslator;
import com.google.cloud.dataflow.sdk.util.PathValidator;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.PValue;

public class TextIOTranslator {

    public static class WriteTranslator
    implements DataflowPipelineTranslator.TransformTranslator<TextIO.Write.Bound> {
        @Override
        public void translate(TextIO.Write.Bound transform, DataflowPipelineTranslator.TranslationContext context) {
            this.translateWriteHelper(transform, context);
        }

        private <T> void translateWriteHelper(TextIO.Write.Bound<T> transform, DataflowPipelineTranslator.TranslationContext context) {
            if (context.getPipelineOptions().isStreaming()) {
                throw new IllegalArgumentException("TextIO not supported in streaming mode.");
            }
            PathValidator validator = context.getPipelineOptions().getPathValidator();
            String filenamePrefix = validator.validateOutputFilePrefixSupported(transform.getFilenamePrefix());
            context.addStep(transform, "ParallelWrite");
            context.addInput("parallel_input", (PInput)context.getInput(transform));
            switch (transform.getShardTemplate()) {
                case "-SSSSS-of-NNNNN": {
                    break;
                }
                case "": {
                    Preconditions.checkArgument(transform.getNumShards() <= 1, "Num shards must be <= 1 when using an empty sharding template");
                    break;
                }
                default: {
                    String string = transform.getShardTemplate();
                    throw new UnsupportedOperationException(new StringBuilder(53 + String.valueOf(string).length()).append("Shard template ").append(string).append(" not yet supported by Dataflow service").toString());
                }
            }
            context.addInput("format", "text");
            context.addInput("filename_prefix", filenamePrefix);
            context.addInput("shard_template", transform.getShardNameTemplate());
            context.addInput("filename_suffix", transform.getFilenameSuffix());
            context.addInput("validate_sink", transform.needsValidation());
            long numShards = transform.getNumShards();
            if (numShards > 0L) {
                context.addInput("num_shards", numShards);
            }
            context.addEncodingInput(WindowedValue.getValueOnlyCoder(transform.getCoder()));
        }
    }

    public static class ReadTranslator
    implements DataflowPipelineTranslator.TransformTranslator<TextIO.Read.Bound> {
        @Override
        public void translate(TextIO.Read.Bound transform, DataflowPipelineTranslator.TranslationContext context) {
            this.translateReadHelper(transform, context);
        }

        private <T> void translateReadHelper(TextIO.Read.Bound<T> transform, DataflowPipelineTranslator.TranslationContext context) {
            if (context.getPipelineOptions().isStreaming()) {
                throw new IllegalArgumentException("TextIO not supported in streaming mode.");
            }
            PathValidator validator = context.getPipelineOptions().getPathValidator();
            String filepattern = validator.validateInputFilePatternSupported(transform.getFilepattern());
            context.addStep(transform, "ParallelRead");
            context.addInput("format", "text");
            context.addInput("filepattern", filepattern);
            context.addValueOnlyOutput("output", (PValue)context.getOutput(transform));
            context.addInput("validate_source", transform.needsValidation());
            context.addInput("compression_type", transform.getCompressionType().toString());
        }
    }
}

