/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.MultiOutputInfo;
import com.google.api.services.dataflow.model.SideInputInfo;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.worker.DataflowExecutionContext;
import com.google.cloud.dataflow.sdk.runners.worker.ParDoFnBase;
import com.google.cloud.dataflow.sdk.runners.worker.ParDoFnFactory;
import com.google.cloud.dataflow.sdk.util.AssignWindowsDoFn;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.DoFnInfo;
import com.google.cloud.dataflow.sdk.util.NullSideInputReader;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.ParDoFn;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class AssignWindowsParDoFn
extends ParDoFnBase {
    private final AssignWindowsDoFn<?, ?> fn;

    static AssignWindowsParDoFn of(PipelineOptions options, AssignWindowsDoFn<?, ?> fn, String stepName, String transformName, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) throws Exception {
        return new AssignWindowsParDoFn(options, fn, stepName, transformName, executionContext, addCounterMutator, stateSampler);
    }

    @Override
    protected DoFnInfo<?, ?> getDoFnInfo() {
        return new DoFnInfo(this.fn, null);
    }

    private AssignWindowsParDoFn(PipelineOptions options, AssignWindowsDoFn<?, ?> fn, String stepName, String transformName, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        super(options, NullSideInputReader.empty(), Arrays.asList("output"), stepName, transformName, executionContext, addCounterMutator, stateSampler);
        this.fn = fn;
    }

    static final class Factory
    implements ParDoFnFactory {
        Factory() {
        }

        @Override
        public ParDoFn create(PipelineOptions options, CloudObject cloudUserFn, String stepName, String transformName, @Nullable List<SideInputInfo> sideInputInfos, @Nullable List<MultiOutputInfo> multiOutputInfos, int numOutputs, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) throws Exception {
            Object deserializedWindowingStrategy = SerializableUtils.deserializeFromByteArray(Structs.getBytes((Map<String, Object>)((Object)cloudUserFn), "serialized_fn"), "serialized windowing strategy");
            String string = String.valueOf(deserializedWindowingStrategy.getClass().getName());
            Preconditions.checkArgument(deserializedWindowingStrategy instanceof WindowingStrategy, string.length() != 0 ? "unexpected kind of WindowingStrategy: ".concat(string) : new String("unexpected kind of WindowingStrategy: "));
            WindowingStrategy windowingStrategy = (WindowingStrategy)deserializedWindowingStrategy;
            AssignWindowsDoFn assignFn = new AssignWindowsDoFn(windowingStrategy.getWindowFn());
            return AssignWindowsParDoFn.of(options, assignFn, stepName, transformName, executionContext, addCounterMutator, stateSampler);
        }
    }
}

