/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.coders.AvroCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.runners.worker.AvroSink;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.worker.Sink;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;

public class AvroByteSink<T>
extends Sink<T> {
    final AvroSink<ByteBuffer> avroSink;
    final Coder<T> coder;
    private final Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);

    public AvroByteSink(String filenamePrefix, Coder<T> coder) {
        this(filenamePrefix, "", "", 1, coder);
    }

    public AvroByteSink(String filenamePrefix, String shardFormat, String filenameSuffix, int shardCount, Coder<T> coder) {
        this.coder = coder;
        this.avroSink = new AvroSink<ByteBuffer>(filenamePrefix, shardFormat, filenameSuffix, shardCount, WindowedValue.getValueOnlyCoder(AvroCoder.of(ByteBuffer.class, this.schema)));
    }

    @Override
    public Sink.SinkWriter<T> writer() throws IOException {
        return new AvroByteFileWriter();
    }

    class AvroByteFileWriter
    implements Sink.SinkWriter<T> {
        private final Sink.SinkWriter<WindowedValue<ByteBuffer>> avroFileWriter;

        public AvroByteFileWriter() throws IOException {
            this.avroFileWriter = AvroByteSink.this.avroSink.writer((DatumWriter<ByteBuffer>)new GenericDatumWriter(AvroByteSink.this.schema));
        }

        @Override
        public long add(T value) throws IOException {
            byte[] encodedElem = CoderUtils.encodeToByteArray(AvroByteSink.this.coder, value);
            ByteBuffer encodedBuffer = ByteBuffer.wrap(encodedElem);
            this.avroFileWriter.add(WindowedValue.valueInGlobalWindow(encodedBuffer));
            return encodedElem.length;
        }

        @Override
        public void close() throws IOException {
            this.avroFileWriter.close();
        }
    }
}

