/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.ApproximateProgress;
import com.google.api.services.dataflow.model.Position;
import com.google.cloud.dataflow.sdk.coders.AvroCoder;
import com.google.cloud.dataflow.sdk.runners.worker.InMemoryReader;
import com.google.cloud.dataflow.sdk.runners.worker.LazyMultiReaderIterator;
import com.google.cloud.dataflow.sdk.runners.worker.SourceTranslationUtils;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.worker.AbstractBoundedReaderIterator;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroReader<T>
extends Reader<WindowedValue<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryReader.class);
    final String filename;
    @Nullable
    final Long startPosition;
    @Nullable
    final Long endPosition;
    final AvroCoder<T> avroCoder;

    public AvroReader(String filename, @Nullable Long startPosition, @Nullable Long endPosition, WindowedValue.ValueOnlyWindowedValueCoder<T> coder) {
        if (!(coder.getValueCoder() instanceof AvroCoder)) {
            throw new IllegalArgumentException("AvroReader requires an AvroCoder");
        }
        this.filename = filename;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.avroCoder = (AvroCoder)coder.getValueCoder();
    }

    public Reader.ReaderIterator<WindowedValue<T>> iterator(DatumReader<T> datumReader) throws IOException {
        IOChannelFactory factory = IOChannelUtils.getFactory(this.filename);
        Collection<String> inputs = factory.match(this.filename);
        if (inputs.isEmpty()) {
            String string = this.filename;
            throw new FileNotFoundException(new StringBuilder(28 + String.valueOf(string).length()).append("No match for file pattern '").append(string).append("'").toString());
        }
        if (inputs.size() == 1) {
            String input = inputs.iterator().next();
            ReadableByteChannel reader = factory.open(input);
            return new AvroFileIterator(datumReader, input, reader, this.startPosition, this.endPosition);
        }
        if (this.startPosition != null || this.endPosition != null) {
            String string = String.valueOf(this.startPosition);
            String string2 = String.valueOf(this.endPosition);
            String string3 = this.filename;
            int n = inputs.size();
            throw new IllegalArgumentException(new StringBuilder(153 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Offset range specified: [").append(string).append(", ").append(string2).append("), so ").append("an exact filename was expected, but more than 1 file matched \"").append(string3).append("\" (total ").append(n).append("): apparently a filepattern was given.").toString());
        }
        return new AvroFileMultiIterator(datumReader, factory, inputs.iterator());
    }

    @Override
    public Reader.ReaderIterator<WindowedValue<T>> iterator() throws IOException {
        return this.iterator(this.avroCoder.createDatumReader());
    }

    static class SeekableByteChannelInput
    implements SeekableInput {
        final SeekableByteChannel channel;

        public SeekableByteChannelInput(SeekableByteChannel channel) {
            this.channel = channel;
        }

        public void seek(long position) throws IOException {
            this.channel.position(position);
        }

        public long tell() throws IOException {
            return this.channel.position();
        }

        public long length() throws IOException {
            return this.channel.size();
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            return this.channel.read(ByteBuffer.wrap(b, offset, length));
        }

        public void close() throws IOException {
            this.channel.close();
        }
    }

    class AvroFileIterator
    extends AbstractBoundedReaderIterator<WindowedValue<T>> {
        final DataFileReader<T> fileReader;
        final Long endOffset;

        public AvroFileIterator(DatumReader<T> datumReader, String filename, @Nullable ReadableByteChannel reader, @Nullable Long startOffset, Long endOffset) throws IOException {
            if (!(reader instanceof SeekableByteChannel)) {
                String string = String.valueOf(filename);
                throw new UnsupportedOperationException(string.length() != 0 ? "Unable to seek to offset in stream for ".concat(string) : new String("Unable to seek to offset in stream for "));
            }
            SeekableByteChannel inChannel = (SeekableByteChannel)reader;
            SeekableByteChannelInput seekableInput = new SeekableByteChannelInput(inChannel);
            this.fileReader = new DataFileReader((SeekableInput)seekableInput, datumReader);
            this.endOffset = endOffset;
            if (startOffset != null && startOffset > 0L) {
                this.fileReader.sync(startOffset.longValue());
            }
        }

        @Override
        protected boolean hasNextImpl() throws IOException {
            return this.fileReader.hasNext() && (this.endOffset == null || !this.fileReader.pastSync(this.endOffset.longValue()));
        }

        @Override
        protected WindowedValue<T> nextImpl() throws IOException {
            Object next = this.fileReader.next();
            AvroReader.this.notifyElementRead(CoderUtils.encodeToByteArray(AvroReader.this.avroCoder, next).length);
            return WindowedValue.valueInGlobalWindow(next);
        }

        @Override
        public Reader.Progress getProgress() {
            Position currentPosition = new Position();
            ApproximateProgress progress = new ApproximateProgress();
            try {
                currentPosition.setByteOffset(Long.valueOf(this.fileReader.tell()));
                progress.setPosition(currentPosition);
            }
            catch (IOException e) {
                LOG.warn("Avro source file {} failed to report current progress.", (Object)AvroReader.this.filename);
            }
            return SourceTranslationUtils.cloudProgressToReaderProgress(progress);
        }

        @Override
        public void close() throws IOException {
            this.fileReader.close();
        }
    }

    class AvroFileMultiIterator
    extends LazyMultiReaderIterator<WindowedValue<T>> {
        private final IOChannelFactory factory;
        private final DatumReader<T> datumReader;

        public AvroFileMultiIterator(DatumReader<T> datumReader, IOChannelFactory factory, Iterator<String> inputs) {
            super(inputs);
            this.factory = factory;
            this.datumReader = datumReader;
        }

        @Override
        protected Reader.ReaderIterator<WindowedValue<T>> open(String input) throws IOException {
            return new AvroFileIterator(this.datumReader, input, this.factory.open(input), null, null);
        }
    }
}

