/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.AvroByteReader;
import com.google.cloud.dataflow.sdk.runners.worker.AvroReader;
import com.google.cloud.dataflow.sdk.runners.worker.ReaderFactory;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.util.Map;
import javax.annotation.Nullable;

public class AvroReaderFactory
implements ReaderFactory {
    @Override
    public Reader<?> create(CloudObject spec, @Nullable Coder<?> coder, @Nullable PipelineOptions options, @Nullable ExecutionContext executionContext, @Nullable CounterSet.AddCounterMutator addCounterMutator, @Nullable String operationName) throws Exception {
        return this.create(spec, coder);
    }

    Reader<?> create(CloudObject spec, Coder<?> coder) throws Exception {
        String filename = Structs.getString((Map<String, Object>)((Object)spec), "filename");
        Long startOffset = Structs.getLong((Map<String, Object>)((Object)spec), "start_offset", null);
        Long endOffset = Structs.getLong((Map<String, Object>)((Object)spec), "end_offset", null);
        if (coder instanceof WindowedValue.ValueOnlyWindowedValueCoder) {
            return new AvroReader(filename, startOffset, endOffset, (WindowedValue.ValueOnlyWindowedValueCoder)coder);
        }
        return new AvroByteReader(filename, startOffset, endOffset, coder);
    }
}

