/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.AvroByteSink;
import com.google.cloud.dataflow.sdk.runners.worker.AvroSink;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Sink;
import java.util.Map;

public final class AvroSinkFactory {
    private AvroSinkFactory() {
    }

    public static <T> Sink<T> create(PipelineOptions options, CloudObject spec, Coder<T> coder, ExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator) throws Exception {
        return AvroSinkFactory.create(spec, coder);
    }

    static <T> Sink<T> create(CloudObject spec, Coder<T> coder) throws Exception {
        String filename = Structs.getString((Map<String, Object>)((Object)spec), "filename");
        if (coder instanceof WindowedValue.ValueOnlyWindowedValueCoder) {
            return new AvroSink(filename, (WindowedValue.ValueOnlyWindowedValueCoder)coder);
        }
        return new AvroByteSink<T>(filename, coder);
    }
}

