/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import com.google.cloud.dataflow.sdk.options.GcpOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.BigQueryReader;
import com.google.cloud.dataflow.sdk.runners.worker.ReaderFactory;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.util.Map;
import javax.annotation.Nullable;

public class BigQueryReaderFactory
implements ReaderFactory {
    @Override
    public Reader<?> create(CloudObject spec, @Nullable Coder<?> coder, @Nullable PipelineOptions options, @Nullable ExecutionContext executionContext, @Nullable CounterSet.AddCounterMutator addCounterMutator, @Nullable String operationName) throws Exception {
        return this.createTyped(spec, coder, options, executionContext);
    }

    public BigQueryReader createTyped(CloudObject spec, Coder<?> coder, PipelineOptions options, ExecutionContext executionContext) throws Exception {
        String query = Structs.getString((Map<String, Object>)((Object)spec), "bigquery_query", null);
        if (query != null) {
            GcpOptions gcpOptions = options.as(GcpOptions.class);
            return new BigQueryReader(options.as(BigQueryOptions.class), query, gcpOptions.getProject());
        }
        String tableId = Structs.getString((Map<String, Object>)((Object)spec), "table", null);
        if (tableId != null) {
            return new BigQueryReader(options.as(BigQueryOptions.class), new TableReference().setProjectId(Structs.getString((Map<String, Object>)((Object)spec), "project")).setDatasetId(Structs.getString((Map<String, Object>)((Object)spec), "dataset")).setTableId(tableId));
        }
        throw new IllegalArgumentException("Either a table or a query has to be specified");
    }
}

