/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.client.util.Base64;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.primitives.UnsignedBytes;
import com.google.cloud.dataflow.sdk.util.common.worker.ShufflePosition;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ByteArrayShufflePosition
implements Comparable<ByteArrayShufflePosition>,
ShufflePosition {
    private final byte[] position;

    public ByteArrayShufflePosition(byte[] position) {
        this.position = position;
    }

    public static ByteArrayShufflePosition fromBase64(@Nullable String position) {
        return ByteArrayShufflePosition.of(Base64.decodeBase64((String)position));
    }

    public static ByteArrayShufflePosition of(@Nullable byte[] position) {
        if (position == null) {
            return null;
        }
        return new ByteArrayShufflePosition(position);
    }

    public static byte[] getPosition(@Nullable ShufflePosition shufflePosition) {
        if (shufflePosition == null) {
            return null;
        }
        Preconditions.checkArgument(shufflePosition instanceof ByteArrayShufflePosition);
        ByteArrayShufflePosition adapter = (ByteArrayShufflePosition)shufflePosition;
        return adapter.getPosition();
    }

    public byte[] getPosition() {
        return this.position;
    }

    public String encodeBase64() {
        return Base64.encodeBase64URLSafeString((byte[])this.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ByteArrayShufflePosition) {
            ByteArrayShufflePosition that = (ByteArrayShufflePosition)o;
            return Arrays.equals(this.position, that.position);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.position);
    }

    public String toString() {
        String string = this.encodeBase64();
        return new StringBuilder(24 + String.valueOf(string).length()).append("ShufflePosition(base64:").append(string).append(")").toString();
    }

    @Override
    public int compareTo(ByteArrayShufflePosition o) {
        if (this == o) {
            return 0;
        }
        return UnsignedBytes.lexicographicalComparator().compare(this.position, o.position);
    }
}

