/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.client.util.Preconditions;
import com.google.cloud.dataflow.sdk.runners.worker.ShuffleEntryWriter;
import com.google.cloud.dataflow.sdk.runners.worker.ShuffleWriter;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class ChunkingShuffleEntryWriter
implements ShuffleEntryWriter {
    private static final int MAX_CHUNK_SIZE = 0x100000;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private ByteArrayOutputStream chunk = new ByteArrayOutputStream();
    private DataOutputStream output = new DataOutputStream(this.chunk);
    private final ShuffleWriter writer;

    public ChunkingShuffleEntryWriter(ShuffleWriter writer) {
        this.writer = (ShuffleWriter)Preconditions.checkNotNull((Object)writer);
    }

    @Override
    public void put(ShuffleEntry entry) throws IOException {
        if (this.chunk.size() >= 0x100000) {
            this.writeChunk();
        }
        ChunkingShuffleEntryWriter.putFixedLengthPrefixedByteArray(entry.getKey(), this.output);
        ChunkingShuffleEntryWriter.putFixedLengthPrefixedByteArray(entry.getSecondaryKey(), this.output);
        ChunkingShuffleEntryWriter.putFixedLengthPrefixedByteArray(entry.getValue(), this.output);
    }

    @Override
    public void close() throws IOException {
        this.writeChunk();
        this.writer.close();
    }

    private void writeChunk() throws IOException {
        if (this.chunk.size() > 0) {
            this.writer.write(this.chunk.toByteArray());
            this.chunk.reset();
            this.output = new DataOutputStream(this.chunk);
        }
    }

    static void putFixedLengthPrefixedByteArray(byte[] data, DataOutputStream output) throws IOException {
        if (data == null) {
            data = EMPTY_BYTES;
        }
        output.writeInt(data.length);
        output.write(data, 0, data.length);
    }
}

