/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.GuardedBy;

final class CopyableSeekableByteChannel
implements SeekableByteChannel {
    private long pos;
    private final Sync sync;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyableSeekableByteChannel(SeekableByteChannel base) throws IOException {
        this(new Sync(base), 0L);
        Sync sync = this.sync;
        synchronized (sync) {
            this.pos = this.sync.position = base.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CopyableSeekableByteChannel(Sync sync, long pos) {
        this.sync = (Sync)Preconditions.checkNotNull((Object)sync);
        Preconditions.checkState((boolean)sync.base.isOpen(), (Object)"the base SeekableByteChannel is not open");
        Sync sync2 = sync;
        synchronized (sync2) {
            ++sync.refCount;
        }
        this.pos = pos;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyableSeekableByteChannel copy() throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            return new CopyableSeekableByteChannel(this.sync, this.pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            return this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyableSeekableByteChannel position(long newPosition) throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            this.sync.base.position(newPosition);
            this.pos = newPosition;
            this.sync.position = newPosition;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            this.reposition();
            int bytesRead = this.sync.base.read(dst);
            this.notePositionAdded(bytesRead);
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            return this.sync.base.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyableSeekableByteChannel truncate(long size) throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            this.sync.base.truncate(size);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            this.reposition();
            int bytesWritten = this.sync.base.write(src);
            this.notePositionAdded(bytesWritten);
            return bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                return false;
            }
            return this.sync.base.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            --this.sync.refCount;
            if (this.sync.refCount == 0L) {
                this.sync.base.close();
            }
        }
    }

    @GuardedBy(value="sync")
    private void reposition() throws IOException {
        if (this.pos != this.sync.position) {
            this.sync.base.position(this.pos);
            this.sync.position = this.pos;
        }
    }

    @GuardedBy(value="sync")
    private void notePositionAdded(int amount) {
        if (amount < 0) {
            return;
        }
        this.pos += (long)amount;
        this.sync.position += (long)amount;
    }

    private static final class Sync {
        public final SeekableByteChannel base;
        @GuardedBy(value="this")
        public long refCount = 0L;
        @GuardedBy(value="this")
        public long position = 0L;

        public Sync(SeekableByteChannel base) throws IOException {
            this.base = (SeekableByteChannel)Preconditions.checkNotNull((Object)base);
            this.position = base.position();
        }
    }
}

