/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObservable;
import com.google.cloud.dataflow.sdk.util.common.worker.ElementCounter;
import com.google.cloud.dataflow.sdk.util.common.worker.OutputObjectAndByteCounter;

public class DataflowOutputCounter
implements ElementCounter {
    private static final String OBJECT_COUNTER_NAME = "-PhysicalElementCount";
    private static final String ELEMENT_COUNTER_NAME = "-ElementCount";
    private static final String MEAN_BYTE_COUNTER_NAME = "-MeanByteCount";
    private OutputObjectAndByteCounter objectAndByteCounter;
    private Counter<Long> elementCount;

    public DataflowOutputCounter(String outputName, CounterSet.AddCounterMutator addCounterMutator) {
        this(outputName, null, addCounterMutator);
    }

    public DataflowOutputCounter(String outputName, ElementByteSizeObservable<?> elementByteSizeObservable, CounterSet.AddCounterMutator addCounterMutator) {
        this.objectAndByteCounter = new OutputObjectAndByteCounter(elementByteSizeObservable, addCounterMutator);
        String string = String.valueOf(outputName);
        String string2 = String.valueOf(OBJECT_COUNTER_NAME);
        this.objectAndByteCounter.countObject(string2.length() != 0 ? string.concat(string2) : new String(string));
        String string3 = String.valueOf(outputName);
        String string4 = String.valueOf(MEAN_BYTE_COUNTER_NAME);
        this.objectAndByteCounter.countMeanByte(string4.length() != 0 ? string3.concat(string4) : new String(string3));
        String string5 = String.valueOf(outputName);
        String string6 = String.valueOf(ELEMENT_COUNTER_NAME);
        this.elementCount = addCounterMutator.addCounter(Counter.longs(string6.length() != 0 ? string5.concat(string6) : new String(string5), Counter.AggregationKind.SUM));
    }

    @Override
    public void update(Object elem) throws Exception {
        this.objectAndByteCounter.update(elem);
        long windowsSize = ((WindowedValue)elem).getWindows().size();
        if (windowsSize == 0L) {
            this.elementCount.addValue(1L);
        } else {
            this.elementCount.addValue(windowsSize);
        }
    }

    @Override
    public void finishLazyUpdate(Object elem) {
        this.objectAndByteCounter.finishLazyUpdate(elem);
    }

    @VisibleForTesting
    static String getElementCounterName(String prefix) {
        String string = String.valueOf(prefix);
        String string2 = String.valueOf(ELEMENT_COUNTER_NAME);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @VisibleForTesting
    static String getObjectCounterName(String prefix) {
        String string = String.valueOf(prefix);
        String string2 = String.valueOf(OBJECT_COUNTER_NAME);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @VisibleForTesting
    static String getMeanByteCounterName(String prefix) {
        String string = String.valueOf(prefix);
        String string2 = String.valueOf(MEAN_BYTE_COUNTER_NAME);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }
}

