/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.SideInputInfo;
import com.google.api.services.dataflow.model.Source;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.ReaderFactory;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Observer;

public class SideInputUtils {
    static final String SINGLETON_KIND = "singleton";
    static final String COLLECTION_KIND = "collection";

    public static Object readSideInput(PipelineOptions options, SideInputInfo sideInputInfo, Observer observer, ExecutionContext executionContext) throws Exception {
        Iterable<Object> elements = SideInputUtils.readSideInputSources(options, sideInputInfo.getSources(), observer, executionContext);
        return SideInputUtils.readSideInputValue(sideInputInfo.getKind(), elements);
    }

    public static Object readSideInput(PipelineOptions options, SideInputInfo sideInputInfo, ExecutionContext executionContext) throws Exception {
        Iterable<Object> elements = SideInputUtils.readSideInputSources(options, sideInputInfo.getSources(), null, executionContext);
        return SideInputUtils.readSideInputValue(sideInputInfo.getKind(), elements);
    }

    private static Iterable<Object> readSideInputSources(PipelineOptions options, List<Source> sideInputSources, Observer observer, ExecutionContext executionContext) throws Exception {
        int numSideInputSources = sideInputSources.size();
        if (numSideInputSources == 0) {
            throw new Exception("expecting at least one side input Source");
        }
        if (numSideInputSources == 1) {
            return SideInputUtils.readSideInputSource(options, sideInputSources.get(0), observer, executionContext);
        }
        ArrayList shards = new ArrayList();
        for (Source sideInputSource : sideInputSources) {
            shards.add(SideInputUtils.readSideInputSource(options, sideInputSource, observer, executionContext));
        }
        return new ShardedIterable<Object>(shards);
    }

    private static Iterable<Object> readSideInputSource(PipelineOptions options, Source sideInputSource, Observer observer, ExecutionContext executionContext) throws Exception {
        Reader<?> reader = ReaderFactory.Registry.defaultRegistry().create(sideInputSource, options, executionContext, null, null);
        if (observer != null) {
            reader.addObserver(observer);
        }
        return new ReaderIterable<Object>(reader);
    }

    static Object readSideInputValue(Map<String, Object> sideInputKind, Iterable<Object> elements) throws Exception {
        String className = Structs.getString(sideInputKind, "@type");
        if (SINGLETON_KIND.equals(className)) {
            Iterator<Object> iter = elements.iterator();
            if (iter.hasNext()) {
                Object elem = iter.next();
                if (!iter.hasNext()) {
                    return elem;
                }
            }
            throw new Exception("expecting a singleton side input to have a single value");
        }
        if (COLLECTION_KIND.equals(className)) {
            return elements;
        }
        String string = String.valueOf(className);
        throw new Exception(string.length() != 0 ? "unexpected kind of side input: ".concat(string) : new String("unexpected kind of side input: "));
    }

    public static SideInputInfo createSingletonSideInputInfo(Source sideInputSource) {
        SideInputInfo sideInputInfo = new SideInputInfo();
        sideInputInfo.setSources(Arrays.asList(sideInputSource));
        sideInputInfo.setKind((Map)((Object)CloudObject.forClassName(SINGLETON_KIND)));
        return sideInputInfo;
    }

    public static SideInputInfo createCollectionSideInputInfo(Source ... sideInputSources) {
        SideInputInfo sideInputInfo = new SideInputInfo();
        sideInputInfo.setSources(Arrays.asList(sideInputSources));
        sideInputInfo.setKind((Map)((Object)CloudObject.forClassName(COLLECTION_KIND)));
        return sideInputInfo;
    }

    static class ShardedIterator<T>
    implements Iterator<T> {
        final Iterator<Iterable<T>> shards;
        Iterator<T> shard;

        public ShardedIterator(Iterator<Iterable<T>> shards) {
            this.shards = shards;
            this.shard = null;
        }

        @Override
        public boolean hasNext() {
            boolean shardHasNext;
            while (true) {
                boolean bl = shardHasNext = this.shard != null && this.shard.hasNext();
                if (shardHasNext || !this.shards.hasNext()) break;
                this.shard = this.shards.next().iterator();
            }
            return shardHasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.shard.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ShardedIterable<T>
    implements Iterable<T> {
        final List<Iterable<T>> shards;

        public ShardedIterable(List<Iterable<T>> shards) {
            this.shards = shards;
        }

        @Override
        public Iterator<T> iterator() {
            return new ShardedIterator<T>(this.shards.iterator());
        }
    }

    static class ReaderIterator<T>
    implements Iterator<T> {
        final Reader.ReaderIterator<T> iterator;

        public ReaderIterator(Reader.ReaderIterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (Exception exn) {
                throw new RuntimeException(exn);
            }
        }

        @Override
        public T next() {
            try {
                return this.iterator.next();
            }
            catch (Exception exn) {
                throw new RuntimeException(exn);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ReaderIterable<T>
    implements Iterable<T> {
        final Reader<T> reader;

        public ReaderIterable(Reader<T> reader) {
            this.reader = reader;
        }

        @Override
        public Iterator<T> iterator() {
            try {
                return new ReaderIterator<T>(this.reader.iterator());
            }
            catch (Exception exn) {
                throw new RuntimeException(exn);
            }
        }
    }
}

