/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.Source;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.worker.SourceFormat;
import java.util.Map;

public class SourceFormatFactory {
    private SourceFormatFactory() {
    }

    public static SourceFormat create(PipelineOptions options, Source source) throws Exception {
        Map spec = source.getSpec();
        try {
            return InstanceBuilder.ofType(SourceFormat.class).fromClassName(Structs.getString(spec, "@type")).withArg(PipelineOptions.class, options).build();
        }
        catch (ClassNotFoundException exn) {
            String string = String.valueOf(source);
            throw new Exception(new StringBuilder(38 + String.valueOf(string).length()).append("unable to create a source format from ").append(string).toString(), exn);
        }
    }
}

