/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.Source;
import com.google.api.services.dataflow.model.SourceOperationRequest;
import com.google.api.services.dataflow.model.SourceOperationResponse;
import com.google.api.services.dataflow.model.SourceSplitResponse;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.SourceFormatFactory;
import com.google.cloud.dataflow.sdk.runners.worker.SourceTranslationUtils;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.MapTaskExecutor;
import com.google.cloud.dataflow.sdk.util.common.worker.SourceFormat;
import com.google.cloud.dataflow.sdk.util.common.worker.WorkExecutor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceOperationExecutor
extends WorkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MapTaskExecutor.class);
    public static final String SPLIT_RESPONSE_TOO_LARGE_ERROR = "Total size of the BoundedSource objects generated by splitIntoBundles() operation is larger than the allowable limit. For more information, please check the corresponding FAQ entry at :\nhttps://cloud.google.com/dataflow/faq";
    private static final int SOURCE_OPERATION_RESPONSE_SIZE_LIMIT_MB = 20;
    private final PipelineOptions options;
    private final SourceOperationRequest request;
    private SourceOperationResponse response;

    public SourceOperationExecutor(PipelineOptions options, SourceOperationRequest request, CounterSet counters) {
        super(counters);
        this.options = options;
        this.request = request;
    }

    @Override
    public void execute() throws Exception {
        Source sourceSpec;
        LOG.debug("Executing source operation");
        if (this.request.getGetMetadata() != null) {
            sourceSpec = this.request.getGetMetadata().getSource();
        } else if (this.request.getSplit() != null) {
            sourceSpec = this.request.getSplit().getSource();
        } else {
            throw new UnsupportedOperationException("Unknown source operation");
        }
        this.response = SourceTranslationUtils.sourceOperationResponseToCloudSourceOperationResponse(SourceFormatFactory.create(this.options, sourceSpec).performSourceOperation(SourceTranslationUtils.cloudSourceOperationRequestToSourceOperationRequest(this.request)));
        LOG.debug("Source operation execution complete");
    }

    public SourceOperationResponse getResponse() {
        return this.response;
    }

    static boolean isSplitResponseTooLarge(SourceFormat.OperationResponse operationResponse) {
        return SourceOperationExecutor.isSplitOperationResponse(operationResponse) && SourceOperationExecutor.isSplitOperationTooLargeForDataflowService(operationResponse);
    }

    private static boolean isSplitOperationTooLargeForDataflowService(SourceFormat.OperationResponse operationResponse) {
        try {
            SourceSplitResponse splitResponse = ((SourceTranslationUtils.DataflowSourceOperationResponse)operationResponse).cloudResponse.getSplit();
            int size = splitResponse.getFactory().toByteArray((Object)operationResponse).length;
            return size >= 0x1400000;
        }
        catch (OutOfMemoryError e) {
            String string = String.valueOf(e.getMessage());
            LOG.error(string.length() != 0 ? "Got exception when trying to serialize split response: ".concat(string) : new String("Got exception when trying to serialize split response: "));
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSplitOperationResponse(SourceFormat.OperationResponse operationResponse) {
        if (operationResponse instanceof SourceTranslationUtils.DataflowSourceOperationResponse) {
            return ((SourceTranslationUtils.DataflowSourceOperationResponse)operationResponse).cloudResponse.getSplit() != null;
        }
        return false;
    }
}

