/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.ApproximateProgress;
import com.google.api.services.dataflow.model.Position;
import com.google.api.services.dataflow.model.Source;
import com.google.api.services.dataflow.model.SourceMetadata;
import com.google.api.services.dataflow.model.SourceOperationRequest;
import com.google.api.services.dataflow.model.SourceOperationResponse;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import com.google.cloud.dataflow.sdk.util.common.worker.SourceFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class SourceTranslationUtils {
    public static Reader.Progress cloudProgressToReaderProgress(@Nullable ApproximateProgress cloudProgress) {
        return cloudProgress == null ? null : new DataflowReaderProgress(cloudProgress);
    }

    public static Reader.Position cloudPositionToReaderPosition(@Nullable Position cloudPosition) {
        return cloudPosition == null ? null : new DataflowReaderPosition(cloudPosition);
    }

    public static SourceFormat.OperationRequest cloudSourceOperationRequestToSourceOperationRequest(@Nullable SourceOperationRequest request) {
        return request == null ? null : new DataflowSourceOperationRequest(request);
    }

    public static SourceFormat.OperationResponse cloudSourceOperationResponseToSourceOperationResponse(@Nullable SourceOperationResponse response) {
        return response == null ? null : new DataflowSourceOperationResponse(response);
    }

    public static ApproximateProgress readerProgressToCloudProgress(@Nullable Reader.Progress readerProgress) {
        return readerProgress == null ? null : ((DataflowReaderProgress)readerProgress).cloudProgress;
    }

    public static Position toCloudPosition(@Nullable Reader.Position readerPosition) {
        return readerPosition == null ? null : ((DataflowReaderPosition)readerPosition).cloudPosition;
    }

    public static SourceOperationRequest sourceOperationRequestToCloudSourceOperationRequest(@Nullable SourceFormat.OperationRequest request) {
        return request == null ? null : ((DataflowSourceOperationRequest)request).cloudRequest;
    }

    public static SourceOperationResponse sourceOperationResponseToCloudSourceOperationResponse(@Nullable SourceFormat.OperationResponse response) {
        return response == null ? null : ((DataflowSourceOperationResponse)response).cloudResponse;
    }

    public static Source sourceSpecToCloudSource(@Nullable SourceFormat.SourceSpec spec) {
        return spec == null ? null : ((DataflowSourceSpec)spec).cloudSource;
    }

    public static ApproximateProgress splitRequestToApproximateProgress(@Nullable Reader.DynamicSplitRequest splitRequest) {
        return splitRequest == null ? null : ((DataflowDynamicSplitRequest)splitRequest).approximateProgress;
    }

    public static Reader.DynamicSplitRequest toDynamicSplitRequest(@Nullable ApproximateProgress approximateProgress) {
        return approximateProgress == null ? null : new DataflowDynamicSplitRequest(approximateProgress);
    }

    public static Map<String, Object> cloudSourceToDictionary(Source source) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Structs.addDictionary(res, "spec", source.getSpec());
        if (source.getMetadata() != null) {
            Structs.addDictionary(res, "metadata", SourceTranslationUtils.cloudSourceMetadataToDictionary(source.getMetadata()));
        }
        if (source.getDoesNotNeedSplitting() != null) {
            Structs.addBoolean(res, "does_not_need_splitting", source.getDoesNotNeedSplitting());
        }
        return res;
    }

    private static Map<String, Object> cloudSourceMetadataToDictionary(SourceMetadata metadata) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (metadata.getProducesSortedKeys() != null) {
            Structs.addBoolean(res, "produces_sorted_keys", metadata.getProducesSortedKeys());
        }
        if (metadata.getEstimatedSizeBytes() != null) {
            Structs.addLong(res, "estimated_size_bytes", metadata.getEstimatedSizeBytes());
        }
        if (metadata.getInfinite() != null) {
            Structs.addBoolean(res, "is_infinite", metadata.getInfinite());
        }
        return res;
    }

    public static Source dictionaryToCloudSource(Map<String, Object> params) throws Exception {
        Source res = new Source();
        res.setSpec(Structs.getDictionary(params, "spec"));
        return res;
    }

    private static class DataflowDynamicSplitRequest
    implements Reader.DynamicSplitRequest {
        public final ApproximateProgress approximateProgress;

        private DataflowDynamicSplitRequest(ApproximateProgress approximateProgress) {
            this.approximateProgress = approximateProgress;
        }

        public String toString() {
            return String.valueOf(this.approximateProgress);
        }
    }

    static class DataflowSourceSpec
    implements SourceFormat.SourceSpec {
        public final Source cloudSource;

        public DataflowSourceSpec(Source cloudSource) {
            this.cloudSource = cloudSource;
        }

        public String toString() {
            return String.valueOf(this.cloudSource);
        }
    }

    static class DataflowSourceOperationResponse
    implements SourceFormat.OperationResponse {
        public final SourceOperationResponse cloudResponse;

        public DataflowSourceOperationResponse(SourceOperationResponse cloudResponse) {
            this.cloudResponse = cloudResponse;
        }

        public String toString() {
            return String.valueOf(this.cloudResponse);
        }
    }

    static class DataflowSourceOperationRequest
    implements SourceFormat.OperationRequest {
        public final SourceOperationRequest cloudRequest;

        public DataflowSourceOperationRequest(SourceOperationRequest cloudRequest) {
            this.cloudRequest = cloudRequest;
        }

        public String toString() {
            return String.valueOf(this.cloudRequest);
        }
    }

    static class DataflowReaderPosition
    implements Reader.Position {
        public final Position cloudPosition;

        public DataflowReaderPosition(Position cloudPosition) {
            this.cloudPosition = cloudPosition;
        }

        public String toString() {
            return String.valueOf(this.cloudPosition);
        }
    }

    static class DataflowReaderProgress
    implements Reader.Progress {
        public final ApproximateProgress cloudProgress;

        public DataflowReaderProgress(ApproximateProgress cloudProgress) {
            this.cloudProgress = cloudProgress;
        }

        public String toString() {
            return String.valueOf(this.cloudProgress);
        }
    }
}

