/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker.logging;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.runners.worker.logging.DataflowWorkerLoggingInitializer;
import com.google.cloud.dataflow.sdk.runners.worker.logging.DataflowWorkerLoggingMDC;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class DataflowWorkerLoggingHandler
extends Handler {
    private JsonGenerator generator;

    public static String formatException(Throwable thrown) {
        if (thrown == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public DataflowWorkerLoggingHandler(String fileName) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(new File(fileName), true)));
    }

    public DataflowWorkerLoggingHandler(OutputStream output) throws IOException {
        this.generator = new ObjectMapper().getFactory().createGenerator(output, JsonEncoding.UTF8);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        block3: {
            if (!this.isLoggable(record)) {
                return;
            }
            try {
                this.generator.writeStartObject();
                this.generator.writeFieldName("timestamp");
                this.generator.writeStartObject();
                this.generator.writeNumberField("seconds", record.getMillis() / 1000L);
                this.generator.writeNumberField("nanos", record.getMillis() % 1000L * 1000000L);
                this.generator.writeEndObject();
                this.generator.writeObjectField("severity", (Object)MoreObjects.firstNonNull(DataflowWorkerLoggingInitializer.LEVELS.get(record.getLevel()), record.getLevel().getName()));
                this.writeIfNotNull("message", record.getMessage());
                this.writeIfNotNull("thread", String.valueOf(record.getThreadID()));
                this.writeIfNotNull("job", DataflowWorkerLoggingMDC.getJobId());
                this.writeIfNotNull("stage", DataflowWorkerLoggingMDC.getStageName());
                this.writeIfNotNull("step", DataflowWorkerLoggingMDC.getStepName());
                this.writeIfNotNull("worker", DataflowWorkerLoggingMDC.getWorkerId());
                this.writeIfNotNull("work", DataflowWorkerLoggingMDC.getWorkId());
                this.writeIfNotNull("logger", record.getLoggerName());
                this.writeIfNotNull("exception", DataflowWorkerLoggingHandler.formatException(record.getThrown()));
                this.generator.writeEndObject();
                this.generator.writeRaw(System.lineSeparator());
            }
            catch (IOException e) {
                if (this.getErrorManager() == null) break block3;
                this.getErrorManager().error("Unable to publish", e, 1);
            }
        }
        this.flush();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.generator != null && record != null && super.isLoggable(record);
    }

    private void writeIfNotNull(String name, String val) throws IOException {
        if (val != null) {
            this.generator.writeStringField(name, val);
        }
    }

    @Override
    public synchronized void flush() {
        block3: {
            try {
                if (this.generator != null) {
                    this.generator.flush();
                }
            }
            catch (IOException e) {
                if (this.getErrorManager() == null) break block3;
                this.getErrorManager().error("Unable to flush", e, 2);
            }
        }
    }

    @Override
    public synchronized void close() {
        block3: {
            this.flush();
            try {
                if (this.generator != null) {
                    this.generator.close();
                }
            }
            catch (IOException e) {
                if (this.getErrorManager() == null) break block3;
                this.getErrorManager().error("Unable to close", e, 3);
            }
        }
        this.generator = null;
    }
}

