/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker.logging;

import com.google.cloud.dataflow.sdk.options.DataflowWorkerLoggingOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableBiMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.runners.worker.logging.DataflowWorkerLoggingHandler;
import com.google.cloud.dataflow.sdk.runners.worker.logging.JulLoggerPrintStreamAdapterFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class DataflowWorkerLoggingInitializer {
    private static final String ROOT_LOGGER_NAME = "";
    private static final String DEFAULT_LOGGING_LOCATION = new File(System.getProperty("java.io.tmpdir"), "dataflow.json.log").getPath();
    private static final String DATAFLOW_WORKER_LOGGING_LOCATION = "dataflow.worker.logging.location";
    private static final String DATAFLOW_WORKER_JSON_LOGGING_LOCATION = "dataflow.worker.json.logging.location";
    static final ImmutableBiMap<Level, DataflowWorkerLoggingOptions.Level> LEVELS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(Level.SEVERE, (Object)DataflowWorkerLoggingOptions.Level.ERROR)).put(Level.WARNING, (Object)DataflowWorkerLoggingOptions.Level.WARN)).put(Level.INFO, (Object)DataflowWorkerLoggingOptions.Level.INFO)).put(Level.FINE, (Object)DataflowWorkerLoggingOptions.Level.DEBUG)).put(Level.FINEST, (Object)DataflowWorkerLoggingOptions.Level.TRACE)).build();
    private static final DataflowWorkerLoggingOptions.Level DEFAULT_LOG_LEVEL = (DataflowWorkerLoggingOptions.Level)((Object)LEVELS.get(Level.INFO));
    private static List<Logger> configuredLoggers = Lists.newArrayList();
    private static FileHandler fileHandler;
    private static PrintStream originalStdOut;
    private static PrintStream originalStdErr;

    public static synchronized void initialize() {
        if (fileHandler != null) {
            return;
        }
        try {
            DataflowWorkerLoggingHandler loggingHandler = new DataflowWorkerLoggingHandler(System.getProperty(DATAFLOW_WORKER_JSON_LOGGING_LOCATION, System.getProperty(DATAFLOW_WORKER_LOGGING_LOCATION, DEFAULT_LOGGING_LOCATION)));
            loggingHandler.setLevel(Level.ALL);
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            Logger rootLogger = logManager.getLogger(ROOT_LOGGER_NAME);
            for (Handler handler : rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
            }
            Level logLevel = (Level)((ImmutableMap)((Object)LEVELS.inverse())).get((Object)DEFAULT_LOG_LEVEL);
            rootLogger.setLevel(logLevel);
            rootLogger.addHandler(loggingHandler);
            originalStdOut = System.out;
            originalStdErr = System.err;
            System.setOut(JulLoggerPrintStreamAdapterFactory.create("System.out", Level.INFO));
            System.setErr(JulLoggerPrintStreamAdapterFactory.create("System.err", Level.SEVERE));
        }
        catch (IOException | SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static synchronized void configure(DataflowWorkerLoggingOptions options) {
        DataflowWorkerLoggingInitializer.initialize();
        if (options.getDefaultWorkerLogLevel() != null) {
            LogManager.getLogManager().getLogger(ROOT_LOGGER_NAME).setLevel((Level)((ImmutableMap)((Object)LEVELS.inverse())).get((Object)options.getDefaultWorkerLogLevel()));
        }
        if (options.getWorkerLogLevelOverrides() != null) {
            for (Map.Entry loggerOverride : options.getWorkerLogLevelOverrides().entrySet()) {
                Logger logger = Logger.getLogger((String)loggerOverride.getKey());
                logger.setLevel((Level)((ImmutableMap)((Object)LEVELS.inverse())).get(loggerOverride.getValue()));
                configuredLoggers.add(logger);
            }
        }
    }

    static void reset() {
        configuredLoggers = Lists.newArrayList();
        fileHandler = null;
        System.setOut(originalStdOut);
        System.setErr(originalStdErr);
    }
}

