/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker.logging;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class JulLoggerPrintStreamAdapterFactory {
    private static final AtomicBoolean outputWarning = new AtomicBoolean(false);

    JulLoggerPrintStreamAdapterFactory() {
    }

    static PrintStream create(String name, Level level) {
        try {
            return new PrintStream((OutputStream)new JulLoggerAdapterOutputStream(name, level), false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate(e);
        }
    }

    private static class JulLoggerAdapterOutputStream
    extends OutputStream {
        private static final String LOGGING_DISCLAIMER = String.format("Please use a logger instead of System.out or System.err.%nPlease switch to using org.slf4j.Logger.%nSee: https://cloud.google.com/dataflow/pipelines/logging", new Object[0]);
        private static final int BUFFER_LIMIT = 16384;
        private static final byte[] NEW_LINE = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
        private Logger logger;
        private ByteArrayOutputStream baos;
        private Level logLevel;
        private int matched = 0;

        private JulLoggerAdapterOutputStream(String name, Level logLevel) {
            this.logger = Logger.getLogger(name);
            this.logLevel = logLevel;
            this.baos = new ByteArrayOutputStream(16384);
        }

        @Override
        public void write(int b) {
            if (outputWarning.compareAndSet(false, true)) {
                this.logger.warning(LOGGING_DISCLAIMER);
            }
            this.baos.write(b);
            if (NEW_LINE[this.matched] == b) {
                ++this.matched;
                if (this.matched == NEW_LINE.length) {
                    this.output();
                }
            } else {
                this.matched = 0;
            }
            if (this.baos.size() == 16384) {
                this.output();
            }
        }

        @Override
        public void flush() throws IOException {
            this.output();
        }

        @Override
        public void close() throws IOException {
            this.output();
        }

        private void output() {
            if (this.baos.size() == 0) {
                return;
            }
            try {
                String message = this.baos.toString(StandardCharsets.UTF_8.name());
                if (message.endsWith(System.lineSeparator())) {
                    message = message.substring(0, message.length() - System.lineSeparator().length());
                }
                this.logger.log(this.logLevel, message);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.severe(String.format("Unable to decode string output to stdout/stderr %s", e));
            }
            this.matched = 0;
            this.baos.reset();
        }
    }
}

