/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.Serializer;
import com.google.cloud.dataflow.sdk.util.Structs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CoderProperties {
    public static final List<Coder.Context> ALL_CONTEXTS = Arrays.asList(Coder.Context.OUTER, Coder.Context.NESTED);
    private static final String DECODING_WIRE_FORMAT_MESSAGE = "Decoded value from known wire format does not match expected value. This probably means that this Coder no longer correctly decodes a prior wire format. Changing the wire formats this Coder can read should be avoided, as it is likely to cause breakage. If you truly intend to change the backwards compatibility for this Coder  then you must remove any now-unsupported encodings from getAllowedEncodings().";
    private static final String ENCODING_WIRE_FORMAT_MESSAGE = "Encoded value does not match expected wire format. Changing the wire format should be avoided, as it is likely to cause breakage. If you truly intend to change the wire format for this Coder  then you must update getEncodingId() to a new value and add any supported prior formats to getAllowedEncodings(). See com.google.cloud.dataflow.sdk.coders.PrintBase64Encoding for how to generate new test data.";

    public static <T> void coderDeterministic(Coder<T> coder, T value1, T value2) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDeterministicInContext(coder, context, value1, value2);
        }
    }

    public static <T> void coderDeterministicInContext(Coder<T> coder, Coder.Context context, T value1, T value2) throws Exception {
        try {
            coder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            Assert.fail((String)"Expected that the coder is deterministic");
        }
        Assert.assertThat((String)"Expected that the passed in values are equal()", value1, (Matcher)Matchers.equalTo(value2));
        Assert.assertThat((Object)CoderProperties.encode(coder, context, value1), (Matcher)Matchers.equalTo((Object)CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void coderDecodeEncodeEqual(Coder<T> coder, T value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeEqualInContext(coder, context, value);
        }
    }

    public static <T> void coderDecodeEncodeEqualInContext(Coder<T> coder, Coder.Context context, T value) throws Exception {
        Assert.assertThat(CoderProperties.decodeEncode(coder, context, value), (Matcher)Matchers.equalTo(value));
    }

    public static <T, CollectionT extends Collection<T>> void coderDecodeEncodeContentsEqual(Coder<CollectionT> coder, CollectionT value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeContentsEqualInContext(coder, context, value);
        }
    }

    public static <T, CollectionT extends Collection<T>> void coderDecodeEncodeContentsEqualInContext(Coder<CollectionT> coder, Coder.Context context, CollectionT value) throws Exception {
        Collection result = (Collection)CoderProperties.decodeEncode(coder, context, value);
        if (value.isEmpty()) {
            Assert.assertThat((Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            Assert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])value.toArray()));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodeEncodeContentsInSameOrder(Coder<IterableT> coder, IterableT value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeContentsInSameOrderInContext(coder, context, value);
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodeEncodeContentsInSameOrderInContext(Coder<IterableT> coder, Coder.Context context, IterableT value) throws Exception {
        Iterable result = (Iterable)CoderProperties.decodeEncode(coder, context, value);
        if (Iterables.isEmpty(value)) {
            Assert.assertThat((Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            Assert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])Iterables.toArray(value, Object.class)));
        }
    }

    public static <T> void coderSerializable(Coder<T> coder) {
        SerializableUtils.ensureSerializable(coder);
    }

    public static <T> void coderConsistentWithEquals(Coder<T> coder, T value1, T value2) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderConsistentWithEqualsInContext(coder, context, value1, value2);
        }
    }

    public static <T> void coderConsistentWithEqualsInContext(Coder<T> coder, Coder.Context context, T value1, T value2) throws Exception {
        Assert.assertEquals((Object)value1.equals(value2), (Object)Arrays.equals(CoderProperties.encode(coder, context, value1), CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void coderHasEncodingId(Coder<T> coder, String encodingId) throws Exception {
        Assert.assertThat((Object)coder.getEncodingId(), (Matcher)Matchers.equalTo((Object)encodingId));
        Assert.assertThat((Object)Structs.getString((Map<String, Object>)((Object)coder.asCloudObject()), "encoding_id", ""), (Matcher)Matchers.equalTo((Object)encodingId));
    }

    public static <T> void coderAllowsEncoding(Coder<T> coder, String encodingId) throws Exception {
        Assert.assertThat(coder.getAllowedEncodings(), (Matcher)Matchers.hasItem((Object)encodingId));
        Assert.assertThat((String)String.format("Expected to find \"%s\" in property \"%s\" of %s", new Object[]{encodingId, "allowed_encodings", coder.asCloudObject()}), Structs.getStrings((Map<String, Object>)((Object)coder.asCloudObject()), "allowed_encodings", Collections.emptyList()), (Matcher)Matchers.hasItem((Object)encodingId));
    }

    public static <T> void structuralValueConsistentWithEquals(Coder<T> coder, T value1, T value2) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.structuralValueConsistentWithEqualsInContext(coder, context, value1, value2);
        }
    }

    public static <T> void structuralValueConsistentWithEqualsInContext(Coder<T> coder, Coder.Context context, T value1, T value2) throws Exception {
        Assert.assertEquals((Object)coder.structuralValue(value1).equals(coder.structuralValue(value2)), (Object)Arrays.equals(CoderProperties.encode(coder, context, value1), CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void coderDecodesBase64(Coder<T> coder, String base64Encoding, T value) throws Exception {
        Assert.assertThat((String)DECODING_WIRE_FORMAT_MESSAGE, CoderUtils.decodeFromBase64(coder, base64Encoding), (Matcher)Matchers.equalTo(value));
    }

    public static <T> void coderDecodesBase64(Coder<T> coder, List<String> base64Encodings, List<T> values) throws Exception {
        Assert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)values.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderDecodesBase64(coder, base64Encodings.get(i), values.get(i));
        }
    }

    public static <T> void coderEncodesBase64(Coder<T> coder, T value, String base64Encoding) throws Exception {
        Assert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)CoderUtils.encodeToBase64(coder, value), (Matcher)Matchers.equalTo((Object)base64Encoding));
    }

    public static <T> void coderEncodesBase64(Coder<T> coder, List<T> values, List<String> base64Encodings) throws Exception {
        Assert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)values.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderEncodesBase64(coder, values.get(i), base64Encodings.get(i));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodesBase64ContentsEqual(Coder<IterableT> coder, String base64Encoding, IterableT expected) throws Exception {
        Iterable result = (Iterable)CoderUtils.decodeFromBase64(coder, base64Encoding);
        if (Iterables.isEmpty(expected)) {
            Assert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            Assert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])Iterables.toArray(expected, Object.class)));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodesBase64ContentsEqual(Coder<IterableT> coder, List<String> base64Encodings, List<IterableT> expected) throws Exception {
        Assert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)expected.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderDecodesBase64ContentsEqual(coder, base64Encodings.get(i), (Iterable)expected.get(i));
        }
    }

    private static <T> byte[] encode(Coder<T> coder, Coder.Context context, T value) throws CoderException, IOException {
        Coder deserializedCoder = Serializer.deserialize((Map<String, Object>)((Object)coder.asCloudObject()), Coder.class);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        deserializedCoder.encode(value, os, context);
        return os.toByteArray();
    }

    private static <T> T decode(Coder<T> coder, Coder.Context context, byte[] bytes) throws CoderException, IOException {
        Coder deserializedCoder = Serializer.deserialize((Map<String, Object>)((Object)coder.asCloudObject()), Coder.class);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return deserializedCoder.decode(is, context);
    }

    private static <T> T decodeEncode(Coder<T> coder, Coder.Context context, T value) throws CoderException, IOException {
        return CoderProperties.decode(coder, context, CoderProperties.encode(coder, context, value));
    }
}

