/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.MapCoder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.options.StreamingOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.testing.SerializableMatcher;
import com.google.cloud.dataflow.sdk.testing.SerializableMatchers;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.Sum;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PBegin;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PDone;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowAssert {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowAssert.class);
    static final String SUCCESS_COUNTER = "DataflowAssertSuccess";
    static final String FAILURE_COUNTER = "DataflowAssertFailure";
    private static int assertCount = 0;

    private DataflowAssert() {
    }

    public static <T> IterableAssert<T> that(PCollection<T> actual) {
        return new IterableAssert<T>(new CreateActual(actual, View.asIterable()), actual.getPipeline()).setCoder(actual.getCoder());
    }

    public static <T> IterableAssert<T> thatSingletonIterable(PCollection<? extends Iterable<T>> actual) {
        Coder<?> tCoder;
        List<Coder<?>> maybeElementCoder = actual.getCoder().getCoderArguments();
        try {
            Coder<?> tCoderTmp;
            tCoder = tCoderTmp = Iterables.getOnlyElement(maybeElementCoder);
        }
        catch (IllegalArgumentException | NoSuchElementException exc) {
            throw new IllegalArgumentException("DataflowAssert.<T>thatSingletonIterable requires a PCollection<Iterable<T>> with a Coder<Iterable<T>> where getCoderArguments() yields a single Coder<T> to apply to the elements.");
        }
        PCollection<Iterable<T>> actualIterables = actual;
        return new IterableAssert(new CreateActual(actualIterables, View.asSingleton()), actual.getPipeline()).setCoder(tCoder);
    }

    public static <T> IterableAssert<T> thatIterable(PCollectionView<Iterable<T>> actual) {
        return new IterableAssert(new PreExisting(actual), actual.getPipeline());
    }

    public static <T> SingletonAssert<T> thatSingleton(PCollection<T> actual) {
        return new SingletonAssert(new CreateActual(actual, View.asSingleton()), actual.getPipeline()).setCoder(actual.getCoder());
    }

    public static <K, V> SingletonAssert<Map<K, Iterable<V>>> thatMultimap(PCollection<KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new SingletonAssert(new CreateActual(actual, View.asMultimap()), actual.getPipeline()).setCoder(MapCoder.of(kvCoder.getKeyCoder(), IterableCoder.of(kvCoder.getValueCoder())));
    }

    public static <K, V> SingletonAssert<Map<K, V>> thatMap(PCollection<KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new SingletonAssert(new CreateActual(actual, View.asMap()), actual.getPipeline()).setCoder(MapCoder.of(kvCoder.getKeyCoder(), kvCoder.getValueCoder()));
    }

    private static class AssertContainsInAnyOrderRelation<T>
    implements AssertRelation<Iterable<T>, Iterable<T>> {
        private AssertContainsInAnyOrderRelation() {
        }

        @Override
        public SerializableFunction<Iterable<T>, Void> assertFor(Iterable<T> expectedElements) {
            return new AssertContainsInAnyOrder<T>(expectedElements);
        }
    }

    private static class AssertIsEqualToRelation<T>
    implements AssertRelation<T, T> {
        private AssertIsEqualToRelation() {
        }

        @Override
        public SerializableFunction<T, Void> assertFor(T expected) {
            return new AssertIsEqualTo<T>(expected);
        }
    }

    private static interface AssertRelation<ActualT, ExpectedT>
    extends Serializable {
        public SerializableFunction<ActualT, Void> assertFor(ExpectedT var1);
    }

    private static class AssertContainsInAnyOrder<T>
    implements SerializableFunction<Iterable<T>, Void> {
        private T[] expected;

        @SafeVarargs
        public AssertContainsInAnyOrder(T ... expected) {
            this.expected = expected;
        }

        public AssertContainsInAnyOrder(Collection<T> expected) {
            this(expected.toArray());
        }

        public AssertContainsInAnyOrder(Iterable<T> expected) {
            this((Collection<T>)Lists.newArrayList(expected));
        }

        @Override
        public Void apply(Iterable<T> actual) {
            Assert.assertThat(actual, (Matcher)Matchers.containsInAnyOrder((Object[])this.expected));
            return null;
        }
    }

    private static class AssertIsEqualTo<T>
    implements SerializableFunction<T, Void> {
        private T expected;

        public AssertIsEqualTo(T expected) {
            this.expected = expected;
        }

        @Override
        public Void apply(T actual) {
            Assert.assertThat(actual, (Matcher)Matchers.equalTo(this.expected));
            return null;
        }
    }

    static class TwoSideInputAssert<ActualT, ExpectedT>
    extends PTransform<PBegin, PDone>
    implements Serializable {
        private final transient PTransform<PBegin, PCollectionView<ActualT>> createActual;
        private final transient PTransform<PBegin, PCollectionView<ExpectedT>> createExpected;
        private final AssertRelation<ActualT, ExpectedT> relation;

        protected TwoSideInputAssert(PTransform<PBegin, PCollectionView<ActualT>> createActual, PTransform<PBegin, PCollectionView<ExpectedT>> createExpected, AssertRelation<ActualT, ExpectedT> relation) {
            this.createActual = createActual;
            this.createExpected = createExpected;
            this.relation = relation;
        }

        @Override
        public PDone apply(PBegin input) {
            PCollectionView<ActualT> actual = input.apply("CreateActual", this.createActual);
            PCollectionView<ExpectedT> expected = input.apply("CreateExpected", this.createExpected);
            ((PCollection)input.apply(Create.of(new Void[]{null}).withCoder(VoidCoder.of()))).apply(ParDo.named("RunChecks").withSideInputs(actual, expected).of(new CheckerDoFn(this.relation, actual, expected)));
            return PDone.in(input.getPipeline());
        }

        private static class CheckerDoFn<ActualT, ExpectedT>
        extends DoFn<Void, Void> {
            private final Aggregator<Integer, Integer> success = this.createAggregator("DataflowAssertSuccess", new Sum.SumIntegerFn());
            private final Aggregator<Integer, Integer> failure = this.createAggregator("DataflowAssertFailure", new Sum.SumIntegerFn());
            private final AssertRelation<ActualT, ExpectedT> relation;
            private final PCollectionView<ActualT> actual;
            private final PCollectionView<ExpectedT> expected;

            private CheckerDoFn(AssertRelation<ActualT, ExpectedT> relation, PCollectionView<ActualT> actual, PCollectionView<ExpectedT> expected) {
                this.relation = relation;
                this.actual = actual;
                this.expected = expected;
            }

            @Override
            public void processElement(DoFn.ProcessContext c) {
                block2: {
                    try {
                        ActualT actualContents = c.sideInput(this.actual);
                        ExpectedT expectedContents = c.sideInput(this.expected);
                        this.relation.assertFor(expectedContents).apply(actualContents);
                        this.success.addValue(1);
                    }
                    catch (Throwable t) {
                        LOG.error("DataflowAssert failed expectations.", t);
                        this.failure.addValue(1);
                        if (c.getPipelineOptions().as(StreamingOptions.class).isStreaming()) break block2;
                        throw t;
                    }
                }
            }
        }
    }

    private static class CheckerDoFn<ActualT>
    extends DoFn<Void, Void> {
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final Aggregator<Integer, Integer> success = this.createAggregator("DataflowAssertSuccess", new Sum.SumIntegerFn());
        private final Aggregator<Integer, Integer> failure = this.createAggregator("DataflowAssertFailure", new Sum.SumIntegerFn());
        private final PCollectionView<ActualT> actual;

        private CheckerDoFn(SerializableFunction<ActualT, Void> checkerFn, PCollectionView<ActualT> actual) {
            this.checkerFn = checkerFn;
            this.actual = actual;
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
            block2: {
                try {
                    ActualT actualContents = c.sideInput(this.actual);
                    this.checkerFn.apply(actualContents);
                    this.success.addValue(1);
                }
                catch (Throwable t) {
                    LOG.error("DataflowAssert failed expectations.", t);
                    this.failure.addValue(1);
                    if (c.getPipelineOptions().as(StreamingOptions.class).isStreaming()) break block2;
                    throw t;
                }
            }
        }
    }

    static class OneSideInputAssert<ActualT>
    extends PTransform<PBegin, PDone>
    implements Serializable {
        private final transient PTransform<PBegin, PCollectionView<ActualT>> createActual;
        private final SerializableFunction<ActualT, Void> checkerFn;

        public OneSideInputAssert(PTransform<PBegin, PCollectionView<ActualT>> createActual, SerializableFunction<ActualT, Void> checkerFn) {
            this.createActual = createActual;
            this.checkerFn = checkerFn;
        }

        @Override
        public PDone apply(PBegin input) {
            PCollectionView<ActualT> actual = input.apply("CreateActual", this.createActual);
            ((PCollection)input.apply(Create.of(new Void[]{null}).withCoder(VoidCoder.of()))).apply(ParDo.named("RunChecks").withSideInputs(actual).of(new CheckerDoFn(this.checkerFn, actual)));
            return PDone.in(input.getPipeline());
        }
    }

    private static class PreExisting<T>
    extends PTransform<PBegin, PCollectionView<T>> {
        private final PCollectionView<T> view;

        private PreExisting(PCollectionView<T> view) {
            this.view = view;
        }

        @Override
        public PCollectionView<T> apply(PBegin input) {
            return this.view;
        }
    }

    private static class CreateExpected<T, ExpectedT>
    extends PTransform<PBegin, PCollectionView<ExpectedT>> {
        private final Iterable<T> elements;
        private final Optional<Coder<T>> coder;
        private final transient PTransform<PCollection<T>, PCollectionView<ExpectedT>> view;

        private CreateExpected(Iterable<T> elements, Optional<Coder<T>> coder, PTransform<PCollection<T>, PCollectionView<ExpectedT>> view) {
            this.elements = elements;
            this.coder = coder;
            this.view = view;
        }

        @Override
        public PCollectionView<ExpectedT> apply(PBegin input) {
            Create.Values<T> createTransform = Create.of(this.elements);
            if (this.coder.isPresent()) {
                createTransform = createTransform.withCoder(this.coder.get());
            }
            return ((PCollection)input.apply(createTransform)).apply(this.view);
        }
    }

    private static class CreateActual<T, ActualT>
    extends PTransform<PBegin, PCollectionView<ActualT>> {
        private final transient PCollection<T> actual;
        private final transient PTransform<PCollection<T>, PCollectionView<ActualT>> actualView;

        private CreateActual(PCollection<T> actual, PTransform<PCollection<T>, PCollectionView<ActualT>> actualView) {
            this.actual = actual;
            this.actualView = actualView;
        }

        @Override
        public PCollectionView<ActualT> apply(PBegin input) {
            final Coder<T> coder = this.actual.getCoder();
            return ((PCollection)((PCollection)this.actual.apply(Window.into(new GlobalWindows()))).apply(ParDo.of(new DoFn<T, T>(){

                @Override
                public void processElement(DoFn.ProcessContext context) throws CoderException {
                    context.output(CoderUtils.clone(coder, context.element()));
                }
            }))).apply(this.actualView);
        }
    }

    public static class SingletonAssert<T>
    implements Serializable {
        private final Pipeline pipeline;
        private final CreateActual<?, T> createActual;
        private Optional<Coder<T>> coder;

        protected SingletonAssert(CreateActual<?, T> createActual, Pipeline pipeline) {
            this.pipeline = pipeline;
            this.createActual = createActual;
            this.coder = Optional.absent();
        }

        public SingletonAssert<T> setCoder(Coder<T> coderOrNull) {
            this.coder = Optional.fromNullable(coderOrNull);
            return this;
        }

        public Coder<T> getCoder() {
            if (this.coder.isPresent()) {
                return this.coder.get();
            }
            throw new IllegalStateException("Attempting to access the coder of an IterableAssert that has not been set yet.");
        }

        public SingletonAssert<T> satisfies(SerializableFunction<T, Void> checkerFn) {
            int n = assertCount++;
            this.pipeline.apply(new StringBuilder(26).append("DataflowAssert$").append(n).toString(), new OneSideInputAssert<T>(this.createActual, checkerFn));
            return this;
        }

        public SingletonAssert<T> satisfies(AssertRelation<T, T> relation, T expectedValue) {
            int n = assertCount++;
            this.pipeline.apply(new StringBuilder(26).append("DataflowAssert$").append(n).toString(), new TwoSideInputAssert<T, T>(this.createActual, new CreateExpected(Arrays.asList(expectedValue), this.coder, View.asSingleton()), relation));
            return this;
        }

        public SingletonAssert<T> isEqualTo(T expectedValue) {
            return this.satisfies(new AssertIsEqualToRelation(), expectedValue);
        }

        @Deprecated
        public SingletonAssert<T> is(T expectedValue) {
            return this.isEqualTo(expectedValue);
        }
    }

    public static class IterableAssert<T>
    implements Serializable {
        private final Pipeline pipeline;
        private final PTransform<PBegin, PCollectionView<Iterable<T>>> createActual;
        private Optional<Coder<T>> coder;

        protected IterableAssert(PTransform<PBegin, PCollectionView<Iterable<T>>> createActual, Pipeline pipeline) {
            this.createActual = createActual;
            this.pipeline = pipeline;
            this.coder = Optional.absent();
        }

        public IterableAssert<T> setCoder(Coder<T> coderOrNull) {
            this.coder = Optional.fromNullable(coderOrNull);
            return this;
        }

        public Coder<T> getCoder() {
            if (this.coder.isPresent()) {
                return this.coder.get();
            }
            throw new IllegalStateException("Attempting to access the coder of an IterableAssert that has not been set yet.");
        }

        public IterableAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> checkerFn) {
            int n = assertCount++;
            this.pipeline.apply(new StringBuilder(26).append("DataflowAssert$").append(n).toString(), new OneSideInputAssert<Iterable<T>>(this.createActual, checkerFn));
            return this;
        }

        public IterableAssert<T> satisfies(AssertRelation<Iterable<T>, Iterable<T>> relation, Iterable<T> expectedElements) {
            int n = assertCount++;
            this.pipeline.apply(new StringBuilder(26).append("DataflowAssert$").append(n).toString(), new TwoSideInputAssert<Iterable<T>, Iterable<T>>(this.createActual, new CreateExpected(expectedElements, this.coder, View.asIterable()), relation));
            return this;
        }

        IterableAssert<T> satisfies(SerializableMatcher<Iterable<? extends T>> matcher) {
            MatcherCheckerFn<Iterable<? extends T>> checkerFn = new MatcherCheckerFn<Iterable<? extends T>>(matcher);
            int n = assertCount++;
            this.pipeline.apply(new StringBuilder(26).append("DataflowAssert$").append(n).toString(), new OneSideInputAssert(this.createActual, checkerFn));
            return this;
        }

        public IterableAssert<T> empty() {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), Collections.emptyList());
        }

        public IterableAssert<T> containsInAnyOrder(Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        @SafeVarargs
        public final IterableAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), Arrays.asList(expectedElements));
        }

        @SafeVarargs
        final IterableAssert<T> containsInAnyOrder(SerializableMatcher<? super T> ... elementMatchers) {
            return this.satisfies(SerializableMatchers.containsInAnyOrder(elementMatchers));
        }

        private static class MatcherCheckerFn<T>
        implements SerializableFunction<T, Void> {
            private SerializableMatcher<T> matcher;

            public MatcherCheckerFn(SerializableMatcher<T> matcher) {
                this.matcher = matcher;
            }

            @Override
            public Void apply(T actual) {
                Assert.assertThat(actual, this.matcher);
                return null;
            }
        }
    }
}

