/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.CustomCoder;
import com.google.cloud.dataflow.sdk.coders.DelegateCoder;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.coders.VarIntCoder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.Flatten;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.Values;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.transforms.WithKeys;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.util.AppliedCombineFn;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.CounterProvider;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionList;
import com.google.cloud.dataflow.sdk.values.PCollectionTuple;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import com.google.cloud.dataflow.sdk.values.TypedPValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class Combine {
    public static <V> Globally<V, V> globally(SerializableFunction<Iterable<V>, V> combiner) {
        return Combine.globally(IterableCombineFn.of(combiner));
    }

    public static <InputT, OutputT> Globally<InputT, OutputT> globally(CombineFn<? super InputT, ?, OutputT> fn) {
        return new Globally(fn, true, 0);
    }

    public static <K, V> PerKey<K, V, V> perKey(SerializableFunction<Iterable<V>, V> fn) {
        return Combine.perKey(IterableCombineFn.of(fn));
    }

    public static <K, InputT, OutputT> PerKey<K, InputT, OutputT> perKey(CombineFn<? super InputT, ?, OutputT> fn) {
        return Combine.perKey(fn.asKeyedFn());
    }

    public static <K, InputT, OutputT> PerKey<K, InputT, OutputT> perKey(KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn) {
        return new PerKey(fn, false);
    }

    private static <K, InputT, OutputT> PerKey<K, InputT, OutputT> fewKeys(KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn) {
        return new PerKey(fn, true);
    }

    public static <K, V> GroupedValues<K, V, V> groupedValues(SerializableFunction<Iterable<V>, V> fn) {
        return Combine.groupedValues(IterableCombineFn.of(fn));
    }

    public static <K, InputT, OutputT> GroupedValues<K, InputT, OutputT> groupedValues(CombineFn<? super InputT, ?, OutputT> fn) {
        return Combine.groupedValues(fn.asKeyedFn());
    }

    public static <K, InputT, OutputT> GroupedValues<K, InputT, OutputT> groupedValues(KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn) {
        return new GroupedValues(fn);
    }

    public static class GroupedValues<K, InputT, OutputT>
    extends PTransform<PCollection<? extends KV<K, ? extends Iterable<InputT>>>, PCollection<KV<K, OutputT>>> {
        private final KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn;

        private GroupedValues(KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn) {
            this.fn = SerializableUtils.clone(fn);
        }

        public KeyedCombineFn<? super K, ? super InputT, ?, OutputT> getFn() {
            return this.fn;
        }

        @Override
        public PCollection<KV<K, OutputT>> apply(PCollection<? extends KV<K, ? extends Iterable<InputT>>> input) {
            PCollection output = (PCollection)input.apply(ParDo.of(new DoFn<KV<K, ? extends Iterable<InputT>>, KV<K, OutputT>>(){

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    Object key = ((KV)c.element()).getKey();
                    c.output(KV.of(key, GroupedValues.this.fn.apply(key, (Iterable)((KV)c.element()).getValue())));
                }
            }));
            try {
                Coder<KV<K, OutputT>> outputCoder = this.getDefaultOutputCoder(input);
                output.setCoder((Coder)outputCoder);
            }
            catch (CannotProvideCoderException cannotProvideCoderException) {
                // empty catch block
            }
            return output;
        }

        public AppliedCombineFn<? super K, ? super InputT, ?, OutputT> getAppliedFn(CoderRegistry registry, Coder<? extends KV<K, ? extends Iterable<InputT>>> inputCoder) {
            KvCoder<K, InputT> kvCoder = this.getKvCoder(inputCoder);
            return AppliedCombineFn.withInputCoder(this.fn, registry, kvCoder);
        }

        private KvCoder<K, InputT> getKvCoder(Coder<? extends KV<K, ? extends Iterable<InputT>>> inputCoder) {
            if (!(inputCoder instanceof KvCoder)) {
                throw new IllegalStateException("Combine.GroupedValues requires its input to use KvCoder");
            }
            KvCoder kvCoder = (KvCoder)inputCoder;
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder kvValueCoder = kvCoder.getValueCoder();
            if (!(kvValueCoder instanceof IterableCoder)) {
                throw new IllegalStateException("Combine.GroupedValues requires its input values to use IterableCoder");
            }
            IterableCoder inputValuesCoder = (IterableCoder)kvValueCoder;
            Coder inputValueCoder = inputValuesCoder.getElemCoder();
            return KvCoder.of(keyCoder, inputValueCoder);
        }

        @Override
        public Coder<KV<K, OutputT>> getDefaultOutputCoder(PCollection<? extends KV<K, ? extends Iterable<InputT>>> input) throws CannotProvideCoderException {
            KvCoder<K, InputT> kvCoder = this.getKvCoder(input.getCoder());
            Coder<OutputT> outputValueCoder = this.fn.getDefaultOutputCoder(input.getPipeline().getCoderRegistry(), kvCoder.getKeyCoder(), kvCoder.getValueCoder());
            return KvCoder.of(kvCoder.getKeyCoder(), outputValueCoder);
        }
    }

    public static class PerKeyWithHotKeyFanout<K, InputT, OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>> {
        private final transient KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn;
        private final SerializableFunction<? super K, Integer> hotKeyFanout;

        private PerKeyWithHotKeyFanout(String name, KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn, SerializableFunction<? super K, Integer> hotKeyFanout) {
            super(name);
            this.fn = fn;
            this.hotKeyFanout = hotKeyFanout;
        }

        @Override
        public PCollection<KV<K, OutputT>> apply(PCollection<KV<K, InputT>> input) {
            return this.applyHelper(input);
        }

        private <AccumT> PCollection<KV<K, OutputT>> applyHelper(PCollection<KV<K, InputT>> input) {
            Coder<?> accumCoder;
            final KeyedCombineFn fn = this.fn;
            if (!(input.getCoder() instanceof KvCoder)) {
                String string = String.valueOf(input.getCoder());
                throw new IllegalStateException(new StringBuilder(44 + String.valueOf(string).length()).append("Expected input coder to be KvCoder, but was ").append(string).toString());
            }
            final KvCoder inputCoder = (KvCoder)input.getCoder();
            try {
                accumCoder = fn.getAccumulatorCoder(input.getPipeline().getCoderRegistry(), inputCoder.getKeyCoder(), inputCoder.getValueCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalStateException("Unable to determine accumulator coder.", e);
            }
            InputOrAccum.InputOrAccumCoder inputOrAccumCoder = new InputOrAccum.InputOrAccumCoder(inputCoder.getValueCoder(), accumCoder);
            KeyedCombineFn hotPreCombine = new KeyedCombineFn<KV<K, Integer>, InputT, AccumT, AccumT>(){

                @Override
                public AccumT createAccumulator(KV<K, Integer> key) {
                    return fn.createAccumulator(key.getKey());
                }

                @Override
                public AccumT addInput(KV<K, Integer> key, AccumT accumulator, InputT value) {
                    return fn.addInput(key.getKey(), accumulator, value);
                }

                @Override
                public AccumT mergeAccumulators(KV<K, Integer> key, Iterable<AccumT> accumulators) {
                    return fn.mergeAccumulators(key.getKey(), accumulators);
                }

                @Override
                public AccumT extractOutput(KV<K, Integer> key, AccumT accumulator) {
                    return accumulator;
                }

                @Override
                public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<KV<K, Integer>> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return accumCoder;
                }
            };
            KeyedCombineFn postCombine = new KeyedCombineFn<K, InputOrAccum<InputT, AccumT>, AccumT, OutputT>(){

                @Override
                public AccumT createAccumulator(K key) {
                    return fn.createAccumulator(key);
                }

                @Override
                public AccumT addInput(K key, AccumT accumulator, InputOrAccum<InputT, AccumT> value) {
                    if (value.accum == null) {
                        return fn.addInput(key, accumulator, value.input);
                    }
                    return fn.mergeAccumulators(key, ImmutableList.of(accumulator, value.accum));
                }

                @Override
                public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators) {
                    return fn.mergeAccumulators(key, accumulators);
                }

                @Override
                public OutputT extractOutput(K key, AccumT accumulator) {
                    return fn.extractOutput(key, accumulator);
                }

                @Override
                public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputOrAccum<InputT, AccumT>> accumulatorCoder) throws CannotProvideCoderException {
                    return fn.getDefaultOutputCoder(registry, keyCoder, inputCoder.getValueCoder());
                }

                @Override
                public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputOrAccum<InputT, AccumT>> inputCoder2) throws CannotProvideCoderException {
                    return accumCoder;
                }
            };
            final TupleTag hot = new TupleTag();
            TupleTag cold = new TupleTag();
            PCollectionTuple split = (PCollectionTuple)input.apply(ParDo.named("AddNonce").of(new DoFn<KV<K, InputT>, KV<K, InputT>>(){
                transient int counter;

                @Override
                public void startBundle(DoFn.Context c) {
                    this.counter = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
                }

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    KV kv = (KV)c.element();
                    int spread = Math.max(1, (Integer)PerKeyWithHotKeyFanout.this.hotKeyFanout.apply(kv.getKey()));
                    if (spread <= 1) {
                        c.output(kv);
                    } else {
                        int nonce = this.counter++ % spread;
                        c.sideOutput(hot, KV.of(KV.of(kv.getKey(), nonce), kv.getValue()));
                    }
                }
            }).withOutputTags(cold, TupleTagList.of(hot)));
            WindowingStrategy<?, ?> preCombineStrategy = input.getWindowingStrategy();
            if (preCombineStrategy.getMode() == WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES) {
                preCombineStrategy = preCombineStrategy.withMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES);
            }
            PCollection precombinedHot = ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)split.get(hot).setCoder((Coder)KvCoder.of(KvCoder.of(inputCoder.getKeyCoder(), VarIntCoder.of()), inputCoder.getValueCoder()))).setWindowingStrategyInternal(preCombineStrategy).apply("PreCombineHot", Combine.perKey(hotPreCombine))).apply(ParDo.named("StripNonce").of(new DoFn<KV<KV<K, Integer>, AccumT>, KV<K, InputOrAccum<InputT, AccumT>>>(){

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    c.output(KV.of(((KV)((KV)c.element()).getKey()).getKey(), InputOrAccum.accum(((KV)c.element()).getValue())));
                }
            }))).setCoder((Coder)KvCoder.of(inputCoder.getKeyCoder(), inputOrAccumCoder))).apply(Window.remerge())).setWindowingStrategyInternal(input.getWindowingStrategy());
            TypedPValue preprocessedCold = ((PCollection)((PCollection)split.get(cold).setCoder((Coder)inputCoder)).apply(ParDo.named("PrepareCold").of(new DoFn<KV<K, InputT>, KV<K, InputOrAccum<InputT, AccumT>>>(){

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    c.output(KV.of(((KV)c.element()).getKey(), InputOrAccum.input(((KV)c.element()).getValue())));
                }
            }))).setCoder((Coder)KvCoder.of(inputCoder.getKeyCoder(), inputOrAccumCoder));
            return (PCollection)((PCollection)PCollectionList.of(precombinedHot).and(preprocessedCold).apply(Flatten.pCollections())).apply("PostCombine", Combine.perKey(postCombine));
        }

        private static class InputOrAccum<InputT, AccumT> {
            public final InputT input;
            public final AccumT accum;

            private InputOrAccum(InputT input, AccumT aggr) {
                this.input = input;
                this.accum = aggr;
            }

            public static <InputT, AccumT> InputOrAccum<InputT, AccumT> input(InputT input) {
                return new InputOrAccum<InputT, Object>(input, null);
            }

            public static <InputT, AccumT> InputOrAccum<InputT, AccumT> accum(AccumT aggr) {
                return new InputOrAccum<Object, AccumT>(null, aggr);
            }

            private static class InputOrAccumCoder<InputT, AccumT>
            extends StandardCoder<InputOrAccum<InputT, AccumT>> {
                private final Coder<InputT> inputCoder;
                private final Coder<AccumT> accumCoder;

                public InputOrAccumCoder(Coder<InputT> inputCoder, Coder<AccumT> accumCoder) {
                    this.inputCoder = inputCoder;
                    this.accumCoder = accumCoder;
                }

                @JsonCreator
                public static <InputT, AccumT> InputOrAccumCoder<InputT, AccumT> of(@JsonProperty(value="component_encodings") List<Coder<?>> elementCoders) {
                    return new InputOrAccumCoder(elementCoders.get(0), elementCoders.get(1));
                }

                @Override
                public void encode(InputOrAccum<InputT, AccumT> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
                    if (value.input != null) {
                        outStream.write(0);
                        this.inputCoder.encode(value.input, outStream, context);
                    } else {
                        outStream.write(1);
                        this.accumCoder.encode(value.accum, outStream, context);
                    }
                }

                @Override
                public InputOrAccum<InputT, AccumT> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
                    if (inStream.read() == 0) {
                        return InputOrAccum.input(this.inputCoder.decode(inStream, context));
                    }
                    return InputOrAccum.accum(this.accumCoder.decode(inStream, context));
                }

                @Override
                public List<? extends Coder<?>> getCoderArguments() {
                    return ImmutableList.of(this.inputCoder, this.accumCoder);
                }

                @Override
                public void verifyDeterministic() throws Coder.NonDeterministicException {
                    this.inputCoder.verifyDeterministic();
                    this.accumCoder.verifyDeterministic();
                }
            }
        }
    }

    public static class PerKey<K, InputT, OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>> {
        private final transient KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn;
        private final boolean fewKeys;

        private PerKey(KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn, boolean fewKeys) {
            this.fn = fn;
            this.fewKeys = fewKeys;
        }

        private PerKey(String name, KeyedCombineFn<? super K, ? super InputT, ?, OutputT> fn, boolean fewKeys) {
            super(name);
            this.fn = fn;
            this.fewKeys = fewKeys;
        }

        public PerKey<K, InputT, OutputT> named(String name) {
            return new PerKey<K, InputT, OutputT>(name, this.fn, this.fewKeys);
        }

        public PerKeyWithHotKeyFanout<K, InputT, OutputT> withHotKeyFanout(SerializableFunction<? super K, Integer> hotKeyFanout) {
            return new PerKeyWithHotKeyFanout(this.name, this.fn, hotKeyFanout);
        }

        public PerKeyWithHotKeyFanout<K, InputT, OutputT> withHotKeyFanout(final int hotKeyFanout) {
            return new PerKeyWithHotKeyFanout(this.name, this.fn, new SerializableFunction<K, Integer>(){

                @Override
                public Integer apply(K unused) {
                    return hotKeyFanout;
                }
            });
        }

        public KeyedCombineFn<? super K, ? super InputT, ?, OutputT> getFn() {
            return this.fn;
        }

        @Override
        public PCollection<KV<K, OutputT>> apply(PCollection<KV<K, InputT>> input) {
            return (PCollection)((PCollection)input.apply(GroupByKey.create(this.fewKeys))).apply(Combine.groupedValues(this.fn));
        }
    }

    @Deprecated
    public static class SimpleCombineFn<V>
    extends IterableCombineFn<V> {
        @Deprecated
        public static <V> SimpleCombineFn<V> of(SerializableFunction<Iterable<V>, V> combiner) {
            return new SimpleCombineFn<V>(combiner);
        }

        protected SimpleCombineFn(SerializableFunction<Iterable<V>, V> combiner) {
            super(combiner, 20);
        }
    }

    public static class IterableCombineFn<V>
    extends CombineFn<V, List<V>, V> {
        private static final int DEFAULT_BUFFER_SIZE = 20;
        private final SerializableFunction<Iterable<V>, V> combiner;
        private final int bufferSize;

        public static <V> IterableCombineFn<V> of(SerializableFunction<Iterable<V>, V> combiner) {
            return IterableCombineFn.of(combiner, 20);
        }

        public static <V> IterableCombineFn<V> of(SerializableFunction<Iterable<V>, V> combiner, int bufferSize) {
            return new IterableCombineFn<V>(combiner, bufferSize);
        }

        private IterableCombineFn(SerializableFunction<Iterable<V>, V> combiner, int bufferSize) {
            this.combiner = combiner;
            this.bufferSize = bufferSize;
        }

        @Override
        public List<V> createAccumulator() {
            return new ArrayList();
        }

        @Override
        public List<V> addInput(List<V> accumulator, V input) {
            accumulator.add(input);
            if (accumulator.size() > this.bufferSize) {
                return this.mergeToSingleton(accumulator);
            }
            return accumulator;
        }

        @Override
        public List<V> mergeAccumulators(Iterable<List<V>> accumulators) {
            return this.mergeToSingleton(Iterables.concat(accumulators));
        }

        @Override
        public V extractOutput(List<V> accumulator) {
            return this.combiner.apply(accumulator);
        }

        private List<V> mergeToSingleton(Iterable<V> values) {
            ArrayList<V> singleton = new ArrayList<V>();
            singleton.add(this.combiner.apply(values));
            return singleton;
        }
    }

    public static class GloballyAsSingletonView<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollectionView<OutputT>> {
        private final CombineFn<? super InputT, ?, OutputT> fn;
        private final boolean insertDefault;
        private final int fanout;

        private GloballyAsSingletonView(CombineFn<? super InputT, ?, OutputT> fn, boolean insertDefault, int fanout) {
            this.fn = fn;
            this.insertDefault = insertDefault;
            this.fanout = fanout;
        }

        @Override
        public PCollectionView<OutputT> apply(PCollection<InputT> input) {
            PCollection combined = (PCollection)input.apply(Combine.globally(this.fn).withoutDefaults().withFanout(this.fanout));
            if (this.insertDefault) {
                return (PCollectionView)combined.apply(View.asSingleton().withDefaultValue(this.fn.apply(Collections.emptyList())));
            }
            return (PCollectionView)combined.apply(View.asSingleton());
        }

        public int getFanout() {
            return this.fanout;
        }

        public boolean getInsertDefault() {
            return this.insertDefault;
        }

        public CombineFn<? super InputT, ?, OutputT> getCombineFn() {
            return this.fn;
        }
    }

    public static class Globally<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        private final CombineFn<? super InputT, ?, OutputT> fn;
        private final boolean insertDefault;
        private final int fanout;

        private Globally(CombineFn<? super InputT, ?, OutputT> fn, boolean insertDefault, int fanout) {
            this.fn = fn;
            this.insertDefault = insertDefault;
            this.fanout = fanout;
        }

        private Globally(String name, CombineFn<? super InputT, ?, OutputT> fn, boolean insertDefault, int fanout) {
            super(name);
            this.fn = fn;
            this.insertDefault = insertDefault;
            this.fanout = fanout;
        }

        public Globally<InputT, OutputT> named(String name) {
            return new Globally<InputT, OutputT>(name, this.fn, this.insertDefault, this.fanout);
        }

        public GloballyAsSingletonView<InputT, OutputT> asSingletonView() {
            return new GloballyAsSingletonView(this.fn, this.insertDefault, this.fanout);
        }

        public Globally<InputT, OutputT> withoutDefaults() {
            return new Globally<InputT, OutputT>(this.name, this.fn, false, this.fanout);
        }

        public Globally<InputT, OutputT> withFanout(int fanout) {
            return new Globally<InputT, OutputT>(this.name, this.fn, this.insertDefault, fanout);
        }

        @Override
        public PCollection<OutputT> apply(PCollection<InputT> input) {
            TypedPValue withKeys = ((PCollection)input.apply(WithKeys.of((Void)null))).setCoder(KvCoder.of(VoidCoder.of(), input.getCoder()));
            PCollection combined = this.fanout >= 2 ? (PCollection)((PCollection)withKeys).apply(Combine.fewKeys(this.fn.asKeyedFn()).withHotKeyFanout(this.fanout)) : (PCollection)((PCollection)withKeys).apply(Combine.fewKeys(this.fn.asKeyedFn()));
            PCollection output = (PCollection)combined.apply(Values.create());
            if (this.insertDefault) {
                if (!output.getWindowingStrategy().getWindowFn().isCompatible(new GlobalWindows())) {
                    throw new IllegalStateException("Attempted to add default value to PCollection not windowed by GlobalWindows. Instead, use Combine.globally().withoutDefaults() or Combine.globally().asSingletonView().");
                }
                return this.insertDefaultValueIfEmpty(output);
            }
            return output;
        }

        private PCollection<OutputT> insertDefaultValueIfEmpty(PCollection<OutputT> maybeEmpty) {
            final PCollectionView maybeEmptyView = (PCollectionView)maybeEmpty.apply(View.asIterable());
            PCollection defaultIfEmpty = ((PCollection)((PCollection)((PCollection)maybeEmpty.getPipeline().apply("CreateVoid", Create.of(new Void[]{null}).withCoder(VoidCoder.of()))).apply(ParDo.named("ProduceDefault").withSideInputs(maybeEmptyView).of(new DoFn<Void, OutputT>(){

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    Iterator combined = ((Iterable)c.sideInput(maybeEmptyView)).iterator();
                    if (!combined.hasNext()) {
                        c.output(Globally.this.fn.apply(Collections.emptyList()));
                    }
                }
            }))).setCoder((Coder)maybeEmpty.getCoder())).setWindowingStrategyInternal(maybeEmpty.getWindowingStrategy());
            return (PCollection)PCollectionList.of(maybeEmpty).and(defaultIfEmpty).apply(Flatten.pCollections());
        }
    }

    public static abstract class KeyedCombineFn<K, InputT, AccumT, OutputT>
    implements Serializable {
        public abstract AccumT createAccumulator(K var1);

        public abstract AccumT addInput(K var1, AccumT var2, InputT var3);

        public abstract AccumT mergeAccumulators(K var1, Iterable<AccumT> var2);

        public abstract OutputT extractOutput(K var1, AccumT var2);

        public CombineFn<InputT, AccumT, OutputT> forKey(final K key, final Coder<K> keyCoder) {
            return new CombineFn<InputT, AccumT, OutputT>(){

                @Override
                public AccumT createAccumulator() {
                    return KeyedCombineFn.this.createAccumulator(key);
                }

                @Override
                public AccumT addInput(AccumT accumulator, InputT input) {
                    return KeyedCombineFn.this.addInput(key, accumulator, input);
                }

                @Override
                public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
                    return KeyedCombineFn.this.mergeAccumulators(key, accumulators);
                }

                @Override
                public OutputT extractOutput(AccumT accumulator) {
                    return KeyedCombineFn.this.extractOutput(key, accumulator);
                }

                @Override
                public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return KeyedCombineFn.this.getAccumulatorCoder(registry, keyCoder, inputCoder);
                }

                @Override
                public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return KeyedCombineFn.this.getDefaultOutputCoder(registry, keyCoder, inputCoder);
                }
            };
        }

        public OutputT apply(K key, Iterable<? extends InputT> inputs) {
            AccumT accum = this.createAccumulator(key);
            for (InputT input : inputs) {
                accum = this.addInput(key, accum, input);
            }
            return this.extractOutput(key, accum);
        }

        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), KeyedCombineFn.class, ImmutableMap.of(this.getKTypeVariable(), keyCoder, this.getInputTVariable(), inputCoder), this.getAccumTVariable());
        }

        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), KeyedCombineFn.class, ImmutableMap.of(this.getKTypeVariable(), keyCoder, this.getInputTVariable(), inputCoder, this.getAccumTVariable(), this.getAccumulatorCoder(registry, keyCoder, inputCoder)), this.getOutputTVariable());
        }

        private TypeVariable<Class<KeyedCombineFn<?, ?, ?, ?>>> getKTypeVariable() {
            return (TypeVariable)new TypeDescriptor<K>(KeyedCombineFn.class){}.getType();
        }

        private TypeVariable<Class<KeyedCombineFn<?, ?, ?, ?>>> getInputTVariable() {
            return (TypeVariable)new TypeDescriptor<InputT>(KeyedCombineFn.class){}.getType();
        }

        private TypeVariable<Class<KeyedCombineFn<?, ?, ?, ?>>> getAccumTVariable() {
            return (TypeVariable)new TypeDescriptor<AccumT>(KeyedCombineFn.class){}.getType();
        }

        private TypeVariable<Class<KeyedCombineFn<?, ?, ?, ?>>> getOutputTVariable() {
            return (TypeVariable)new TypeDescriptor<OutputT>(KeyedCombineFn.class){}.getType();
        }
    }

    public static abstract class AccumulatingCombineFn<InputT, AccumT extends Accumulator<InputT, AccumT, OutputT>, OutputT>
    extends CombineFn<InputT, AccumT, OutputT> {
        @Override
        public final AccumT addInput(AccumT accumulator, InputT input) {
            accumulator.addInput(input);
            return accumulator;
        }

        @Override
        public final AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
            Accumulator accumulator = (Accumulator)this.createAccumulator();
            for (Accumulator partial : accumulators) {
                accumulator.mergeAccumulator(partial);
            }
            return (AccumT)accumulator;
        }

        @Override
        public final OutputT extractOutput(AccumT accumulator) {
            return accumulator.extractOutput();
        }

        public static interface Accumulator<InputT, AccumT, OutputT> {
            public void addInput(InputT var1);

            public void mergeAccumulator(AccumT var1);

            public OutputT extractOutput();
        }
    }

    public static abstract class BinaryCombineDoubleFn
    extends CombineFn<Double, double[], Double>
    implements CounterProvider<Double> {
        public abstract double apply(double var1, double var3);

        public abstract double identity();

        @Override
        public double[] createAccumulator() {
            return this.wrap(this.identity());
        }

        @Override
        public double[] addInput(double[] accumulator, Double input) {
            accumulator[0] = this.apply(accumulator[0], input);
            return accumulator;
        }

        @Override
        public double[] mergeAccumulators(Iterable<double[]> accumulators) {
            Iterator<double[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            double running = iter.next()[0];
            while (iter.hasNext()) {
                running = this.apply(running, iter.next()[0]);
            }
            return this.wrap(running);
        }

        @Override
        public Double extractOutput(double[] accumulator) {
            return accumulator[0];
        }

        @Override
        public Coder<double[]> getAccumulatorCoder(CoderRegistry registry, Coder<Double> inputCoder) {
            return DelegateCoder.of(inputCoder, new DelegateCoder.CodingFunction<double[], Double>(){

                @Override
                public Double apply(double[] accumulator) {
                    return accumulator[0];
                }
            }, new DelegateCoder.CodingFunction<Double, double[]>(){

                @Override
                public double[] apply(Double value) {
                    return BinaryCombineDoubleFn.this.wrap(value);
                }
            });
        }

        @Override
        public Coder<Double> getDefaultOutputCoder(CoderRegistry registry, Coder<Double> inputCoder) {
            return inputCoder;
        }

        private double[] wrap(double value) {
            return new double[]{value};
        }
    }

    public static abstract class BinaryCombineLongFn
    extends CombineFn<Long, long[], Long>
    implements CounterProvider<Long> {
        public abstract long apply(long var1, long var3);

        public abstract long identity();

        @Override
        public long[] createAccumulator() {
            return this.wrap(this.identity());
        }

        @Override
        public long[] addInput(long[] accumulator, Long input) {
            accumulator[0] = this.apply(accumulator[0], input);
            return accumulator;
        }

        @Override
        public long[] mergeAccumulators(Iterable<long[]> accumulators) {
            Iterator<long[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            long running = iter.next()[0];
            while (iter.hasNext()) {
                running = this.apply(running, iter.next()[0]);
            }
            return this.wrap(running);
        }

        @Override
        public Long extractOutput(long[] accumulator) {
            return accumulator[0];
        }

        @Override
        public Coder<long[]> getAccumulatorCoder(CoderRegistry registry, Coder<Long> inputCoder) {
            return DelegateCoder.of(inputCoder, new DelegateCoder.CodingFunction<long[], Long>(){

                @Override
                public Long apply(long[] accumulator) {
                    return accumulator[0];
                }
            }, new DelegateCoder.CodingFunction<Long, long[]>(){

                @Override
                public long[] apply(Long value) {
                    return BinaryCombineLongFn.this.wrap(value);
                }
            });
        }

        @Override
        public Coder<Long> getDefaultOutputCoder(CoderRegistry registry, Coder<Long> inputCoder) {
            return inputCoder;
        }

        private long[] wrap(long value) {
            return new long[]{value};
        }
    }

    public static abstract class BinaryCombineIntegerFn
    extends CombineFn<Integer, int[], Integer>
    implements CounterProvider<Integer> {
        public abstract int apply(int var1, int var2);

        public abstract int identity();

        @Override
        public int[] createAccumulator() {
            return this.wrap(this.identity());
        }

        @Override
        public int[] addInput(int[] accumulator, Integer input) {
            accumulator[0] = this.apply(accumulator[0], input);
            return accumulator;
        }

        @Override
        public int[] mergeAccumulators(Iterable<int[]> accumulators) {
            Iterator<int[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            int running = iter.next()[0];
            while (iter.hasNext()) {
                running = this.apply(running, iter.next()[0]);
            }
            return this.wrap(running);
        }

        @Override
        public Integer extractOutput(int[] accumulator) {
            return accumulator[0];
        }

        @Override
        public Coder<int[]> getAccumulatorCoder(CoderRegistry registry, Coder<Integer> inputCoder) {
            return DelegateCoder.of(inputCoder, new DelegateCoder.CodingFunction<int[], Integer>(){

                @Override
                public Integer apply(int[] accumulator) {
                    return accumulator[0];
                }
            }, new DelegateCoder.CodingFunction<Integer, int[]>(){

                @Override
                public int[] apply(Integer value) {
                    return BinaryCombineIntegerFn.this.wrap(value);
                }
            });
        }

        @Override
        public Coder<Integer> getDefaultOutputCoder(CoderRegistry registry, Coder<Integer> inputCoder) {
            return inputCoder;
        }

        private int[] wrap(int value) {
            return new int[]{value};
        }
    }

    private static class HolderCoder<V>
    extends CustomCoder<Holder<V>> {
        private Coder<V> valueCoder;

        public HolderCoder(Coder<V> valueCoder) {
            this.valueCoder = valueCoder;
        }

        @Override
        public List<Coder<?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }

        @Override
        public void encode(Holder<V> accumulator, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            if (((Holder)accumulator).present) {
                outStream.write(1);
                this.valueCoder.encode(((Holder)accumulator).value, outStream, context);
            } else {
                outStream.write(0);
            }
        }

        @Override
        public Holder<V> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            if (inStream.read() == 1) {
                return new Holder(this.valueCoder.decode(inStream, context));
            }
            return new Holder();
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
        }
    }

    public static class Holder<V> {
        private V value;
        private boolean present;

        private Holder() {
        }

        private Holder(V value) {
            this.set(value);
        }

        private void set(V value) {
            this.present = true;
            this.value = value;
        }
    }

    public static abstract class BinaryCombineFn<V>
    extends CombineFn<V, Holder<V>, V> {
        public abstract V apply(V var1, V var2);

        public V identity() {
            return null;
        }

        @Override
        public Holder<V> createAccumulator() {
            return new Holder();
        }

        @Override
        public Holder<V> addInput(Holder<V> accumulator, V input) {
            if (((Holder)accumulator).present) {
                ((Holder)accumulator).set(this.apply(((Holder)accumulator).value, input));
            } else {
                ((Holder)accumulator).set(input);
            }
            return accumulator;
        }

        @Override
        public Holder<V> mergeAccumulators(Iterable<Holder<V>> accumulators) {
            Holder running = new Holder();
            for (Holder<V> accumulator : accumulators) {
                if (!((Holder)accumulator).present) continue;
                if (running.present) {
                    running.set(this.apply(running.value, ((Holder)accumulator).value));
                    continue;
                }
                running.set(((Holder)accumulator).value);
            }
            return running;
        }

        @Override
        public V extractOutput(Holder<V> accumulator) {
            if (((Holder)accumulator).present) {
                return (V)((Holder)accumulator).value;
            }
            return this.identity();
        }

        @Override
        public Coder<Holder<V>> getAccumulatorCoder(CoderRegistry registry, Coder<V> inputCoder) {
            return new HolderCoder<V>(inputCoder);
        }

        @Override
        public Coder<V> getDefaultOutputCoder(CoderRegistry registry, Coder<V> inputCoder) {
            return inputCoder;
        }
    }

    public static abstract class CombineFn<InputT, AccumT, OutputT>
    implements Serializable {
        public abstract AccumT createAccumulator();

        public abstract AccumT addInput(AccumT var1, InputT var2);

        public abstract AccumT mergeAccumulators(Iterable<AccumT> var1);

        public abstract OutputT extractOutput(AccumT var1);

        public OutputT apply(Iterable<? extends InputT> inputs) {
            AccumT accum = this.createAccumulator();
            for (InputT input : inputs) {
                accum = this.addInput(accum, input);
            }
            return this.extractOutput(accum);
        }

        public TypeDescriptor<OutputT> getOutputType() {
            return new TypeDescriptor<OutputT>(this.getClass()){};
        }

        private TypeVariable<Class<CombineFn<?, ?, ?>>> getInputTVariable() {
            return (TypeVariable)new TypeDescriptor<InputT>(CombineFn.class){}.getType();
        }

        private TypeVariable<Class<CombineFn<?, ?, ?>>> getAccumTVariable() {
            return (TypeVariable)new TypeDescriptor<AccumT>(CombineFn.class){}.getType();
        }

        private TypeVariable<Class<CombineFn<?, ?, ?>>> getOutputTVariable() {
            return (TypeVariable)new TypeDescriptor<OutputT>(CombineFn.class){}.getType();
        }

        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), CombineFn.class, ImmutableMap.of(this.getInputTVariable(), inputCoder), this.getAccumTVariable());
        }

        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), CombineFn.class, ImmutableMap.of(this.getInputTVariable(), inputCoder, this.getAccumTVariable(), this.getAccumulatorCoder(registry, inputCoder)), this.getOutputTVariable());
        }

        public <K> KeyedCombineFn<K, InputT, AccumT, OutputT> asKeyedFn() {
            return new KeyedCombineFn<K, InputT, AccumT, OutputT>(){

                @Override
                public AccumT createAccumulator(K key) {
                    return CombineFn.this.createAccumulator();
                }

                @Override
                public AccumT addInput(K key, AccumT accumulator, InputT input) {
                    return CombineFn.this.addInput(accumulator, input);
                }

                @Override
                public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators) {
                    return CombineFn.this.mergeAccumulators(accumulators);
                }

                @Override
                public OutputT extractOutput(K key, AccumT accumulator) {
                    return CombineFn.this.extractOutput(accumulator);
                }

                @Override
                public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return CombineFn.this.getAccumulatorCoder(registry, inputCoder);
                }

                @Override
                public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return CombineFn.this.getDefaultOutputCoder(registry, inputCoder);
                }

                @Override
                public CombineFn<InputT, AccumT, OutputT> forKey(K key, Coder<K> keyCoder) {
                    return CombineFn.this;
                }
            };
        }
    }
}

