/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.WindowingInternals;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.Duration;
import org.joda.time.Instant;

public abstract class DoFn<InputT, OutputT>
implements Serializable {
    private final Map<String, DelegatingAggregator<?, ?>> aggregators;

    public Duration getAllowedTimestampSkew() {
        return Duration.ZERO;
    }

    public DoFn() {
        this(new HashMap());
    }

    DoFn(Map<String, DelegatingAggregator<?, ?>> aggregators) {
        this.aggregators = aggregators;
    }

    public void startBundle(Context c) throws Exception {
    }

    public abstract void processElement(ProcessContext var1) throws Exception;

    public void finishBundle(Context c) throws Exception {
    }

    protected TypeDescriptor<InputT> getInputTypeDescriptor() {
        return new TypeDescriptor<InputT>(this.getClass()){};
    }

    protected TypeDescriptor<OutputT> getOutputTypeDescriptor() {
        return new TypeDescriptor<OutputT>(this.getClass()){};
    }

    protected final <AggInputT, AggOutputT> Aggregator<AggInputT, AggOutputT> createAggregator(String name, Combine.CombineFn<? super AggInputT, ?, AggOutputT> combiner) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(combiner, "combiner cannot be null");
        Preconditions.checkArgument(!this.aggregators.containsKey(name), "Cannot create aggregator with name %s. An Aggregator with that name already exists within this scope.", name);
        DelegatingAggregator<? super AggInputT, AggOutputT> aggregator = new DelegatingAggregator<AggInputT, AggOutputT>(name, combiner);
        this.aggregators.put(name, aggregator);
        return aggregator;
    }

    protected final <AggInputT> Aggregator<AggInputT, AggInputT> createAggregator(String name, SerializableFunction<Iterable<AggInputT>, AggInputT> combiner) {
        Preconditions.checkNotNull(combiner, "combiner cannot be null.");
        return this.createAggregator(name, Combine.IterableCombineFn.of(combiner));
    }

    Collection<Aggregator<?, ?>> getAggregators() {
        return Collections.unmodifiableCollection(this.aggregators.values());
    }

    static class DelegatingAggregator<AggInputT, AggOutputT>
    implements Aggregator<AggInputT, AggOutputT>,
    Serializable {
        private final UUID id = UUID.randomUUID();
        private final String name;
        private final Combine.CombineFn<AggInputT, ?, AggOutputT> combineFn;
        private Aggregator<AggInputT, ?> delegate;

        public DelegatingAggregator(String name, Combine.CombineFn<? super AggInputT, ?, AggOutputT> combiner) {
            this.name = Preconditions.checkNotNull(name, "name cannot be null");
            Combine.CombineFn<? super AggInputT, ?, AggOutputT> specificCombiner = Preconditions.checkNotNull(combiner, "combineFn cannot be null");
            this.combineFn = specificCombiner;
        }

        @Override
        public void addValue(AggInputT value) {
            if (this.delegate == null) {
                throw new IllegalStateException("addValue cannot be called on Aggregator outside of the execution of a DoFn.");
            }
            this.delegate.addValue(value);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Combine.CombineFn<AggInputT, ?, AggOutputT> getCombineFn() {
            return this.combineFn;
        }

        public void setDelegate(Aggregator<AggInputT, ?> delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("name", this.name).add("combineFn", this.combineFn).toString();
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.combineFn.getClass());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof DelegatingAggregator) {
                DelegatingAggregator that = (DelegatingAggregator)o;
                return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.combineFn.getClass(), that.combineFn.getClass());
            }
            return false;
        }
    }

    @Experimental
    public static interface RequiresWindowAccess {
    }

    public abstract class ProcessContext
    extends Context {
        public abstract InputT element();

        public abstract <T> T sideInput(PCollectionView<T> var1);

        public abstract Instant timestamp();

        public abstract BoundedWindow window();

        public abstract PaneInfo pane();

        @Experimental
        public abstract WindowingInternals<InputT, OutputT> windowingInternals();
    }

    public abstract class Context {
        public abstract PipelineOptions getPipelineOptions();

        public abstract void output(OutputT var1);

        public abstract void outputWithTimestamp(OutputT var1, Instant var2);

        public abstract <T> void sideOutput(TupleTag<T> var1, T var2);

        public abstract <T> void sideOutputWithTimestamp(TupleTag<T> var1, T var2, Instant var3);

        @Experimental(value=Experimental.Kind.AGGREGATOR)
        protected abstract <AggInputT, AggOutputT> Aggregator<AggInputT, AggOutputT> createAggregatorInternal(String var1, Combine.CombineFn<AggInputT, ?, AggOutputT> var2);

        @Experimental(value=Experimental.Kind.AGGREGATOR)
        protected final void setupDelegateAggregators() {
            for (DelegatingAggregator aggregator : DoFn.this.aggregators.values()) {
                this.setupDelegateAggregator(aggregator);
            }
        }

        private final <AggInputT, AggOutputT> void setupDelegateAggregator(DelegatingAggregator<AggInputT, AggOutputT> aggregator) {
            Aggregator<AggInputT, AggOutputT> delegate = this.createAggregatorInternal(aggregator.getName(), aggregator.getCombineFn());
            aggregator.setDelegate(delegate);
        }
    }
}

