/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.SimpleFunction;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.lang.reflect.ParameterizedType;

public class FlatMapElements<InputT, OutputT>
extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
    private final SerializableFunction<InputT, ? extends Iterable<OutputT>> fn;
    private final TypeDescriptor<OutputT> outputType;

    public static <InputT, OutputT> MissingOutputTypeDescriptor<InputT, OutputT> via(SerializableFunction<InputT, ? extends Iterable<OutputT>> fn) {
        return new MissingOutputTypeDescriptor(fn);
    }

    public static <InputT, OutputT> FlatMapElements<InputT, OutputT> via(SimpleFunction<InputT, ? extends Iterable<OutputT>> fn) {
        TypeDescriptor<Iterable<?>> iterableType = fn.getOutputTypeDescriptor();
        TypeDescriptor<?> outputType = FlatMapElements.getIterableElementType(iterableType);
        return new FlatMapElements(fn, outputType);
    }

    private static TypeDescriptor<?> getIterableElementType(TypeDescriptor<Iterable<?>> iterableTypeDescriptor) {
        if (!iterableTypeDescriptor.isSubtypeOf(new TypeDescriptor<Iterable<?>>(){})) {
            return new TypeDescriptor<Object>(){};
        }
        ParameterizedType iterableType = (ParameterizedType)iterableTypeDescriptor.getSupertype(Iterable.class).getType();
        return TypeDescriptor.of(iterableType.getActualTypeArguments()[0]);
    }

    private FlatMapElements(SerializableFunction<InputT, ? extends Iterable<OutputT>> fn, TypeDescriptor<OutputT> outputType) {
        this.fn = fn;
        this.outputType = outputType;
    }

    @Override
    public PCollection<OutputT> apply(PCollection<InputT> input) {
        return ((PCollection)input.apply(ParDo.named("Map").of(new DoFn<InputT, OutputT>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void processElement(DoFn.ProcessContext c) {
                for (Object element : (Iterable)FlatMapElements.this.fn.apply(c.element())) {
                    c.output(element);
                }
            }
        }))).setTypeDescriptorInternal((TypeDescriptor)this.outputType);
    }

    public static final class MissingOutputTypeDescriptor<InputT, OutputT> {
        private final SerializableFunction<InputT, ? extends Iterable<OutputT>> fn;

        private MissingOutputTypeDescriptor(SerializableFunction<InputT, ? extends Iterable<OutputT>> fn) {
            this.fn = fn;
        }

        public FlatMapElements<InputT, OutputT> withOutputType(TypeDescriptor<OutputT> outputType) {
            return new FlatMapElements(this.fn, outputType);
        }
    }
}

