/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.TypedPValue;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class PTransform<InputT extends PInput, OutputT extends POutput>
implements Serializable {
    protected final transient String name;

    public OutputT apply(InputT input) {
        String string = String.valueOf(input.getPipeline().getRunner());
        String string2 = String.valueOf(this);
        throw new IllegalArgumentException(new StringBuilder(82 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Runner ").append(string).append(" has not registered an implementation for the required primitive operation ").append(string2).toString());
    }

    public void validate(InputT input) {
    }

    public String getName() {
        return this.name != null ? this.name : this.getKindString();
    }

    protected PTransform() {
        this.name = null;
    }

    protected PTransform(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.name == null) {
            return this.getKindString();
        }
        String string = this.getName();
        String string2 = this.getKindString();
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" [").append(string2).append("]").toString();
    }

    protected String getKindString() {
        if (this.getClass().isAnonymousClass()) {
            return "AnonymousTransform";
        }
        return StringUtils.approximatePTransformName(this.getClass());
    }

    private void writeObject(ObjectOutputStream oos) {
    }

    private void readObject(ObjectInputStream oos) {
    }

    protected Coder<?> getDefaultOutputCoder() throws CannotProvideCoderException {
        throw new CannotProvideCoderException("PTransform.getDefaultOutputCoder called.");
    }

    protected Coder<?> getDefaultOutputCoder(InputT input) throws CannotProvideCoderException {
        return this.getDefaultOutputCoder();
    }

    public <T> Coder<T> getDefaultOutputCoder(InputT input, TypedPValue<T> output) throws CannotProvideCoderException {
        Coder<?> defaultOutputCoder = this.getDefaultOutputCoder(input);
        return defaultOutputCoder;
    }
}

