/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.util.common.Counter;

public class Sum {
    public static Combine.Globally<Integer, Integer> integersGlobally() {
        return Combine.globally(new SumIntegerFn()).named("Sum.Globally");
    }

    public static <K> Combine.PerKey<K, Integer, Integer> integersPerKey() {
        return Combine.perKey(new SumIntegerFn()).named("Sum.PerKey");
    }

    public static Combine.Globally<Long, Long> longsGlobally() {
        return Combine.globally(new SumLongFn()).named("Sum.Globally");
    }

    public static <K> Combine.PerKey<K, Long, Long> longsPerKey() {
        return Combine.perKey(new SumLongFn()).named("Sum.PerKey");
    }

    public static Combine.Globally<Double, Double> doublesGlobally() {
        return Combine.globally(new SumDoubleFn()).named("Sum.Globally");
    }

    public static <K> Combine.PerKey<K, Double, Double> doublesPerKey() {
        return Combine.perKey(new SumDoubleFn()).named("Sum.PerKey");
    }

    public static class SumDoubleFn
    extends Combine.BinaryCombineDoubleFn {
        @Override
        public double apply(double a, double b) {
            return a + b;
        }

        @Override
        public double identity() {
            return 0.0;
        }

        @Override
        public Counter<Double> getCounter(String name) {
            return Counter.doubles(name, Counter.AggregationKind.SUM);
        }
    }

    public static class SumLongFn
    extends Combine.BinaryCombineLongFn {
        @Override
        public long apply(long a, long b) {
            return a + b;
        }

        @Override
        public long identity() {
            return 0L;
        }

        @Override
        public Counter<Long> getCounter(String name) {
            return Counter.longs(name, Counter.AggregationKind.SUM);
        }
    }

    public static class SumIntegerFn
    extends Combine.BinaryCombineIntegerFn {
        @Override
        public int apply(int a, int b) {
            return a + b;
        }

        @Override
        public int identity() {
            return 0;
        }

        @Override
        public Counter<Integer> getCounter(String name) {
            return Counter.ints(name, Counter.AggregationKind.SUM);
        }
    }
}

