/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.ListCoder;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.PCollectionViews;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class View {
    private View() {
    }

    public static <T> AsSingleton<T> asSingleton() {
        return new AsSingleton();
    }

    public static <T> PTransform<PCollection<T>, PCollectionView<List<T>>> asList() {
        return new AsList();
    }

    public static <T> AsIterable<T> asIterable() {
        return new AsIterable();
    }

    public static <K, V> AsMap<K, V> asMap() {
        return new AsMap();
    }

    public static <K, V> AsMultimap<K, V> asMultimap() {
        return new AsMultimap();
    }

    public static class Concatenate<T>
    extends Combine.CombineFn<T, List<T>, List<T>> {
        @Override
        public List<T> createAccumulator() {
            return new ArrayList();
        }

        @Override
        public List<T> addInput(List<T> accumulator, T input) {
            accumulator.add(input);
            return accumulator;
        }

        @Override
        public List<T> mergeAccumulators(Iterable<List<T>> accumulators) {
            Object result = this.createAccumulator();
            for (List<T> accumulator : accumulators) {
                result.addAll(accumulator);
            }
            return result;
        }

        @Override
        public List<T> extractOutput(List<T> accumulator) {
            return accumulator;
        }

        @Override
        public Coder<List<T>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return ListCoder.of(inputCoder);
        }

        @Override
        public Coder<List<T>> getDefaultOutputCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return ListCoder.of(inputCoder);
        }
    }

    public static class CreatePCollectionView<ElemT, ViewT>
    extends PTransform<PCollection<ElemT>, PCollectionView<ViewT>> {
        private PCollectionView<ViewT> view;

        private CreatePCollectionView(PCollectionView<ViewT> view) {
            this.view = view;
        }

        public static <ElemT, ViewT> CreatePCollectionView<ElemT, ViewT> of(PCollectionView<ViewT> view) {
            return new CreatePCollectionView<ElemT, ViewT>(view);
        }

        @Override
        public PCollectionView<ViewT> apply(PCollection<ElemT> input) {
            return this.view;
        }

        static {
            DirectPipelineRunner.registerDefaultTransformEvaluator(CreatePCollectionView.class, new DirectPipelineRunner.TransformEvaluator<CreatePCollectionView>(){

                @Override
                public void evaluate(CreatePCollectionView transform, DirectPipelineRunner.EvaluationContext context) {
                    this.evaluateTyped(transform, context);
                }

                private <ElemT, ViewT> void evaluateTyped(CreatePCollectionView<ElemT, ViewT> transform, DirectPipelineRunner.EvaluationContext context) {
                    List elems = context.getPCollectionWindowedValues((PCollection)context.getInput(transform));
                    context.setPCollectionView((PCollectionView)context.getOutput(transform), elems);
                }
            });
        }
    }

    public static class AsMap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, V>>> {
        private AsMap() {
        }

        @Deprecated
        public AsMap<K, V> withSingletonValues() {
            return this;
        }

        @Override
        public void validate(PCollection<KV<K, V>> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
        }

        @Override
        public PCollectionView<Map<K, V>> apply(PCollection<KV<K, V>> input) {
            return (PCollectionView)((Object)input.apply(CreatePCollectionView.of(PCollectionViews.mapView(input.getPipeline(), input.getWindowingStrategy(), input.getCoder()))));
        }
    }

    public static class AsMultimap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, Iterable<V>>>> {
        private AsMultimap() {
        }

        @Override
        public void validate(PCollection<KV<K, V>> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
        }

        @Override
        public PCollectionView<Map<K, Iterable<V>>> apply(PCollection<KV<K, V>> input) {
            return (PCollectionView)((Object)input.apply(CreatePCollectionView.of(PCollectionViews.multimapView(input.getPipeline(), input.getWindowingStrategy(), input.getCoder()))));
        }
    }

    public static class AsSingleton<T>
    extends PTransform<PCollection<T>, PCollectionView<T>> {
        private final T defaultValue;
        private final boolean hasDefault;

        private AsSingleton() {
            this.defaultValue = null;
            this.hasDefault = false;
        }

        private AsSingleton(T defaultValue) {
            this.defaultValue = defaultValue;
            this.hasDefault = true;
        }

        public boolean hasDefaultValue() {
            return this.hasDefault;
        }

        public T defaultValue() {
            return this.defaultValue;
        }

        public AsSingleton<T> withDefaultValue(T defaultValue) {
            return new AsSingleton<T>(defaultValue);
        }

        @Override
        public void validate(PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
        }

        @Override
        public PCollectionView<T> apply(PCollection<T> input) {
            return (PCollectionView)input.apply(CreatePCollectionView.of(PCollectionViews.singletonView(input.getPipeline(), input.getWindowingStrategy(), this.hasDefault, this.defaultValue, input.getCoder())));
        }
    }

    public static class AsIterable<T>
    extends PTransform<PCollection<T>, PCollectionView<Iterable<T>>> {
        private AsIterable() {
        }

        @Override
        public void validate(PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
        }

        @Override
        public PCollectionView<Iterable<T>> apply(PCollection<T> input) {
            return (PCollectionView)((Object)input.apply(CreatePCollectionView.of(PCollectionViews.iterableView(input.getPipeline(), input.getWindowingStrategy(), input.getCoder()))));
        }
    }

    public static class AsList<T>
    extends PTransform<PCollection<T>, PCollectionView<List<T>>> {
        private AsList() {
        }

        @Override
        public void validate(PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
        }

        @Override
        public PCollectionView<List<T>> apply(PCollection<T> input) {
            return (PCollectionView)input.apply(Combine.globally(new Concatenate()).asSingletonView());
        }
    }
}

