/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterAll<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    private AfterAll(List<Trigger<W>> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static <W extends BoundedWindow> Trigger.OnceTrigger<W> of(Trigger.OnceTrigger<W> ... triggers) {
        return new AfterAll<W>(Arrays.asList(triggers));
    }

    private Trigger.TriggerResult result(Trigger.TriggerContext c) {
        if (c.trigger().areAllSubtriggersFinished()) {
            return Trigger.TriggerResult.FIRE_AND_FINISH;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        for (ExecutableTrigger subTrigger : c.trigger().unfinishedSubTriggers()) {
            subTrigger.invokeElement(c);
        }
        return this.result(c);
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        boolean fired = false;
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            Trigger.MergeResult result = subTrigger.invokeMerge(c);
            if (Trigger.MergeResult.CONTINUE.equals((Object)result)) {
                return Trigger.MergeResult.CONTINUE;
            }
            fired |= result.isFire();
        }
        return fired ? Trigger.MergeResult.FIRE_AND_FINISH : Trigger.MergeResult.ALREADY_FINISHED;
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        for (ExecutableTrigger subTrigger : c.trigger().unfinishedSubTriggers()) {
            subTrigger.invokeTimer(c);
        }
        return this.result(c);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        Instant deadline = BoundedWindow.TIMESTAMP_MIN_VALUE;
        for (Trigger subTrigger : this.subTriggers) {
            Instant subDeadline = subTrigger.getWatermarkThatGuaranteesFiring(window);
            if (!deadline.isBefore((ReadableInstant)subDeadline)) continue;
            deadline = subDeadline;
        }
        return deadline;
    }

    @Override
    public Trigger.OnceTrigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new AfterAll<W>(continuationTriggers);
    }
}

