/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterFirst<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    AfterFirst(List<Trigger<W>> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static <W extends BoundedWindow> Trigger.OnceTrigger<W> of(Trigger.OnceTrigger<W> ... triggers) {
        return new AfterFirst<W>(Arrays.asList(triggers));
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            if (!subTrigger.invokeElement(c).isFire()) continue;
            return Trigger.TriggerResult.FIRE_AND_FINISH;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        boolean fired = false;
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            Trigger.MergeResult mergeResult = subTrigger.invokeMerge(c);
            if (Trigger.MergeResult.ALREADY_FINISHED.equals((Object)mergeResult)) {
                return Trigger.MergeResult.ALREADY_FINISHED;
            }
            if (!mergeResult.isFire()) continue;
            fired = true;
        }
        return fired ? Trigger.MergeResult.FIRE_AND_FINISH : Trigger.MergeResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            if (!subTrigger.invokeTimer(c).isFire()) continue;
            return Trigger.TriggerResult.FIRE_AND_FINISH;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        Instant deadline = BoundedWindow.TIMESTAMP_MAX_VALUE;
        for (Trigger subTrigger : this.subTriggers) {
            Instant subDeadline = subTrigger.getWatermarkThatGuaranteesFiring(window);
            if (!deadline.isAfter((ReadableInstant)subDeadline)) continue;
            deadline = subDeadline;
        }
        return deadline;
    }

    @Override
    public Trigger.OnceTrigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new AfterFirst<W>(continuationTriggers);
    }
}

