/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.VarLongCoder;
import com.google.cloud.dataflow.sdk.transforms.Sum;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueState;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import java.util.List;
import java.util.Objects;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterPane<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    private static final StateTag<CombiningValueState<Long, Long>> ELEMENTS_IN_PANE_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), new Sum.SumLongFn()));
    private final int countElems;

    private AfterPane(int countElems) {
        super(null);
        this.countElems = countElems;
    }

    public static <W extends BoundedWindow> AfterPane<W> elementCountAtLeast(int countElems) {
        return new AfterPane<W>(countElems);
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        CombiningValueState<Long, Long> elementsInPane = c.state().access(ELEMENTS_IN_PANE_TAG);
        StateContents countContents = elementsInPane.get();
        elementsInPane.add(1L);
        long count = (Long)countContents.read();
        return count >= (long)this.countElems ? Trigger.TriggerResult.FIRE_AND_FINISH : Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        if (c.trigger().finishedInAnyMergingWindow()) {
            return Trigger.MergeResult.ALREADY_FINISHED;
        }
        CombiningValueState<Long, Long> elementsInPane = c.state().accessAcrossMergingWindows(ELEMENTS_IN_PANE_TAG);
        long count = (Long)elementsInPane.get().read();
        return count >= (long)this.countElems ? Trigger.MergeResult.FIRE_AND_FINISH : Trigger.MergeResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) {
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public void prefetchOnElement(ReduceFn.StateContext state) {
        state.access(ELEMENTS_IN_PANE_TAG).get();
    }

    @Override
    public void prefetchOnMerge(ReduceFn.MergingStateContext state) {
        state.accessAcrossMergingWindows(ELEMENTS_IN_PANE_TAG).get();
    }

    @Override
    public void prefetchOnTimer(ReduceFn.StateContext state) {
    }

    @Override
    public void clear(Trigger.TriggerContext c) throws Exception {
        c.state().access(ELEMENTS_IN_PANE_TAG).clear();
    }

    @Override
    public boolean isCompatible(Trigger<?> other) {
        return this.equals(other);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    public Trigger.OnceTrigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return AfterPane.elementCountAtLeast(1);
    }

    @Override
    public String toString() {
        int n = this.countElems;
        return new StringBuilder(42).append("AfterPane.elementCountAtLeast(").append(n).append(")").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterPane)) {
            return false;
        }
        AfterPane that = (AfterPane)obj;
        return this.countElems == that.countElems;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.countElems);
    }
}

