/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.AfterSynchronizedProcessingTime;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.TimeTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueState;
import java.util.List;
import java.util.Objects;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterProcessingTime<W extends BoundedWindow>
extends TimeTrigger<W> {
    private AfterProcessingTime(List<SerializableFunction<Instant, Instant>> transforms) {
        super(transforms);
    }

    public static <W extends BoundedWindow> AfterProcessingTime<W> pastFirstElementInPane() {
        return new AfterProcessingTime<W>(IDENTITY);
    }

    @Override
    protected AfterProcessingTime<W> newWith(List<SerializableFunction<Instant, Instant>> transforms) {
        return new AfterProcessingTime<W>(transforms);
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        CombiningValueState delayUntilState = (CombiningValueState)c.state().access(DELAYED_UNTIL_TAG);
        Instant delayUntil = (Instant)delayUntilState.get().read();
        if (delayUntil == null) {
            delayUntil = this.computeTargetTimestamp(c.timers().currentProcessingTime());
            c.timers().setTimer(delayUntil, TimeDomain.PROCESSING_TIME);
            delayUntilState.add(delayUntil);
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        if (c.trigger().finishedInAnyMergingWindow()) {
            return Trigger.MergeResult.ALREADY_FINISHED;
        }
        CombiningValueState mergingDelays = (CombiningValueState)c.state().accessAcrossMergingWindows(DELAYED_UNTIL_TAG);
        Instant earliestTimer = (Instant)mergingDelays.get().read();
        if (earliestTimer != null) {
            mergingDelays.clear();
            mergingDelays.add(earliestTimer);
            c.timers().setTimer(earliestTimer, TimeDomain.PROCESSING_TIME);
        }
        return Trigger.MergeResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        if (c.timeDomain() != TimeDomain.PROCESSING_TIME) {
            return Trigger.TriggerResult.CONTINUE;
        }
        Instant delayedUntil = (Instant)((CombiningValueState)c.state().access(DELAYED_UNTIL_TAG)).get().read();
        if (delayedUntil == null || delayedUntil.isAfter((ReadableInstant)c.timestamp())) {
            return Trigger.TriggerResult.CONTINUE;
        }
        return Trigger.TriggerResult.FIRE_AND_FINISH;
    }

    @Override
    public void prefetchOnElement(ReduceFn.StateContext state) {
        ((CombiningValueState)state.access(DELAYED_UNTIL_TAG)).get();
    }

    @Override
    public void prefetchOnMerge(ReduceFn.MergingStateContext state) {
        ((CombiningValueState)state.accessAcrossMergingWindows(DELAYED_UNTIL_TAG)).get();
    }

    @Override
    public void prefetchOnTimer(ReduceFn.StateContext state) {
        ((CombiningValueState)state.access(DELAYED_UNTIL_TAG)).get();
    }

    @Override
    public void clear(Trigger.TriggerContext c) throws Exception {
        CombiningValueState delayed = (CombiningValueState)c.state().access(DELAYED_UNTIL_TAG);
        Instant timestamp = (Instant)delayed.get().read();
        delayed.clear();
        if (timestamp != null) {
            c.timers().deleteTimer(timestamp, TimeDomain.PROCESSING_TIME);
        }
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new AfterSynchronizedProcessingTime();
    }

    @Override
    public String toString() {
        String string = String.valueOf(this.timestampMappers);
        return new StringBuilder(44 + String.valueOf(string).length()).append("AfterProcessingTime.pastFirstElementInPane(").append(string).append(")").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterProcessingTime)) {
            return false;
        }
        AfterProcessingTime that = (AfterProcessingTime)obj;
        return Objects.equals(this.timestampMappers, that.timestampMappers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.timestampMappers);
    }
}

