/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.TimeTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueState;
import java.util.List;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class AfterSynchronizedProcessingTime<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    public AfterSynchronizedProcessingTime() {
        super(null);
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        CombiningValueState<Instant, Instant> delayUntilState = c.state().access(TimeTrigger.DELAYED_UNTIL_TAG);
        Instant delayUntil = (Instant)delayUntilState.get().read();
        if (delayUntil == null) {
            delayUntil = c.timers().currentProcessingTime();
            c.timers().setTimer(delayUntil, TimeDomain.SYNCHRONIZED_PROCESSING_TIME);
            delayUntilState.add(delayUntil);
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        if (c.trigger().finishedInAnyMergingWindow()) {
            return Trigger.MergeResult.ALREADY_FINISHED;
        }
        CombiningValueState<Instant, Instant> mergingDelays = c.state().accessAcrossMergingWindows(TimeTrigger.DELAYED_UNTIL_TAG);
        Instant earliestTimer = (Instant)mergingDelays.get().read();
        if (earliestTimer != null) {
            mergingDelays.clear();
            mergingDelays.add(earliestTimer);
            c.timers().setTimer(earliestTimer, TimeDomain.SYNCHRONIZED_PROCESSING_TIME);
        }
        return Trigger.MergeResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        if (c.timeDomain() != TimeDomain.SYNCHRONIZED_PROCESSING_TIME) {
            return Trigger.TriggerResult.CONTINUE;
        }
        Instant delayedUntil = (Instant)c.state().access(TimeTrigger.DELAYED_UNTIL_TAG).get().read();
        if (delayedUntil == null || delayedUntil.isAfter((ReadableInstant)c.timestamp())) {
            return Trigger.TriggerResult.CONTINUE;
        }
        return Trigger.TriggerResult.FIRE_AND_FINISH;
    }

    @Override
    public void prefetchOnElement(ReduceFn.StateContext state) {
        state.access(TimeTrigger.DELAYED_UNTIL_TAG).get();
    }

    @Override
    public void prefetchOnMerge(ReduceFn.MergingStateContext state) {
        state.accessAcrossMergingWindows(TimeTrigger.DELAYED_UNTIL_TAG).get();
    }

    @Override
    public void prefetchOnTimer(ReduceFn.StateContext state) {
        state.access(TimeTrigger.DELAYED_UNTIL_TAG).get();
    }

    @Override
    public void clear(Trigger.TriggerContext c) throws Exception {
        CombiningValueState<Instant, Instant> delayed = c.state().access(TimeTrigger.DELAYED_UNTIL_TAG);
        Instant timestamp = (Instant)delayed.get().read();
        delayed.clear();
        if (timestamp != null) {
            c.timers().deleteTimer(timestamp, TimeDomain.SYNCHRONIZED_PROCESSING_TIME);
        }
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return this;
    }

    @Override
    public String toString() {
        return "AfterSynchronizedProcessingTime.pastFirstElementInPane()";
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof AfterSynchronizedProcessingTime;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(AfterSynchronizedProcessingTime.class);
    }
}

