/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import java.util.List;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class DefaultTrigger<W extends BoundedWindow>
extends Trigger<W> {
    private DefaultTrigger() {
        super(null);
    }

    public static <W extends BoundedWindow> DefaultTrigger<W> of() {
        return new DefaultTrigger<W>();
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        c.timers().setTimer(((BoundedWindow)c.window()).maxTimestamp(), TimeDomain.EVENT_TIME);
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        c.timers().setTimer(((BoundedWindow)c.window()).maxTimestamp(), TimeDomain.EVENT_TIME);
        return Trigger.MergeResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        return Trigger.TriggerResult.FIRE;
    }

    @Override
    public void clear(Trigger.TriggerContext c) throws Exception {
        c.timers().deleteTimer(((BoundedWindow)c.window()).maxTimestamp(), TimeDomain.EVENT_TIME);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return ((BoundedWindow)window).maxTimestamp();
    }

    @Override
    public boolean isCompatible(Trigger<?> other) {
        return other instanceof DefaultTrigger;
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return this;
    }
}

